/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.counter.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.counter.kernel.exception.NoSuchCounterException;
import com.liferay.counter.kernel.model.Counter;
import com.liferay.counter.kernel.service.persistence.CounterPersistence;
import com.liferay.counter.model.impl.CounterImpl;
import com.liferay.counter.model.impl.CounterModelImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class CounterPersistenceImpl
extends BasePersistenceImpl<Counter>
implements CounterPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CounterImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterModelImpl.FINDER_CACHE_ENABLED, CounterImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterModelImpl.FINDER_CACHE_ENABLED, CounterImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_COUNTER = "SELECT counter FROM Counter counter";
    private static final String _SQL_SELECT_COUNTER_WHERE_PKS_IN = "SELECT counter FROM Counter counter WHERE name IN (";
    private static final String _SQL_COUNT_COUNTER = "SELECT COUNT(counter) FROM Counter counter";
    private static final String _ORDER_BY_ENTITY_ALIAS = "counter.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Counter exists with the primary key ";
    private static final Log _log = LogFactoryUtil.getLog(CounterPersistenceImpl.class);

    public CounterPersistenceImpl() {
        this.setModelClass(Counter.class);
    }

    public void cacheResult(Counter counter) {
        this.entityCache.putResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, (Serializable)((Object)counter.getPrimaryKey()), (Serializable)counter);
        counter.resetOriginalValues();
    }

    public void cacheResult(List<Counter> counters) {
        for (Counter counter : counters) {
            if (this.entityCache.getResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, (Serializable)((Object)counter.getPrimaryKey())) == null) {
                this.cacheResult(counter);
                continue;
            }
            counter.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CounterImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Counter counter) {
        this.entityCache.removeResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, (Serializable)((Object)counter.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<Counter> counters) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Counter counter : counters) {
            this.entityCache.removeResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, (Serializable)((Object)counter.getPrimaryKey()));
        }
    }

    public Counter create(String name) {
        CounterImpl counter = new CounterImpl();
        counter.setNew(true);
        counter.setPrimaryKey(name);
        return counter;
    }

    public Counter remove(String name) throws NoSuchCounterException {
        return this.remove((Serializable)((Object)name));
    }

    public Counter remove(Serializable primaryKey) throws NoSuchCounterException {
        Session session = null;
        try {
            session = this.openSession();
            Counter counter = (Counter)session.get(CounterImpl.class, primaryKey);
            if (counter == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCounterException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Counter counter2 = (Counter)this.remove((BaseModel)counter);
            return counter2;
        }
        catch (NoSuchCounterException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Counter removeImpl(Counter counter) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)counter)) {
                counter = (Counter)session.get(CounterImpl.class, counter.getPrimaryKeyObj());
            }
            if (counter != null) {
                session.delete((Object)counter);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (counter != null) {
            this.clearCache(counter);
        }
        return counter;
    }

    public Counter updateImpl(Counter counter) {
        boolean isNew = counter.isNew();
        Session session = null;
        try {
            session = this.openSession();
            if (counter.isNew()) {
                session.save((Object)counter);
                counter.setNew(false);
            } else {
                counter = (Counter)session.merge((Object)counter);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew) {
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        }
        this.entityCache.putResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, (Serializable)((Object)counter.getPrimaryKey()), (Serializable)counter, false);
        counter.resetOriginalValues();
        return counter;
    }

    public Counter findByPrimaryKey(Serializable primaryKey) throws NoSuchCounterException {
        Counter counter = this.fetchByPrimaryKey(primaryKey);
        if (counter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCounterException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return counter;
    }

    public Counter findByPrimaryKey(String name) throws NoSuchCounterException {
        return this.findByPrimaryKey((Serializable)((Object)name));
    }

    public Counter fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Counter counter = (Counter)serializable;
        if (counter == null) {
            Session session = null;
            try {
                session = this.openSession();
                counter = (Counter)session.get(CounterImpl.class, primaryKey);
                if (counter != null) {
                    this.cacheResult(counter);
                } else {
                    this.entityCache.putResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return counter;
    }

    public Counter fetchByPrimaryKey(String name) {
        return this.fetchByPrimaryKey((Serializable)((Object)name));
    }

    public Map<Serializable, Counter> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Counter> map = new HashMap<Serializable, Counter>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Counter counter = this.fetchByPrimaryKey(primaryKey);
            if (counter != null) {
                map.put(primaryKey, counter);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            Serializable serializable = this.entityCache.getResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, primaryKey);
            if (serializable == nullModel) continue;
            if (serializable == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, (Counter)serializable);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COUNTER_WHERE_PKS_IN);
        for (int i = 0; i < uncachedPrimaryKeys.size(); ++i) {
            query.append("?");
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                qPos.add((String)((Object)primaryKey));
            }
            for (Counter counter : q.list()) {
                map.put(counter.getPrimaryKeyObj(), counter);
                this.cacheResult(counter);
                uncachedPrimaryKeys.remove(counter.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                this.entityCache.putResult(CounterModelImpl.ENTITY_CACHE_ENABLED, CounterImpl.class, primaryKey, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<Counter> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Counter> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Counter> findAll(int start, int end, OrderByComparator<Counter> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Counter> findAll(int start, int end, OrderByComparator<Counter> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COUNTER);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COUNTER;
                if (pagination) {
                    sql = sql.concat(" ORDER BY counter.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Counter counter : this.findAll()) {
            this.remove((BaseModel)counter);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COUNTER);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CounterModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(CounterImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

