/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;

public class LiferayPropertyAccessor
extends BasicPropertyAccessor {
    private static final Log _log = LogFactoryUtil.getLog(LiferayPropertyAccessor.class);

    public Getter getGetter(Class clazz, String propertyName) throws PropertyNotFoundException {
        String methodNameSuffix = TextFormatter.format((String)propertyName, (int)6);
        String getterMethodName = "get".concat(methodNameSuffix);
        try {
            Method getterMethod = clazz.getMethod(getterMethodName, new Class[0]);
            return new LiferayPropertyGetter(getterMethod, propertyName);
        }
        catch (NoSuchMethodException nsme) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Getter not found for ", clazz.getName(), "#", propertyName}), (Throwable)nsme);
            }
            return super.getGetter(clazz, propertyName);
        }
    }

    public Setter getSetter(Class clazz, String propertyName) throws PropertyNotFoundException {
        String methodNameSuffix = TextFormatter.format((String)propertyName, (int)6);
        String getterMethodName = "get".concat(methodNameSuffix);
        String setterMethodName = "set".concat(methodNameSuffix);
        try {
            Method getterMethod = clazz.getMethod(getterMethodName, new Class[0]);
            Method setterMethod = clazz.getMethod(setterMethodName, getterMethod.getReturnType());
            return new LiferayPropertySetter(setterMethod, propertyName);
        }
        catch (NoSuchMethodException nsme) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Setter not found for ", clazz.getName(), "#", propertyName}), (Throwable)nsme);
            }
            return super.getSetter(clazz, propertyName);
        }
    }

    private static class LiferayPropertySetter
    implements Setter {
        private final Method _method;
        private final String _propertyName;

        public Method getMethod() {
            return this._method;
        }

        public String getMethodName() {
            return this._method.getName();
        }

        public void set(Object target, Object value, SessionFactoryImplementor sessionFactoryImplementor) throws PropertyAccessException {
            try {
                this._method.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                throw new PropertyAccessException((Throwable)e, e.getMessage(), true, this._method.getDeclaringClass(), this._propertyName);
            }
        }

        private LiferayPropertySetter(Method method, String propertyName) {
            this._method = method;
            this._propertyName = propertyName;
        }
    }

    private static class LiferayPropertyGetter
    implements Getter {
        private final Method _method;
        private final String _propertyName;

        public Object get(Object target) throws PropertyAccessException {
            try {
                return this._method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new PropertyAccessException((Throwable)e, e.getMessage(), false, this._method.getDeclaringClass(), this._propertyName);
            }
        }

        public Object getForInsert(Object target, Map mergeMap, SessionImplementor sessionImplementor) throws PropertyAccessException {
            return this.get(target);
        }

        public Member getMember() {
            return this._method;
        }

        public Method getMethod() {
            return this._method;
        }

        public String getMethodName() {
            return this._method.getName();
        }

        public Class getReturnType() {
            return this._method.getReturnType();
        }

        private LiferayPropertyGetter(Method method, String propertyName) {
            this._method = method;
            this._propertyName = propertyName;
        }
    }
}

