/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.liferay.portal.internal.minifier.MinifierThreadLocal;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.minifier.CSSCompressor;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.io.Reader;
import java.io.Writer;

public class MinifierUtil {
    private static final Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static final ServiceTracker<JavaScriptMinifier, JavaScriptMinifier> _javaScriptMinifierServiceTracker;

    public static String minifyCss(String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyCss(content);
        }
        return content;
    }

    public static String minifyJavaScript(String resourceName, String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyJavaScript(resourceName, content);
        }
        return content;
    }

    private static String _minifyCss(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            CSSCompressor cssCompressor = new CSSCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
            return unsyncStringWriter.toString();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to minify CSS:\n" + content), (Throwable)e);
            unsyncStringWriter.append((CharSequence)content);
            return unsyncStringWriter.toString();
        }
    }

    private static String _minifyJavaScript(String resourceName, String content) {
        JavaScriptMinifier javaScriptMinifier = (JavaScriptMinifier)_javaScriptMinifierServiceTracker.getService();
        if (javaScriptMinifier == null) {
            return content;
        }
        return javaScriptMinifier.compress(resourceName, content);
    }

    private MinifierUtil() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _javaScriptMinifierServiceTracker = registry.trackServices(JavaScriptMinifier.class);
        _javaScriptMinifierServiceTracker.open();
    }
}

