/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DLFileEntryServiceAdapter {
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final DLFileEntryService _dlFileEntryService;

    public static DLFileEntryServiceAdapter create(DocumentRepository documentRepository) {
        if (documentRepository instanceof LocalRepository) {
            return new DLFileEntryServiceAdapter(DLFileEntryLocalServiceUtil.getService());
        }
        return new DLFileEntryServiceAdapter(DLFileEntryLocalServiceUtil.getService(), DLFileEntryServiceUtil.getService());
    }

    public DLFileEntryServiceAdapter(DLFileEntryLocalService dlFileEntryLocalService) {
        this(dlFileEntryLocalService, null);
    }

    public DLFileEntryServiceAdapter(DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._dlFileEntryService = dlFileEntryService;
    }

    public DLFileEntry fetchDLFileEntryByImageId(long imageId) throws PortalException {
        DLFileEntry dlFileEntry = null;
        dlFileEntry = this._dlFileEntryService != null ? this._dlFileEntryService.fetchFileEntryByImageId(imageId) : this._dlFileEntryLocalService.fetchFileEntryByAnyImageId(imageId);
        return dlFileEntry;
    }

    public ActionableDynamicQuery getActionableDynamicQuery() throws PortalException {
        if (this._dlFileEntryService != null) {
            throw new PrincipalException("DL file entry service is not null");
        }
        return this._dlFileEntryLocalService.getActionableDynamicQuery();
    }

    public DLFileEntry getDLFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = null;
        dlFileEntry = this._dlFileEntryService != null ? this._dlFileEntryService.getFileEntry(fileEntryId) : this._dlFileEntryLocalService.getFileEntry(fileEntryId);
        return dlFileEntry;
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int userId, long repositoryId, long folderId, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        List dlFileEntries = null;
        dlFileEntries = this._dlFileEntryService != null ? this._dlFileEntryService.getGroupFileEntries(groupId, (long)userId, repositoryId, folderId, null, -1, start, end, obc) : this._dlFileEntryLocalService.getGroupFileEntries(groupId, (long)userId, repositoryId, folderId, start, end, obc);
        return dlFileEntries;
    }

    @Deprecated
    public boolean isKeepFileVersionLabel(long fileEntryId, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        if (this._dlFileEntryService != null) {
            return this._dlFileEntryService.isKeepFileVersionLabel(fileEntryId, majorVersion, serviceContext);
        }
        return this._dlFileEntryLocalService.isKeepFileVersionLabel(fileEntryId, majorVersion, serviceContext);
    }

    public DLFileEntry updateStatus(long userId, long fileVersionId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        DLFileEntry dlFileEntry = null;
        dlFileEntry = this._dlFileEntryService != null ? this._dlFileEntryService.updateStatus(userId, fileVersionId, status, serviceContext, workflowContext) : this._dlFileEntryLocalService.updateStatus(userId, fileVersionId, status, serviceContext, workflowContext);
        return dlFileEntry;
    }
}

