/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.agent;

import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.ServletInputStreamAdapter;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.resiliency.spi.agent.SPIAgentSerializable;
import com.liferay.portal.upload.UploadServletRequestImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SPIAgentRequest
extends SPIAgentSerializable {
    protected String contentType;
    protected byte[][] cookiesBytes;
    protected Map<String, Serializable> distributedRequestAttributes;
    protected Map<String, List<String>> headerMap;
    protected Map<String, FileItem[]> multipartParameterMap;
    protected Map<String, Serializable> originalSessionAttributes;
    protected Map<String, String[]> parameterMap;
    protected Map<String, List<String>> regularParameterMap;
    protected String remoteAddr;
    protected String remoteHost;
    protected int remotePort;
    protected String remoteUser;
    protected File requestBodyFile;
    protected String serverName;
    protected int serverPort;

    public static void populatePortletSessionAttributes(HttpServletRequest request, HttpSession session) {
        if (!SPIUtil.isSPI()) {
            return;
        }
        if (request.getAttribute("PORTLET_SESSION") != null) {
            return;
        }
        SPIAgentRequest spiAgentRequest = (SPIAgentRequest)request.getAttribute("SPI_AGENT_REQUEST");
        if (spiAgentRequest == null) {
            return;
        }
        request.setAttribute("PORTLET_SESSION", (Object)session);
        Map<String, Serializable> originalSessionAttributes = spiAgentRequest.originalSessionAttributes;
        Map portletSessionAttributes = (Map)((Object)originalSessionAttributes.remove("PORTLET_SESSION_ATTRIBUTES_".concat(spiAgentRequest.servletContextName)));
        Set sessionAttributeNames = SetUtil.fromEnumeration((Enumeration)session.getAttributeNames());
        if (portletSessionAttributes != null) {
            for (Map.Entry entry : portletSessionAttributes.entrySet()) {
                session.setAttribute((String)entry.getKey(), entry.getValue());
            }
            sessionAttributeNames.removeAll(portletSessionAttributes.keySet());
        }
        for (String string : sessionAttributeNames) {
            session.removeAttribute(string);
        }
    }

    public SPIAgentRequest(HttpServletRequest request) throws IOException {
        super(((Portlet)request.getAttribute("SPI_AGENT_PORTLET")).getContextName());
        ThemeDisplay themeDisplay;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            this.cookiesBytes = new byte[cookies.length][];
            for (int i = 0; i < cookies.length; ++i) {
                this.cookiesBytes[i] = CookieUtil.serialize((Cookie)cookies[i]);
            }
        }
        this.distributedRequestAttributes = SPIAgentRequest.extractDistributedRequestAttributes(request, Direction.REQUEST);
        this.headerMap = SPIAgentRequest.extractRequestHeaders(request);
        this.parameterMap = new HashMap<String, String[]>(request.getParameterMap());
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.remotePort = request.getRemotePort();
        this.remoteUser = request.getRemoteUser();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/")) {
            HttpServletRequest currentRequest = request;
            UploadServletRequest uploadServletRequest = null;
            while (currentRequest instanceof HttpServletRequestWrapper) {
                if (currentRequest instanceof UploadServletRequest) {
                    uploadServletRequest = (UploadServletRequest)currentRequest;
                    break;
                }
                HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentRequest;
                currentRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            }
            if (uploadServletRequest == null) {
                this.contentType = contentType;
                this.requestBodyFile = FileUtil.createTempFile();
                StreamUtil.transfer((InputStream)StreamUtil.uncloseable((InputStream)currentRequest.getInputStream()), (OutputStream)new FileOutputStream(this.requestBodyFile));
                uploadServletRequest = new UploadServletRequestImpl((HttpServletRequest)new AgentHttpServletRequestWrapper(currentRequest));
            }
            Map multipartParameterMap = uploadServletRequest.getMultipartParameterMap();
            Map regularParameterMap = uploadServletRequest.getRegularParameterMap();
            if (!multipartParameterMap.isEmpty()) {
                this.multipartParameterMap = multipartParameterMap;
            }
            if (!regularParameterMap.isEmpty()) {
                this.regularParameterMap = regularParameterMap;
            }
        }
        if ((themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")) != null && themeDisplay.isAjax()) {
            this.parameterMap = new HashMap<String, String[]>(this.parameterMap);
            this.parameterMap.put("portalResiliencyPortletShowFooter", new String[]{"false"});
        }
        this.originalSessionAttributes = SPIAgentRequest.extractSessionAttributes(request);
        this.captureThreadLocals();
    }

    public Map<String, Serializable> getOriginalSessionAttributes() {
        return this.originalSessionAttributes;
    }

    public HttpServletRequest populateRequest(HttpServletRequest request) {
        request = new AgentHttpServletRequestWrapper((HttpServletRequest)request);
        for (Map.Entry<String, Serializable> entry : this.distributedRequestAttributes.entrySet()) {
            request.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        if (this.multipartParameterMap != null || this.regularParameterMap != null) {
            request = new UploadServletRequestImpl((HttpServletRequest)request, this.multipartParameterMap, this.regularParameterMap);
        }
        this.restoreThreadLocals();
        return request;
    }

    public void populateSessionAttributes(HttpSession session) {
        for (Map.Entry<String, Serializable> entry : this.originalSessionAttributes.entrySet()) {
            session.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
    }

    public String toString() {
        int length = 20 + this.parameterMap.size() * 4;
        if (this.cookiesBytes != null) {
            length += this.cookiesBytes.length * 2 - 1;
        }
        StringBundler sb = new StringBundler(length);
        sb.append("{contentType=");
        sb.append(this.contentType);
        sb.append(", cookies=[");
        if (this.cookiesBytes != null) {
            for (byte[] cookieBytes : this.cookiesBytes) {
                Cookie cookie = CookieUtil.deserialize((byte[])cookieBytes);
                sb.append(CookieUtil.toString((Cookie)cookie));
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
        }
        sb.append("], distributedRequestAttributes=");
        sb.append(this.distributedRequestAttributes);
        sb.append(", headerMap=");
        sb.append(this.headerMap);
        sb.append(", multipartParameterMap=");
        sb.append(this.multipartParameterMap);
        sb.append(", originalSessionAttributes=");
        sb.append(this.originalSessionAttributes);
        sb.append(", parameterMap={");
        Object object = this.parameterMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(Arrays.toString((Object[])entry.getValue()));
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("}, regularParameterMap=");
        sb.append(this.regularParameterMap);
        sb.append(", requestBodyFile=");
        sb.append((Object)this.requestBodyFile);
        sb.append(", serverName=");
        sb.append(this.serverName);
        sb.append(", serverPort=");
        sb.append(this.serverPort);
        sb.append("}");
        return sb.toString();
    }

    protected class AgentHttpServletRequestWrapper
    extends PersistentHttpServletRequestWrapper {
        public AgentHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public int getContentLength() {
            if (SPIAgentRequest.this.requestBodyFile != null) {
                return (int)SPIAgentRequest.this.requestBodyFile.length();
            }
            return super.getContentLength();
        }

        public String getContentType() {
            if (SPIAgentRequest.this.contentType != null) {
                return SPIAgentRequest.this.contentType;
            }
            return super.getContentType();
        }

        public Cookie[] getCookies() {
            if (SPIAgentRequest.this.cookiesBytes == null) {
                return null;
            }
            Cookie[] cookies = new Cookie[SPIAgentRequest.this.cookiesBytes.length];
            for (int i = 0; i < cookies.length; ++i) {
                cookies[i] = CookieUtil.deserialize((byte[])SPIAgentRequest.this.cookiesBytes[i]);
            }
            return cookies;
        }

        public String getHeader(String name) {
            List<String> values = SPIAgentRequest.this.headerMap.get(StringUtil.toLowerCase((String)name));
            if (values == null || values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(SPIAgentRequest.this.headerMap.keySet());
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> values = SPIAgentRequest.this.headerMap.get(StringUtil.toLowerCase((String)name));
            if (values == null) {
                values = Collections.emptyList();
            }
            return Collections.enumeration(values);
        }

        public ServletInputStream getInputStream() throws IOException {
            if (SPIAgentRequest.this.requestBodyFile != null) {
                return new ServletInputStreamAdapter((InputStream)new AutoDeleteFileInputStream(SPIAgentRequest.this.requestBodyFile));
            }
            return super.getInputStream();
        }

        public String getParameter(String name) {
            Object[] values = SPIAgentRequest.this.parameterMap.get(name);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                return values[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return SPIAgentRequest.this.parameterMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(SPIAgentRequest.this.parameterMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return SPIAgentRequest.this.parameterMap.get(name);
        }

        public String getRemoteAddr() {
            return SPIAgentRequest.this.remoteAddr;
        }

        public String getRemoteHost() {
            return SPIAgentRequest.this.remoteHost;
        }

        public int getRemotePort() {
            return SPIAgentRequest.this.remotePort;
        }

        public String getRemoteUser() {
            return SPIAgentRequest.this.remoteUser;
        }

        public String getServerName() {
            return SPIAgentRequest.this.serverName;
        }

        public int getServerPort() {
            return SPIAgentRequest.this.serverPort;
        }
    }
}

