/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.security.access.control.AccessControl;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.portal.security.access.control.AccessControlAdvisorImpl;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;

public class AccessControlAdvice
extends AnnotationChainableMethodAdvice<AccessControlled> {
    private AccessControlAdvisor _accessControlAdvisor = new AccessControlAdvisorImpl();

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        this.incrementServiceDepth();
        AccessControlled accessControlled = (AccessControlled)this.findAnnotation(methodInvocation);
        if (accessControlled == AccessControl.NULL_ACCESS_CONTROLLED) {
            return null;
        }
        this._accessControlAdvisor.accept(methodInvocation, accessControlled);
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        this.decrementServiceDepth();
    }

    @Override
    public AccessControlled getNullAnnotation() {
        return AccessControl.NULL_ACCESS_CONTROLLED;
    }

    @Deprecated
    public void setAccessControlAdvisor(AccessControlAdvisor accessControlAdvisor) {
        this._accessControlAdvisor = accessControlAdvisor;
    }

    protected void decrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            return;
        }
        Integer n = serviceDepth;
        Integer n2 = serviceDepth = Integer.valueOf(serviceDepth - 1);
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }

    protected void incrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            serviceDepth = 1;
        } else {
            Integer n = serviceDepth;
            Integer n2 = serviceDepth = Integer.valueOf(serviceDepth + 1);
        }
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }
}

