/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.impl.VirtualHostImpl;
import com.liferay.portal.model.impl.VirtualHostModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class VirtualHostPersistenceImpl
extends BasePersistenceImpl<VirtualHost>
implements VirtualHostPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = VirtualHostImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_HOSTNAME = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByHostname", new String[]{String.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_HOSTNAME = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByHostname", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_1 = "virtualHost.hostname IS NULL";
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_2 = "virtualHost.hostname = ?";
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_3 = "(virtualHost.hostname IS NULL OR virtualHost.hostname = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_L = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_L", new String[]{Long.class.getName(), Long.class.getName()}, 5L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_L = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_C_L_COMPANYID_2 = "virtualHost.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_LAYOUTSETID_2 = "virtualHost.layoutSetId = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_VIRTUALHOST = "SELECT virtualHost FROM VirtualHost virtualHost";
    private static final String _SQL_SELECT_VIRTUALHOST_WHERE_PKS_IN = "SELECT virtualHost FROM VirtualHost virtualHost WHERE virtualHostId IN (";
    private static final String _SQL_SELECT_VIRTUALHOST_WHERE = "SELECT virtualHost FROM VirtualHost virtualHost WHERE ";
    private static final String _SQL_COUNT_VIRTUALHOST = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost";
    private static final String _SQL_COUNT_VIRTUALHOST_WHERE = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "virtualHost.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No VirtualHost exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No VirtualHost exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(VirtualHostPersistenceImpl.class);

    public VirtualHost findByHostname(String hostname) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByHostname(hostname);
        if (virtualHost == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("hostname=");
            msg.append(hostname);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchVirtualHostException(msg.toString());
        }
        return virtualHost;
    }

    public VirtualHost fetchByHostname(String hostname) {
        return this.fetchByHostname(hostname, true);
    }

    public VirtualHost fetchByHostname(String hostname, boolean retrieveFromCache) {
        VirtualHost virtualHost;
        Object[] finderArgs = new Object[]{hostname};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_HOSTNAME, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof VirtualHost && !Objects.equals(hostname, (virtualHost = (VirtualHost)result).getHostname())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname == null) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_1);
            } else if (hostname.equals("")) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindHostname) {
                    qPos.add(hostname);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_HOSTNAME, finderArgs, (Object)list);
                } else {
                    VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                    result = virtualHost2;
                    this.cacheResult(virtualHost2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_HOSTNAME, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    public VirtualHost removeByHostname(String hostname) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByHostname(hostname);
        return (VirtualHost)this.remove((BaseModel)virtualHost);
    }

    public int countByHostname(String hostname) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_HOSTNAME;
        Object[] finderArgs = new Object[]{hostname};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname == null) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_1);
            } else if (hostname.equals("")) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindHostname) {
                    qPos.add(hostname);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHost findByC_L(long companyId, long layoutSetId) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByC_L(companyId, layoutSetId);
        if (virtualHost == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", layoutSetId=");
            msg.append(layoutSetId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchVirtualHostException(msg.toString());
        }
        return virtualHost;
    }

    public VirtualHost fetchByC_L(long companyId, long layoutSetId) {
        return this.fetchByC_L(companyId, layoutSetId, true);
    }

    public VirtualHost fetchByC_L(long companyId, long layoutSetId, boolean retrieveFromCache) {
        VirtualHost virtualHost;
        Object[] finderArgs = new Object[]{companyId, layoutSetId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_C_L, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof VirtualHost && (companyId != (virtualHost = (VirtualHost)result).getCompanyId() || layoutSetId != virtualHost.getLayoutSetId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            query.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(layoutSetId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_L, finderArgs, (Object)list);
                } else {
                    VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                    result = virtualHost2;
                    this.cacheResult(virtualHost2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_L, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    public VirtualHost removeByC_L(long companyId, long layoutSetId) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByC_L(companyId, layoutSetId);
        return (VirtualHost)this.remove((BaseModel)virtualHost);
    }

    public int countByC_L(long companyId, long layoutSetId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_L;
        Object[] finderArgs = new Object[]{companyId, layoutSetId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            query.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(layoutSetId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHostPersistenceImpl() {
        this.setModelClass(VirtualHost.class);
    }

    public void cacheResult(VirtualHost virtualHost) {
        this.entityCache.putResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()), (Serializable)virtualHost);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_HOSTNAME, new Object[]{virtualHost.getHostname()}, (Object)virtualHost);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_L, new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId()}, (Object)virtualHost);
        virtualHost.resetOriginalValues();
    }

    public void cacheResult(List<VirtualHost> virtualHosts) {
        for (VirtualHost virtualHost : virtualHosts) {
            if (this.entityCache.getResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey())) == null) {
                this.cacheResult(virtualHost);
                continue;
            }
            virtualHost.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(VirtualHostImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(VirtualHost virtualHost) {
        this.entityCache.removeResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((VirtualHostModelImpl)virtualHost, true);
    }

    public void clearCache(List<VirtualHost> virtualHosts) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (VirtualHost virtualHost : virtualHosts) {
            this.entityCache.removeResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()));
            this.clearUniqueFindersCache((VirtualHostModelImpl)virtualHost, true);
        }
    }

    protected void cacheUniqueFindersCache(VirtualHostModelImpl virtualHostModelImpl) {
        Object[] args = new Object[]{virtualHostModelImpl.getHostname()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_HOSTNAME, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_HOSTNAME, args, (Object)virtualHostModelImpl, false);
        args = new Object[]{virtualHostModelImpl.getCompanyId(), virtualHostModelImpl.getLayoutSetId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_C_L, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_L, args, (Object)virtualHostModelImpl, false);
    }

    protected void clearUniqueFindersCache(VirtualHostModelImpl virtualHostModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{virtualHostModelImpl.getHostname()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_HOSTNAME, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_HOSTNAME, args);
        }
        if ((virtualHostModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_HOSTNAME.getColumnBitmask()) != 0L) {
            args = new Object[]{virtualHostModelImpl.getOriginalHostname()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_HOSTNAME, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_HOSTNAME, args);
        }
        if (clearCurrent) {
            args = new Object[]{virtualHostModelImpl.getCompanyId(), virtualHostModelImpl.getLayoutSetId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_L, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_L, args);
        }
        if ((virtualHostModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_L.getColumnBitmask()) != 0L) {
            args = new Object[]{virtualHostModelImpl.getOriginalCompanyId(), virtualHostModelImpl.getOriginalLayoutSetId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_L, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_L, args);
        }
    }

    public VirtualHost create(long virtualHostId) {
        VirtualHostImpl virtualHost = new VirtualHostImpl();
        virtualHost.setNew(true);
        virtualHost.setPrimaryKey(virtualHostId);
        virtualHost.setCompanyId(this.companyProvider.getCompanyId());
        return virtualHost;
    }

    public VirtualHost remove(long virtualHostId) throws NoSuchVirtualHostException {
        return this.remove(Long.valueOf(virtualHostId));
    }

    public VirtualHost remove(Serializable primaryKey) throws NoSuchVirtualHostException {
        Session session = null;
        try {
            session = this.openSession();
            VirtualHost virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
            if (virtualHost == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            VirtualHost virtualHost2 = (VirtualHost)this.remove((BaseModel)virtualHost);
            return virtualHost2;
        }
        catch (NoSuchVirtualHostException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected VirtualHost removeImpl(VirtualHost virtualHost) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)virtualHost)) {
                virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, virtualHost.getPrimaryKeyObj());
            }
            if (virtualHost != null) {
                session.delete((Object)virtualHost);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (virtualHost != null) {
            this.clearCache(virtualHost);
        }
        return virtualHost;
    }

    public VirtualHost updateImpl(VirtualHost virtualHost) {
        boolean isNew = virtualHost.isNew();
        if (!(virtualHost instanceof VirtualHostModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(virtualHost.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)virtualHost);
                throw new IllegalArgumentException("Implement ModelWrapper in virtualHost proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom VirtualHost implementation " + virtualHost.getClass());
        }
        VirtualHostModelImpl virtualHostModelImpl = (VirtualHostModelImpl)virtualHost;
        Session session = null;
        try {
            session = this.openSession();
            if (virtualHost.isNew()) {
                session.save((Object)virtualHost);
                virtualHost.setNew(false);
            } else {
                virtualHost = (VirtualHost)session.merge((Object)virtualHost);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!VirtualHostModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        }
        this.entityCache.putResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()), (Serializable)virtualHost, false);
        this.clearUniqueFindersCache(virtualHostModelImpl, false);
        this.cacheUniqueFindersCache(virtualHostModelImpl);
        virtualHost.resetOriginalValues();
        return virtualHost;
    }

    public VirtualHost findByPrimaryKey(Serializable primaryKey) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByPrimaryKey(primaryKey);
        if (virtualHost == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return virtualHost;
    }

    public VirtualHost findByPrimaryKey(long virtualHostId) throws NoSuchVirtualHostException {
        return this.findByPrimaryKey(Long.valueOf(virtualHostId));
    }

    public VirtualHost fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        VirtualHost virtualHost = (VirtualHost)serializable;
        if (virtualHost == null) {
            Session session = null;
            try {
                session = this.openSession();
                virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
                if (virtualHost != null) {
                    this.cacheResult(virtualHost);
                } else {
                    this.entityCache.putResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return virtualHost;
    }

    public VirtualHost fetchByPrimaryKey(long virtualHostId) {
        return this.fetchByPrimaryKey(Long.valueOf(virtualHostId));
    }

    public Map<Serializable, VirtualHost> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, VirtualHost> map = new HashMap<Serializable, VirtualHost>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            VirtualHost virtualHost = this.fetchByPrimaryKey(primaryKey);
            if (virtualHost != null) {
                map.put(primaryKey, virtualHost);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (VirtualHost)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_VIRTUALHOST_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (VirtualHost virtualHost : q.list()) {
                map.put(virtualHost.getPrimaryKeyObj(), virtualHost);
                this.cacheResult(virtualHost);
                uncachedPrimaryKeys.remove(virtualHost.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<VirtualHost> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<VirtualHost> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<VirtualHost> findAll(int start, int end, OrderByComparator<VirtualHost> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<VirtualHost> findAll(int start, int end, OrderByComparator<VirtualHost> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_VIRTUALHOST);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VIRTUALHOST;
                if (pagination) {
                    sql = sql.concat(" ORDER BY virtualHost.virtualHostId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (VirtualHost virtualHost : this.findAll()) {
            this.remove((BaseModel)virtualHost);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_VIRTUALHOST);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return VirtualHostModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(VirtualHostImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

