/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.RetryAcceptor;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.ServiceBeanMethodInvocation;
import com.liferay.portal.util.PropsValues;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.aopalliance.intercept.MethodInvocation;

public class RetryAdvice
extends AnnotationChainableMethodAdvice<Retry> {
    private static final Log _log = LogFactoryUtil.getLog(RetryAdvice.class);
    private static final Retry _nullRetry = new Retry(){

        public Class<? extends RetryAcceptor> acceptor() {
            return null;
        }

        public Class<? extends Annotation> annotationType() {
            return Retry.class;
        }

        public Property[] properties() {
            return null;
        }

        public int retries() {
            return 0;
        }
    };

    @Override
    public Retry getNullAnnotation() {
        return _nullRetry;
    }

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Retry retry = (Retry)this.findAnnotation(methodInvocation);
        if (retry == _nullRetry) {
            return methodInvocation.proceed();
        }
        int retries = retry.retries();
        if (retries < 0) {
            retries = PropsValues.RETRY_ADVICE_MAX_RETRIES;
        }
        int totalRetries = retries;
        if (retries >= 0) {
            ++retries;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property property : retry.properties()) {
            properties.put(property.name(), property.value());
        }
        Class clazz = retry.acceptor();
        RetryAcceptor retryAcceptor = (RetryAcceptor)clazz.newInstance();
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)methodInvocation;
        serviceBeanMethodInvocation.mark();
        Object returnValue = null;
        Throwable throwable = null;
        while (retries < 0 || retries-- > 0) {
            block15: {
                try {
                    returnValue = serviceBeanMethodInvocation.proceed();
                    if (!retryAcceptor.acceptResult(returnValue, properties)) {
                        return returnValue;
                    }
                    if (_log.isWarnEnabled() && retries != 0) {
                        String number = String.valueOf(retries);
                        if (retries < 0) {
                            number = "unlimited";
                        }
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Retry on ", String.valueOf(methodInvocation), " for ", number, " more times due to result ", String.valueOf(returnValue)}));
                    }
                }
                catch (Throwable t) {
                    throwable = t;
                    if (!retryAcceptor.acceptException(t, properties)) {
                        throw t;
                    }
                    if (!_log.isWarnEnabled() || retries == 0) break block15;
                    String number = String.valueOf(retries);
                    if (retries < 0) {
                        number = "unlimited";
                    }
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Retry on ", String.valueOf(methodInvocation), " for ", number, " more times due to exception ", String.valueOf(throwable)}), throwable);
                }
            }
            serviceBeanMethodInvocation.reset();
        }
        if (throwable != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Give up retrying on ", String.valueOf(methodInvocation), " after ", String.valueOf(totalRetries), " retries and rethrow last retry's exception ", String.valueOf(throwable)}), throwable);
            }
            throw throwable;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Give up retrying on ", String.valueOf(methodInvocation), " after ", String.valueOf(totalRetries), " retries and returning the last retry's result ", String.valueOf(returnValue)}));
        }
        return returnValue;
    }
}

