/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.MethodInterceptorsBag;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ServiceBeanAopCacheManager {
    private static final Map<Method, Annotation[]> _annotations = new ConcurrentHashMap<Method, Annotation[]>();
    private static final Annotation[] _nullAnnotations = new Annotation[0];
    private final Map<Class<? extends Annotation>, AnnotationChainableMethodAdvice<?>[]> _annotationChainableMethodAdvices = new HashMap<Class<? extends Annotation>, AnnotationChainableMethodAdvice<?>[]>();
    private final MethodInterceptor[] _classLevelMethodInterceptors;
    private final MethodInterceptor[] _fullMethodInterceptors;
    private final Map<Method, MethodInterceptor[]> _methodInterceptors = new ConcurrentHashMap<Method, MethodInterceptor[]>();

    public static <T> T getAnnotation(MethodInvocation methodInvocation, Class<? extends Annotation> annotationType, T defaultValue) {
        Annotation[] annotations = _annotations.get(methodInvocation.getMethod());
        if (annotations == _nullAnnotations) {
            return defaultValue;
        }
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annotationType) continue;
            return (T)annotation;
        }
        return defaultValue;
    }

    public static void putAnnotations(MethodInvocation methodInvocation, Annotation[] annotations) {
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            annotations = _nullAnnotations;
        }
        _annotations.put(methodInvocation.getMethod(), annotations);
    }

    @Deprecated
    public ServiceBeanAopCacheManager() {
        this._classLevelMethodInterceptors = new MethodInterceptor[0];
        this._fullMethodInterceptors = new MethodInterceptor[0];
    }

    public ServiceBeanAopCacheManager(MethodInterceptor methodInterceptor) {
        ArrayList<MethodInterceptor> classLevelMethodInterceptors = new ArrayList<MethodInterceptor>();
        ArrayList<MethodInterceptor> fullMethodInterceptors = new ArrayList<MethodInterceptor>();
        while (true) {
            if (!(methodInterceptor instanceof ChainableMethodAdvice)) break;
            ChainableMethodAdvice chainableMethodAdvice = (ChainableMethodAdvice)methodInterceptor;
            chainableMethodAdvice.setServiceBeanAopCacheManager(this);
            if (methodInterceptor instanceof AnnotationChainableMethodAdvice) {
                AnnotationChainableMethodAdvice annotationChainableMethodAdvice = (AnnotationChainableMethodAdvice)methodInterceptor;
                Class<Annotation> annotationClass = annotationChainableMethodAdvice.getAnnotationClass();
                Target target = annotationClass.getAnnotation(Target.class);
                if (target == null) {
                    classLevelMethodInterceptors.add(methodInterceptor);
                } else {
                    for (ElementType elementType : target.value()) {
                        if (elementType != ElementType.TYPE) continue;
                        classLevelMethodInterceptors.add(methodInterceptor);
                        break;
                    }
                }
            } else {
                classLevelMethodInterceptors.add(methodInterceptor);
            }
            fullMethodInterceptors.add(methodInterceptor);
            methodInterceptor = chainableMethodAdvice.nextMethodInterceptor;
        }
        classLevelMethodInterceptors.add(methodInterceptor);
        fullMethodInterceptors.add(methodInterceptor);
        this._classLevelMethodInterceptors = classLevelMethodInterceptors.toArray(new MethodInterceptor[classLevelMethodInterceptors.size()]);
        this._fullMethodInterceptors = fullMethodInterceptors.toArray(new MethodInterceptor[fullMethodInterceptors.size()]);
    }

    public MethodInterceptor[] getMethodInterceptors(MethodInvocation methodInvocation) {
        MethodInterceptor[] methodInterceptors = this._methodInterceptors.get(methodInvocation.getMethod());
        if (methodInterceptors == null) {
            methodInterceptors = this._fullMethodInterceptors;
            this._methodInterceptors.put(methodInvocation.getMethod(), methodInterceptors);
        }
        return methodInterceptors;
    }

    @Deprecated
    public MethodInterceptorsBag getMethodInterceptorsBag(MethodInvocation methodInvocation) {
        MethodInterceptor[] methodInterceptors = this.getMethodInterceptors(methodInvocation);
        return new MethodInterceptorsBag(Arrays.asList(this._classLevelMethodInterceptors), Arrays.asList(methodInterceptors));
    }

    public Map<Class<? extends Annotation>, AnnotationChainableMethodAdvice<?>[]> getRegisteredAnnotationChainableMethodAdvices() {
        return this._annotationChainableMethodAdvices;
    }

    public boolean isRegisteredAnnotationClass(Class<? extends Annotation> annotationClass) {
        return this._annotationChainableMethodAdvices.containsKey(annotationClass);
    }

    public void putMethodInterceptors(MethodInvocation methodInvocation, MethodInterceptor[] methodInterceptors) {
        this._methodInterceptors.put(methodInvocation.getMethod(), methodInterceptors);
    }

    @Deprecated
    public void putMethodInterceptorsBag(MethodInvocation methodInvocation, MethodInterceptorsBag methodInterceptorsBag) {
        List<MethodInterceptor> methodInterceptors = methodInterceptorsBag.getMergedMethodInterceptors();
        this.putMethodInterceptors(methodInvocation, methodInterceptors.toArray(new MethodInterceptor[methodInterceptors.size()]));
    }

    public void registerAnnotationChainableMethodAdvice(Class<? extends Annotation> annotationClass, AnnotationChainableMethodAdvice<?> annotationChainableMethodAdvice) {
        Object[] annotationChainableMethodAdvices = this._annotationChainableMethodAdvices.get(annotationClass);
        annotationChainableMethodAdvices = annotationChainableMethodAdvices == null ? new AnnotationChainableMethodAdvice[]{annotationChainableMethodAdvice} : (AnnotationChainableMethodAdvice[])ArrayUtil.append((Object[])annotationChainableMethodAdvices, annotationChainableMethodAdvice);
        this._annotationChainableMethodAdvices.put(annotationClass, (AnnotationChainableMethodAdvice<?>[])annotationChainableMethodAdvices);
    }

    public void removeMethodInterceptor(MethodInvocation methodInvocation, MethodInterceptor methodInterceptor) {
        Method method = methodInvocation.getMethod();
        MethodInterceptor[] methodInterceptors = this._methodInterceptors.get(method);
        if (methodInterceptors == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < methodInterceptors.length; ++i) {
            if (!methodInterceptors[i].equals(methodInterceptor)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        int newLength = methodInterceptors.length - 1;
        Object[] newMethodInterceptors = new MethodInterceptor[newLength];
        if (index > 0) {
            System.arraycopy(methodInterceptors, 0, newMethodInterceptors, 0, index);
        }
        if (index < newLength) {
            System.arraycopy(methodInterceptors, index + 1, newMethodInterceptors, index, newLength - index);
        }
        if (Arrays.equals(newMethodInterceptors, this._classLevelMethodInterceptors)) {
            newMethodInterceptors = this._classLevelMethodInterceptors;
        }
        this._methodInterceptors.put(method, (MethodInterceptor[])newMethodInterceptors);
    }

    public void reset() {
        _annotations.clear();
        this._methodInterceptors.clear();
    }
}

