/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.bean.LiferayBeanFactory;
import com.liferay.portal.util.PropsValues;
import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortalApplicationContext
extends XmlWebApplicationContext {
    public static final String PARENT_APPLICATION_CONTEXT = PortalApplicationContext.class.getName() + "#PARENT_APPLICATION_CONTEXT";
    private static final Log _log = LogFactoryUtil.getLog(PortalApplicationContext.class);
    private ApplicationContext _parentApplicationContext;

    public ApplicationContext getParent() {
        return this._parentApplicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
        this._parentApplicationContext = (ApplicationContext)servletContext.getAttribute(PARENT_APPLICATION_CONTEXT);
        this.setParent(this._parentApplicationContext);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new LiferayBeanFactory(this.getInternalParentBeanFactory());
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        block7: {
            try {
                super.loadBeanDefinitions(xmlBeanDefinitionReader);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        xmlBeanDefinitionReader.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver());
        if (PropsValues.SPRING_CONFIGS == null) {
            return;
        }
        for (String configLocation : PropsValues.SPRING_CONFIGS) {
            try {
                xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)cause.getMessage());
                    continue;
                }
                _log.error((Object)e, (Throwable)e);
            }
        }
    }
}

