/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;

public class CallbackPreferringTransactionExecutor
implements TransactionExecutor {
    private final PlatformTransactionManager _platformTransactionManager;

    @Deprecated
    public CallbackPreferringTransactionExecutor() {
        this._platformTransactionManager = null;
    }

    public CallbackPreferringTransactionExecutor(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    @Override
    @Deprecated
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        return this._execute(platformTransactionManager, transactionAttributeAdapter, methodInvocation);
    }

    @Override
    public Object execute(TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        return this._execute(this._platformTransactionManager, transactionAttributeAdapter, methodInvocation);
    }

    @Override
    public PlatformTransactionManager getPlatformTransactionManager() {
        return this._platformTransactionManager;
    }

    protected TransactionCallback<Object> createTransactionCallback(CallbackPreferringPlatformTransactionManager callbackPreferringPlatformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) {
        return new CallbackPreferringTransactionCallback((PlatformTransactionManager)callbackPreferringPlatformTransactionManager, transactionAttributeAdapter, methodInvocation);
    }

    @Deprecated
    protected TransactionCallback<Object> createTransactionCallback(TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) {
        return new CallbackPreferringTransactionCallback(null, transactionAttributeAdapter, methodInvocation);
    }

    private Object _execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        CallbackPreferringPlatformTransactionManager callbackPreferringPlatformTransactionManager = (CallbackPreferringPlatformTransactionManager)platformTransactionManager;
        try {
            Object result = callbackPreferringPlatformTransactionManager.execute((TransactionDefinition)transactionAttributeAdapter, this.createTransactionCallback(callbackPreferringPlatformTransactionManager, transactionAttributeAdapter, methodInvocation));
            if (result instanceof ThrowableHolder) {
                ThrowableHolder throwableHolder = (ThrowableHolder)result;
                throw throwableHolder.getThrowable();
            }
            return result;
        }
        catch (ThrowableHolderException the) {
            throw the.getCause();
        }
    }

    private class CallbackPreferringTransactionCallback
    implements TransactionCallback<Object> {
        private final MethodInvocation _methodInvocation;
        private final PlatformTransactionManager _platformTransactionManager;
        private final TransactionAttributeAdapter _transactionAttributeAdapter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInTransaction(TransactionStatus transactionStatus) {
            TransactionStatusAdapter transactionStatusAdapter = new TransactionStatusAdapter(transactionStatus);
            TransactionExecutorThreadLocal.pushTransactionExecutor(CallbackPreferringTransactionExecutor.this);
            TransactionLifecycleManager.fireTransactionCreatedEvent((TransactionAttribute)this._transactionAttributeAdapter, (com.liferay.portal.kernel.transaction.TransactionStatus)transactionStatusAdapter);
            boolean rollback = false;
            try {
                Object object = this._methodInvocation.proceed();
                return object;
            }
            catch (Throwable throwable) {
                if (this._transactionAttributeAdapter.rollbackOn(throwable)) {
                    TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)this._transactionAttributeAdapter, (com.liferay.portal.kernel.transaction.TransactionStatus)transactionStatusAdapter, (Throwable)throwable);
                    if (transactionStatus.isNewTransaction()) {
                        rollback = true;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new ThrowableHolderException(throwable);
                }
                ThrowableHolder throwableHolder = new ThrowableHolder(throwable);
                return throwableHolder;
            }
            finally {
                if (!rollback) {
                    TransactionLifecycleManager.fireTransactionCommittedEvent((TransactionAttribute)this._transactionAttributeAdapter, (com.liferay.portal.kernel.transaction.TransactionStatus)transactionStatusAdapter);
                }
                TransactionExecutorThreadLocal.popTransactionExecutor();
            }
        }

        private CallbackPreferringTransactionCallback(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) {
            this._platformTransactionManager = platformTransactionManager;
            this._transactionAttributeAdapter = transactionAttributeAdapter;
            this._methodInvocation = methodInvocation;
        }
    }

    protected static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable cause) {
            super(cause);
        }
    }

    protected static class ThrowableHolder {
        private final Throwable _throwable;

        public ThrowableHolder(Throwable throwable) {
            this._throwable = throwable;
        }

        public Throwable getThrowable() {
            return this._throwable;
        }
    }
}

