/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.struts.Definition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public class PortalTilesPlugin
implements PlugIn {
    public static final String DEFINITION = "org.apache.struts.tiles.definition";
    public static final String DEFINITIONS = "org.apache.struts.tiles.definitions";

    public void destroy() {
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        ServletContext servletContext = servlet.getServletContext();
        HashMap<String, Definition> definitions = new HashMap<String, Definition>();
        ArrayList<Element> deferedElements = new ArrayList<Element>();
        try (InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/tiles-defs.xml");){
            Document document = SAXReaderUtil.read((InputStream)inputStream, (boolean)false);
            Element rootElement = document.getRootElement();
            for (Element definitionElement : rootElement.elements("definition")) {
                String parentName = definitionElement.attributeValue("extends");
                if (parentName == null) {
                    this._addDefinition(definitions, definitionElement, null);
                    continue;
                }
                Definition parentDefinition = (Definition)definitions.get(parentName);
                if (parentDefinition == null) {
                    deferedElements.add(rootElement);
                    continue;
                }
                this._addDefinition(definitions, definitionElement, parentDefinition);
            }
            for (Element definitionElement : deferedElements) {
                Definition parentDefinition = (Definition)definitions.get(definitionElement.attributeValue("extends"));
                this._addDefinition(definitions, definitionElement, parentDefinition);
            }
            servletContext.setAttribute(DEFINITIONS, definitions);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void _addDefinition(Map<String, Definition> definitions, Element definitionElement, Definition parentDefinition) {
        String name = definitionElement.attributeValue("name");
        HashMap<String, String> attributes = new HashMap<String, String>();
        String path = definitionElement.attributeValue("path");
        if (parentDefinition != null) {
            attributes.putAll(parentDefinition.getAttributes());
            if (path == null) {
                path = parentDefinition.getPath();
            }
        }
        for (Element putElement : definitionElement.elements("put")) {
            attributes.put(putElement.attributeValue("name"), putElement.attributeValue("value"));
        }
        definitions.put(name, new Definition(path, attributes));
    }
}

