/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_3;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeOracle
extends UpgradeProcess {
    private static final int[] _ORIGINAL_DATA_LENGTH_VALUES = new int[]{75, 100, 150, 200, 255, 500, 1000, 1024, 2000, 4000};
    private static final Log _log = LogFactoryUtil.getLog(UpgradeOracle.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void alterVarchar2Columns() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select table_name, column_name, data_length from user_tab_columns where data_type = 'VARCHAR2' and char_used = 'B'");
             ResultSet rs = ps.executeQuery();){
            int buildNumber = this.getBuildNumber();
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (!this.isPortal62TableName(tableName)) continue;
                String columnName = rs.getString(2);
                int dataLength = rs.getInt(3);
                if (buildNumber < 6200 && !ArrayUtil.contains((int[])_ORIGINAL_DATA_LENGTH_VALUES, (int)dataLength)) {
                    dataLength /= 4;
                }
                try {
                    this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " modify ", columnName, " varchar2(", String.valueOf(dataLength), " char)"}));
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() != 1441) throw sqle;
                    if (!_log.isWarnEnabled()) continue;
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unable to alter length of column ");
                    sb.append(columnName);
                    sb.append(" for table ");
                    sb.append(tableName);
                    sb.append(" because it contains values that are ");
                    sb.append("larger than the new column length");
                    _log.warn((Object)sb.toString());
                    continue;
                    return;
                }
            }
        }
    }

    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.ORACLE) {
            return;
        }
        this.alterVarchar2Columns();
    }

    /*
     * Exception decompiling
     */
    protected int getBuildNumber() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

