/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.model.impl.LayoutTypeControllerImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LayoutTypeControllerTracker {
    private static final String[] _LAYOUT_TYPES = new String[]{"embedded", "panel", "portlet", "url"};
    private static final Map<String, LayoutTypeController> _defaultLayoutTypeControllers = new ConcurrentHashMap<String, LayoutTypeController>();
    private static final ConcurrentMap<String, LayoutTypeController> _layoutTypeControllers = new ConcurrentHashMap<String, LayoutTypeController>();
    private static final ServiceTracker<LayoutTypeController, LayoutTypeController> _serviceTracker;

    public static LayoutTypeController getLayoutTypeController(Layout layout) {
        return LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
    }

    public static LayoutTypeController getLayoutTypeController(String type) {
        LayoutTypeController layoutTypeController = (LayoutTypeController)_layoutTypeControllers.get(type);
        if (layoutTypeController != null) {
            return layoutTypeController;
        }
        return (LayoutTypeController)_layoutTypeControllers.get("portlet");
    }

    public static Map<String, LayoutTypeController> getLayoutTypeControllers() {
        return Collections.unmodifiableMap(_layoutTypeControllers);
    }

    public static String[] getTypes() {
        Set types = _layoutTypeControllers.keySet();
        return types.toArray(new String[types.size()]);
    }

    private static void _registerDefaults(Registry registry) {
        Set<Map.Entry<String, LayoutTypeController>> entries = _defaultLayoutTypeControllers.entrySet();
        for (Map.Entry<String, LayoutTypeController> entry : entries) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("layout.type", entry.getKey());
            registry.registerService(LayoutTypeController.class, (Object)entry.getValue(), properties);
        }
    }

    static {
        for (String type : _LAYOUT_TYPES) {
            _defaultLayoutTypeControllers.put(type, new LayoutTypeControllerImpl(type));
        }
        Registry registry = RegistryUtil.getRegistry();
        LayoutTypeControllerTracker._registerDefaults(registry);
        Filter filter = registry.getFilter("(&(layout.type=*)(objectClass=" + LayoutTypeController.class.getName() + "))");
        _serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new LayoutTypeControllerServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class LayoutTypeControllerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LayoutTypeController, LayoutTypeController> {
        private LayoutTypeControllerServiceTrackerCustomizer() {
        }

        public LayoutTypeController addingService(ServiceReference<LayoutTypeController> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            LayoutTypeController layoutTypeController = (LayoutTypeController)registry.getService(serviceReference);
            String type = (String)serviceReference.getProperty("layout.type");
            _layoutTypeControllers.put(type, layoutTypeController);
            return layoutTypeController;
        }

        public void modifiedService(ServiceReference<LayoutTypeController> serviceReference, LayoutTypeController layoutTypeController) {
        }

        public void removedService(ServiceReference<LayoutTypeController> serviceReference, LayoutTypeController layoutTypeController) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String type = (String)serviceReference.getProperty("layout.type");
            LayoutTypeController defaultLayoutTypeController = (LayoutTypeController)_defaultLayoutTypeControllers.get(type);
            if (defaultLayoutTypeController == null) {
                _layoutTypeControllers.remove(type);
            } else {
                _layoutTypeControllers.replace(type, layoutTypeController, defaultLayoutTypeController);
            }
        }
    }
}

