/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.CollectorOutputProcessor;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.petra.process.local.LocalProcessExecutor;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.license.sigar.SigarNativeLoader;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsImpl;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.Sigar;

public class LicenseUtil {
    public static final String LICENSE_REPOSITORY_DIR = PropsValues.LIFERAY_HOME.concat("/data/license");
    public static final String LICENSE_SERVER_URL = GetterUtil.get((String)PropsUtil.get((String)"license.server.url"), (String)"https://www.liferay.com");
    private static final int _PROCESSOR_CORES;
    private static final String _PROXY_PASSWORD;
    private static final int _PROXY_PORT;
    private static final String _PROXY_URL;
    private static final String _PROXY_USER_NAME;
    private static final Log _log;
    private static final MethodHandler _getServerInfoMethodHandler;
    private static final Set<String> _ipAddresses;
    private static final Set<String> _macAddresses;
    private static final MethodKey _registerOrderMethodKey;
    private static byte[] _serverIdBytes;

    public static Map<String, String> getClusterServerInfo(String clusterNodeId) throws Exception {
        ClusterNode localClusterNode = ClusterExecutorUtil.getLocalClusterNode();
        String localClusterNodeId = localClusterNode.getClusterNodeId();
        if (clusterNodeId.equals(localClusterNodeId)) {
            return LicenseUtil.getServerInfo();
        }
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        ClusterNode clusterNode = null;
        for (ClusterNode curClusterNode : clusterNodes) {
            String curClusterNodeId = curClusterNode.getClusterNodeId();
            if (!curClusterNodeId.equals(clusterNodeId)) continue;
            clusterNode = curClusterNode;
            break;
        }
        if (clusterNode == null) {
            return null;
        }
        try {
            ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)_getServerInfoMethodHandler, (String[])new String[]{clusterNodeId});
            FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
            return (Map)((Object)clusterNodeResponse.getResult());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getIpAddresses() {
        return _ipAddresses;
    }

    public static Set<String> getMacAddresses() {
        return _macAddresses;
    }

    public static int getProcessorCores() {
        return _PROCESSOR_CORES;
    }

    public static byte[] getServerIdBytes() throws Exception {
        if (_serverIdBytes != null) {
            return _serverIdBytes;
        }
        java.io.File serverIdFile = new java.io.File(LICENSE_REPOSITORY_DIR + "/server/serverId");
        if (!serverIdFile.exists()) {
            return new byte[0];
        }
        _serverIdBytes = FileUtil.getBytes((java.io.File)serverIdFile);
        return _serverIdBytes;
    }

    public static Map<String, String> getServerInfo() {
        HashMap<String, String> serverInfo = new HashMap<String, String>();
        serverInfo.put("hostName", PortalUtil.getComputerName());
        serverInfo.put("ipAddresses", StringUtil.merge(LicenseUtil.getIpAddresses()));
        serverInfo.put("macAddresses", StringUtil.merge(LicenseUtil.getMacAddresses()));
        serverInfo.put("processorCores", String.valueOf(LicenseUtil.getProcessorCores()));
        return serverInfo;
    }

    @Deprecated
    public static void init() {
    }

    public static void registerOrder(HttpServletRequest request) {
        String orderUuid = ParamUtil.getString((HttpServletRequest)request, (String)"orderUuid");
        String productEntryName = ParamUtil.getString((HttpServletRequest)request, (String)"productEntryName");
        int maxServers = ParamUtil.getInteger((HttpServletRequest)request, (String)"maxServers");
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        if (clusterNodes.size() <= 1 || Validator.isNull((String)productEntryName) || Validator.isNull((String)orderUuid)) {
            Map<String, Object> attributes = LicenseUtil.registerOrder(orderUuid, productEntryName, maxServers);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        } else {
            for (ClusterNode clusterNode : clusterNodes) {
                boolean register = ParamUtil.getBoolean((HttpServletRequest)request, (String)(clusterNode.getClusterNodeId() + "_register"));
                if (!register) continue;
                try {
                    LicenseUtil._registerClusterOrder(request, clusterNode, orderUuid, productEntryName, maxServers);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                    InetAddress inetAddress = clusterNode.getBindInetAddress();
                    String message = "Error contacting " + inetAddress.getHostName();
                    if (clusterNode.getPortalPort() != -1) {
                        message = message + ":" + clusterNode.getPortalPort();
                    }
                    request.setAttribute(clusterNode.getClusterNodeId() + "_ERROR_MESSAGE", (Object)message);
                }
            }
        }
    }

    public static Map<String, Object> registerOrder(String orderUuid, String productEntryName, int maxServers) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (Validator.isNull((String)orderUuid)) {
            return attributes;
        }
        try {
            JSONObject jsonObject = LicenseUtil._createRequest(orderUuid, productEntryName, maxServers);
            String response = LicenseUtil.sendRequest(jsonObject.toString());
            JSONObjectImpl responseJSONObject = new JSONObjectImpl(response);
            attributes.put("ORDER_PRODUCT_ID", responseJSONObject.getString("productId"));
            attributes.put("ORDER_PRODUCTS", LicenseUtil._getOrderProducts(responseJSONObject));
            String errorMessage = responseJSONObject.getString("errorMessage");
            if (Validator.isNotNull((String)errorMessage)) {
                attributes.put("ERROR_MESSAGE", errorMessage);
                return attributes;
            }
            String licenseXML = responseJSONObject.getString("licenseXML");
            if (Validator.isNotNull((String)licenseXML)) {
                LicenseManagerUtil.registerLicense((JSONObject)responseJSONObject);
                attributes.clear();
                attributes.put("SUCCESS_MESSAGE", "Your license has been successfully registered.");
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            attributes.put("ERROR_MESSAGE", "There was an error contacting " + LICENSE_SERVER_URL);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String request) throws Exception {
        CloseableHttpClient httpClient = null;
        BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager();
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
            String serverURL = LICENSE_SERVER_URL;
            if (!serverURL.endsWith("/")) {
                serverURL = serverURL + "/";
            }
            serverURL = serverURL + "osb-portlet/license";
            URI uri = new URI(serverURL);
            HttpPost httpPost = new HttpPost(uri);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            HttpHost proxyHttpHost = null;
            if (Validator.isNotNull((String)_PROXY_URL)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Using proxy ", _PROXY_URL, ":", String.valueOf(_PROXY_PORT)}));
                }
                proxyHttpHost = new HttpHost(_PROXY_URL, _PROXY_PORT);
                if (Validator.isNotNull((String)_PROXY_USER_NAME)) {
                    credentialsProvider.setCredentials(new AuthScope(_PROXY_URL, _PROXY_PORT), (Credentials)new UsernamePasswordCredentials(_PROXY_USER_NAME, _PROXY_PASSWORD));
                }
            }
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            httpClientBuilder.setProxy(proxyHttpHost);
            httpClient = httpClientBuilder.build();
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(request.getBytes("UTF-8"));
            byteArrayEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)byteArrayEntity);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = StringUtil.read((InputStream)httpEntity.getContent());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Server response: " + response));
            }
            if (Validator.isNull((String)response)) {
                throw new Exception("Server response is null");
            }
            String string = response;
            return string;
        }
        finally {
            if (httpClient != null) {
                httpClientConnectionManager.shutdown();
            }
        }
    }

    public static void writeServerProperties(byte[] serverIdBytes) throws Exception {
        java.io.File serverIdFile = new java.io.File(LICENSE_REPOSITORY_DIR + "/server/serverId");
        FileUtil.write((java.io.File)serverIdFile, (byte[])serverIdBytes);
    }

    private static JSONObject _createRequest(String orderUuid, String productEntryName, int maxServers) throws Exception {
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        jsonObject.put("liferayVersion", ReleaseInfo.getBuildNumber());
        jsonObject.put("orderUuid", orderUuid);
        jsonObject.put("version", 2);
        if (Validator.isNull((String)productEntryName)) {
            jsonObject.put("cmd", "QUERY");
        } else {
            jsonObject.put("cmd", "REGISTER");
            if (productEntryName.startsWith("basic")) {
                String[] productNameArray;
                jsonObject.put("productEntryName", "basic");
                if (productEntryName.equals("basic-cluster")) {
                    jsonObject.put("cluster", true);
                    jsonObject.put("maxServers", maxServers);
                } else if (productEntryName.startsWith("basic-") && (productNameArray = StringUtil.split((String)productEntryName, (String)"-")).length >= 3) {
                    jsonObject.put("clusterId", productNameArray[2]);
                    jsonObject.put("offeringEntryId", productNameArray[1]);
                }
            } else {
                jsonObject.put("productEntryName", productEntryName);
            }
            jsonObject.put("hostName", PortalUtil.getComputerName());
            jsonObject.put("ipAddresses", StringUtil.merge(LicenseUtil.getIpAddresses()));
            jsonObject.put("macAddresses", StringUtil.merge(LicenseUtil.getMacAddresses()));
            jsonObject.put("processorCores", LicenseUtil.getProcessorCores());
            jsonObject.put("serverId", Arrays.toString(LicenseUtil.getServerIdBytes()));
        }
        return jsonObject;
    }

    private static Map<String, String> _getOrderProducts(JSONObject jsonObject) {
        JSONObject productsJSONObject = jsonObject.getJSONObject("productsJSONObject");
        if (productsJSONObject == null) {
            return null;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator itr = productsJSONObject.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            sortedMap.put(key, productsJSONObject.getString(key));
        }
        return sortedMap;
    }

    private static int _getProcessorCores() {
        if (OSDetector.isLinux()) {
            try {
                NoticeableFuture future = ProcessUtil.execute((OutputProcessor)CollectorOutputProcessor.INSTANCE, (String[])new String[]{"nproc"});
                Map.Entry entry = (Map.Entry)future.get();
                return GetterUtil.getInteger((String)new String((byte[])entry.getKey(), "UTF-8"));
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (OSDetector.isAIX() || JavaDetector.isIBM()) {
            Runtime runtime = Runtime.getRuntime();
            return runtime.availableProcessors();
        }
        LocalProcessExecutor processExecutor = new LocalProcessExecutor();
        try {
            ProcessChannel processChannel = processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), (ProcessCallable)new SigarGetCPUCoresProcessCallable());
            NoticeableFuture future = processChannel.getProcessNoticeableFuture();
            return (Integer)future.get();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    private static void _registerClusterOrder(HttpServletRequest request, ClusterNode clusterNode, String orderUuid, String productEntryName, int maxServers) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_registerOrderMethodKey, new Object[]{orderUuid, productEntryName, maxServers});
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)methodHandler, (String[])new String[]{clusterNode.getClusterNodeId()});
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
        ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
        Map attributes = (Map)((Object)clusterNodeResponse.getResult());
        for (Map.Entry entry : attributes.entrySet()) {
            request.setAttribute(clusterNode.getClusterNodeId() + "_" + (String)entry.getKey(), entry.getValue());
        }
    }

    static {
        _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get((String)"license.proxy.password"));
        _PROXY_PORT = GetterUtil.getInteger((String)PropsUtil.get((String)"license.proxy.port"), (int)80);
        _PROXY_URL = PropsUtil.get((String)"license.proxy.url");
        _PROXY_USER_NAME = GetterUtil.getString((String)PropsUtil.get((String)"license.proxy.username"));
        _log = LogFactoryUtil.getLog(LicenseUtil.class);
        _getServerInfoMethodHandler = new MethodHandler(new MethodKey(LicenseUtil.class, "getServerInfo", new Class[0]), new Object[0]);
        _registerOrderMethodKey = new MethodKey(LicenseUtil.class, "registerOrder", new Class[]{String.class, String.class, Integer.TYPE});
        HashSet<String> ipAddresses = new HashSet<String>();
        HashSet<String> macAddresses = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumeration.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumeration.nextElement();
                Enumeration<InetAddress> inetAddressEnumeration = networkInterface.getInetAddresses();
                while (inetAddressEnumeration.hasMoreElements()) {
                    InetAddress inetAddress = inetAddressEnumeration.nextElement();
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    ipAddresses.add(inetAddress.getHostAddress());
                }
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (ArrayUtil.isEmpty((byte[])hardwareAddress)) continue;
                StringBuilder sb = new StringBuilder(hardwareAddress.length * 3 - 1);
                String hexString = StringUtil.bytesToHexString((byte[])hardwareAddress);
                for (int i = 0; i < hexString.length(); i += 2) {
                    if (i != 0) {
                        sb.append(':');
                    }
                    sb.append(Character.toLowerCase(hexString.charAt(i)));
                    sb.append(Character.toLowerCase(hexString.charAt(i + 1)));
                }
                macAddresses.add(sb.toString());
            }
        }
        catch (SocketException se) {
            _log.error((Object)"Unable to read local server network interfaces", (Throwable)se);
        }
        _ipAddresses = Collections.unmodifiableSet(ipAddresses);
        _macAddresses = Collections.unmodifiableSet(macAddresses);
        _PROCESSOR_CORES = LicenseUtil._getProcessorCores();
    }

    private static class SigarGetCPUCoresProcessCallable
    implements ProcessCallable<Integer> {
        private static final long serialVersionUID = 1L;

        private SigarGetCPUCoresProcessCallable() {
        }

        public Integer call() throws ProcessException {
            LogFactoryUtil.setLogFactory((LogFactory)new Log4jLogFactoryImpl());
            PropsUtil.setProps((Props)new PropsImpl());
            FileUtil fileUtil = new FileUtil();
            fileUtil.setFile((File)new FileImpl());
            Sigar sigar = null;
            try {
                SigarNativeLoader.load();
                sigar = new Sigar();
                CpuInfo[] cpuInfos = sigar.getCpuInfoList();
                CpuInfo cpuInfo = cpuInfos[0];
                Integer n = cpuInfo.getTotalCores();
                return n;
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            finally {
                if (sigar != null) {
                    sigar.close();
                }
                try {
                    SigarNativeLoader.unload();
                }
                catch (Exception e) {
                    throw new ProcessException((Throwable)e);
                }
            }
        }
    }
}

