/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.verify.model.VerifiableUUIDModel;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class VerifyUUID
extends VerifyProcess {
    public static void verify(VerifiableUUIDModel ... verifiableUUIDModels) throws Exception {
        VerifyUUID verifyUUID = new VerifyUUID();
        verifyUUID.doVerify(verifiableUUIDModels);
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableUUIDModelsMap = PortalBeanLocatorUtil.locate(VerifiableUUIDModel.class);
        Collection verifiableUUIDModels = verifiableUUIDModelsMap.values();
        this.doVerify(verifiableUUIDModels.toArray(new VerifiableUUIDModel[verifiableUUIDModels.size()]));
    }

    protected void doVerify(VerifiableUUIDModel ... verifiableUUIDModels) throws Exception {
        ArrayList<VerifyUUIDCallable> verifyUUIDCallables = new ArrayList<VerifyUUIDCallable>(verifiableUUIDModels.length);
        for (VerifiableUUIDModel verifiableUUIDModel : verifiableUUIDModels) {
            VerifyUUIDCallable verifyUUIDCallable = new VerifyUUIDCallable(verifiableUUIDModel);
            verifyUUIDCallables.add(verifyUUIDCallable);
        }
        this.doVerify(verifyUUIDCallables);
    }

    protected void verifyUUID(VerifiableUUIDModel verifiableUUIDModel) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("update ");
        sb.append(verifiableUUIDModel.getTableName());
        sb.append(" set uuid_ = ? where ");
        sb.append(verifiableUUIDModel.getPrimaryKeyColumnName());
        sb.append(" = ?");
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableUUIDModel.getTableName());
             Connection con = DataAccess.getConnection();
             PreparedStatement ps1 = con.prepareStatement(StringBundler.concat((String[])new String[]{"select ", verifiableUUIDModel.getPrimaryKeyColumnName(), " from ", verifiableUUIDModel.getTableName(), " where uuid_ is null or uuid_ = ''"}));
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)con.prepareStatement(sb.toString()));){
            while (rs.next()) {
                long pk = rs.getLong(verifiableUUIDModel.getPrimaryKeyColumnName());
                ps2.setString(1, PortalUUIDUtil.generate());
                ps2.setLong(2, pk);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    private class VerifyUUIDCallable
    implements Callable<Void> {
        private final VerifiableUUIDModel _verifiableUUIDModel;

        @Override
        public Void call() throws Exception {
            VerifyUUID.this.verifyUUID(this._verifiableUUIDModel);
            return null;
        }

        private VerifyUUIDCallable(VerifiableUUIDModel verifiableUUIDModel) {
            this._verifiableUUIDModel = verifiableUUIDModel;
        }
    }
}

