/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.util.List;

public class CleanUpPortletPreferencesUtil {
    private static final Log _log = LogFactoryUtil.getLog(CleanUpPortletPreferencesUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpLayoutRevisionPortletPreferences() throws Exception {
        CacheRegistryUtil.setActive((boolean)true);
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = CleanUpPortletPreferencesUtil.getPortletPreferencesActionableDynamicQuery();
            actionableDynamicQuery.setParallel(true);
            actionableDynamicQuery.performActions();
        }
        finally {
            CacheRegistryUtil.setActive((boolean)false);
        }
    }

    protected static boolean containsPortlet(Layout layout, String portletId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        List portlets = layoutTypePortlet.getAllPortlets();
        List portletIds = ListUtil.toList((List)portlets, (Accessor)Portlet.PORTLET_ID_ACCESSOR);
        return portletIds.contains(portletId);
    }

    protected static ActionableDynamicQuery getPortletPreferencesActionableDynamicQuery() {
        ActionableDynamicQuery portletPreferencesActionableDynamicQuery = PortletPreferencesLocalServiceUtil.getActionableDynamicQuery();
        portletPreferencesActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
                DynamicQuery layoutRevisionDynamicQuery = LayoutRevisionLocalServiceUtil.dynamicQuery();
                layoutRevisionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"layoutRevisionId"));
                dynamicQuery.add(plidProperty.in(layoutRevisionDynamicQuery));
            }
        });
        portletPreferencesActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<PortletPreferences>(){

            public void performAction(PortletPreferences portletPreferences) throws PortalException {
                long layoutRevisionId = portletPreferences.getPlid();
                LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
                Layout layout = LayoutLocalServiceUtil.getLayout((long)layoutRevision.getPlid());
                if (!layout.isTypePortlet()) {
                    return;
                }
                if (CleanUpPortletPreferencesUtil.containsPortlet(layout, portletPreferences.getPortletId())) {
                    return;
                }
                LayoutStagingHandler layoutStagingHandler = new LayoutStagingHandler(layout);
                layoutStagingHandler.setLayoutRevision(layoutRevision);
                Layout proxiedLayout = (Layout)ProxyUtil.newProxyInstance((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (Class[])new Class[]{Layout.class, ModelWrapper.class}, (InvocationHandler)layoutStagingHandler);
                if (CleanUpPortletPreferencesUtil.containsPortlet(proxiedLayout, portletPreferences.getPortletId())) {
                    return;
                }
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Removing portlet preferences " + portletPreferences.getPortletPreferencesId()));
                }
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((PortletPreferences)portletPreferences);
            }
        });
        return portletPreferencesActionableDynamicQuery;
    }
}

