/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.StrutsActionPortletURL;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.internal.PortletResponseImpl;
import com.liferay.portlet.internal.PortletURLImpl;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class LiferayPortletURLPrivilegedAction {
    private static final Log _log = LogFactoryUtil.getLog(LiferayPortletURLPrivilegedAction.class);
    private final Map<String, Constructor<? extends PortletURLImpl>> _constructors;
    private final MimeResponse.Copy _copy;
    private final boolean _includeLinkToLayoutUuid;
    private final Layout _layout;
    private final String _lifecycle;
    private final long _plid;
    private final Portlet _portlet;
    private final String _portletName;
    private final PortletPreferences _portletPreferences;
    private final PortletRequest _portletRequest;
    private final PortletResponseImpl _portletResponseImpl;
    private final HttpServletRequest _request;
    private final long _requestPlid;

    public LiferayPortletURLPrivilegedAction(long plid, String portletName, String lifecycle, MimeResponse.Copy copy, boolean includeLinkToLayoutUuid, Layout layout, Portlet portlet, PortletPreferences portletPreferences, PortletRequest portletRequest, PortletResponseImpl portletResponseImpl, long requestPlid, Map<String, Constructor<? extends PortletURLImpl>> constructors) {
        this._plid = plid;
        this._portletName = portletName;
        this._lifecycle = lifecycle;
        this._copy = copy;
        this._includeLinkToLayoutUuid = includeLinkToLayoutUuid;
        this._layout = layout;
        this._portlet = portlet;
        this._portletPreferences = portletPreferences;
        this._portletRequest = portletRequest;
        this._portletResponseImpl = portletResponseImpl;
        this._request = null;
        this._requestPlid = requestPlid;
        this._constructors = constructors;
    }

    public LiferayPortletURLPrivilegedAction(String portletName, String lifecycle, MimeResponse.Copy copy, Layout layout, Portlet portlet, HttpServletRequest request) {
        this._portletName = portletName;
        this._lifecycle = lifecycle;
        this._copy = copy;
        this._layout = layout;
        this._portlet = portlet;
        this._request = request;
        this._constructors = null;
        this._includeLinkToLayoutUuid = false;
        this._plid = 0L;
        this._portletPreferences = null;
        this._portletRequest = null;
        this._portletResponseImpl = null;
        this._requestPlid = 0L;
    }

    public LiferayPortletURL run() {
        long plid;
        block22: {
            if (this._request != null) {
                return PortletURLFactoryUtil.create((HttpServletRequest)this._request, (Portlet)this._portlet, (Layout)this._layout, (String)this._lifecycle, (MimeResponse.Copy)this._copy);
            }
            boolean includeLinkToLayoutUuid = this._includeLinkToLayoutUuid;
            plid = this._plid;
            try {
                String linkToLayoutUuid = GetterUtil.getString((String)this._portletPreferences.getValue("portletSetupLinkToLayoutUuid", null));
                if (PropsValues.PORTLET_CROSS_LAYOUT_INVOCATION_MODE.equals("render") && !"RENDER_PHASE".equals(this._lifecycle)) {
                    includeLinkToLayoutUuid = false;
                }
                if (Validator.isNotNull((String)linkToLayoutUuid) && includeLinkToLayoutUuid) {
                    try {
                        Layout linkedLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)linkToLayoutUuid, (long)this._layout.getGroupId(), (boolean)this._layout.isPrivateLayout());
                        plid = linkedLayout.getPlid();
                    }
                    catch (PortalException pe) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)pe, (Throwable)pe);
                        }
                    }
                }
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block22;
                _log.warn((Object)se, (Throwable)se);
            }
        }
        if (plid == 0L) {
            plid = this._requestPlid;
        }
        StrutsActionPortletURL portletURL = null;
        String portletURLClass = this._portlet.getPortletURLClass();
        String portletId = this._portlet.getPortletId();
        if (portletId.equals(this._portletName) && Validator.isNotNull((String)portletURLClass)) {
            if (portletURLClass.equals(StrutsActionPortletURL.class.getName())) {
                portletURL = new StrutsActionPortletURL(this._portletResponseImpl, plid, this._lifecycle);
            } else {
                try {
                    Constructor<PortletURLImpl> constructor = this._constructors.get(portletURLClass);
                    if (constructor == null) {
                        Class<?> portletURLClassObj = Class.forName(portletURLClass);
                        constructor = portletURLClassObj.getConstructor(PortletResponseImpl.class, Long.TYPE, String.class);
                        this._constructors.put(portletURLClass, constructor);
                    }
                    portletURL = constructor.newInstance(this._portletResponseImpl, plid, this._lifecycle);
                }
                catch (Exception e) {
                    _log.error((Object)"Unable to create portlet URL", (Throwable)e);
                }
            }
        }
        if (portletURL == null) {
            portletURL = this._portletName.equals(portletId) ? PortletURLFactoryUtil.create((PortletRequest)this._portletRequest, (Portlet)this._portlet, (long)plid, (String)this._lifecycle, (MimeResponse.Copy)this._copy) : PortletURLFactoryUtil.create((PortletRequest)this._portletRequest, (String)this._portletName, (long)plid, (String)this._lifecycle, (MimeResponse.Copy)this._copy);
        }
        try {
            if (this._portlet.hasWindowState(this._portletRequest.getResponseContentType(), this._portletRequest.getWindowState())) {
                portletURL.setWindowState(this._portletRequest.getWindowState());
            }
        }
        catch (WindowStateException wse) {
            _log.error((Object)wse.getMessage());
        }
        try {
            if (this._portlet.hasPortletMode(this._portletRequest.getResponseContentType(), this._portletRequest.getPortletMode())) {
                portletURL.setPortletMode(this._portletRequest.getPortletMode());
            }
        }
        catch (PortletModeException pme) {
            _log.error((Object)pme.getMessage());
        }
        return portletURL;
    }
}

