/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdatePasswordAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Ticket ticket = this.getTicket(request);
        request.setAttribute("TICKET", (Object)ticket);
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            if (ticket != null) {
                User user = UserLocalServiceUtil.getUser((long)ticket.getClassPK());
                try {
                    UserLocalServiceUtil.checkLockout((User)user);
                    UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
                }
                catch (UserLockoutException ule) {
                    SessionErrors.add((HttpServletRequest)request, ((Object)((Object)ule)).getClass(), (Object)((Object)ule));
                }
            }
            return actionMapping.findForward("portal.update_password");
        }
        try {
            this.updatePassword(request, response, themeDisplay, ticket);
            String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"referer");
            if (Validator.isNotNull((String)redirect)) {
                redirect = PortalUtil.escapeRedirect((String)redirect);
            }
            if (Validator.isNull((String)redirect)) {
                redirect = themeDisplay.getPathMain();
            }
            response.sendRedirect(redirect);
            return null;
        }
        catch (Exception e) {
            if (e instanceof UserPasswordException) {
                SessionErrors.add((HttpServletRequest)request, e.getClass(), (Object)e);
                return actionMapping.findForward("portal.update_password");
            }
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((HttpServletRequest)request, e.getClass());
                return actionMapping.findForward("portal.error");
            }
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected Ticket getTicket(HttpServletRequest request) {
        String ticketKey = ParamUtil.getString((HttpServletRequest)request, (String)"ticketKey");
        if (Validator.isNull((String)ticketKey)) {
            return null;
        }
        try {
            Ticket ticket = TicketLocalServiceUtil.fetchTicket((String)ticketKey);
            if (ticket == null || ticket.getType() != 3) {
                return null;
            }
            if (!ticket.isExpired()) {
                return ticket;
            }
            TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected boolean isValidatePassword(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Boolean setupWizardPasswordUpdated = (Boolean)session.getAttribute("SETUP_WIZARD_PASSWORD_UPDATED");
        return setupWizardPasswordUpdated == null || setupWizardPasswordUpdated == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePassword(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay, Ticket ticket) throws Exception {
        AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)UpdatePasswordAction.class.getName());
        long userId = 0L;
        userId = ticket != null ? ticket.getClassPK() : themeDisplay.getUserId();
        String password1 = request.getParameter("password1");
        String password2 = request.getParameter("password2");
        boolean passwordReset = false;
        boolean previousValidate = PwdToolkitUtilThreadLocal.isValidate();
        try {
            boolean currentValidate = this.isValidatePassword(request);
            PwdToolkitUtilThreadLocal.setValidate(currentValidate);
            UserLocalServiceUtil.updatePassword((long)userId, (String)password1, (String)password2, (boolean)passwordReset);
        }
        finally {
            PwdToolkitUtilThreadLocal.setValidate(previousValidate);
        }
        if (ticket != null) {
            TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
            UserLocalServiceUtil.updatePasswordReset((long)userId, (boolean)false);
        }
        User user = UserLocalServiceUtil.getUser((long)userId);
        Company company = CompanyLocalServiceUtil.getCompanyById((long)user.getCompanyId());
        String login = null;
        String authType = company.getAuthType();
        if (authType.equals("emailAddress")) {
            login = user.getEmailAddress();
        } else if (authType.equals("screenName")) {
            login = user.getScreenName();
        } else if (authType.equals("userId")) {
            login = String.valueOf(userId);
        }
        AuthenticatedSessionManagerUtil.login((HttpServletRequest)request, (HttpServletResponse)response, (String)login, (String)password1, (boolean)false, null);
    }
}

