/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.dao.orm.hibernate.DynamicQueryImpl;
import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.criterion.DetachedCriteria;

public class DynamicQueryFactoryImpl
implements DynamicQueryFactory {
    private static final Log _log = LogFactoryUtil.getLog(DynamicQueryFactoryImpl.class);
    private static final ConcurrentMap<ClassLoader, Map<String, Class<?>>> _classes = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private final ClassLoader _portalClassLoader = DynamicQueryFactoryImpl.class.getClassLoader();

    public DynamicQuery forClass(Class<?> clazz) {
        clazz = this.getImplClass(clazz, null);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    public DynamicQuery forClass(Class<?> clazz, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    public DynamicQuery forClass(Class<?> clazz, String alias) {
        clazz = this.getImplClass(clazz, null);
        if (alias != null) {
            return new DynamicQueryImpl(DetachedCriteria.forClass(clazz, (String)alias));
        }
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    public DynamicQuery forClass(Class<?> clazz, String alias, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        if (alias != null) {
            return new DynamicQueryImpl(DetachedCriteria.forClass(clazz, (String)alias));
        }
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    protected Class<?> getImplClass(Class<?> clazz, ClassLoader classLoader) {
        ImplementationClassName implementationClassName = clazz.getAnnotation(ImplementationClassName.class);
        if (implementationClassName == null) {
            String className = clazz.getName();
            if (!className.endsWith("Impl")) {
                _log.error((Object)("Unable find model for " + clazz));
            }
            return clazz;
        }
        Class<?> implClass = clazz;
        String implClassName = implementationClassName.value();
        try {
            implClass = this.getImplClass(implClassName, classLoader);
        }
        catch (Exception e1) {
            if (classLoader != this._portalClassLoader) {
                try {
                    implClass = this.getImplClass(implClassName, this._portalClassLoader);
                }
                catch (Exception e2) {
                    _log.error((Object)("Unable find model " + implClassName), (Throwable)e2);
                }
            }
            _log.error((Object)("Unable find model " + implClassName), (Throwable)e1);
        }
        return implClass;
    }

    protected Class<?> getImplClass(String implClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        HashMap classes = (HashMap)_classes.get(classLoader);
        if (classes == null) {
            classes = new HashMap();
            _classes.put(classLoader, classes);
        }
        if ((clazz = (Class<?>)classes.get(implClassName)) == null) {
            clazz = classLoader.loadClass(implClassName);
            classes.put(implClassName, clazz);
        }
        return clazz;
    }
}

