/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.PatcherUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcessUtil;
import java.sql.Connection;
import java.util.List;

public class StartupHelper {
    private static final String[] _UPGRADE_PROCESS_CLASS_NAMES = new String[]{"com.liferay.portal.upgrade.UpgradeProcess_6_1_1", "com.liferay.portal.upgrade.UpgradeProcess_6_2_0", "com.liferay.portal.upgrade.UpgradeProcess_7_0_0", "com.liferay.portal.upgrade.UpgradeProcess_7_0_1", "com.liferay.portal.upgrade.UpgradeProcess_7_0_3", "com.liferay.portal.upgrade.UpgradeProcess_7_0_5", "com.liferay.portal.upgrade.UpgradeProcess_7_0_6", "com.liferay.portal.upgrade.PortalUpgradeProcess"};
    private static final Log _log = LogFactoryUtil.getLog(StartupHelper.class);
    private boolean _dbNew;
    private boolean _dropIndexes;
    private boolean _startupFinished;
    private boolean _upgraded;
    private boolean _upgrading;
    private boolean _verified;

    public boolean isDBNew() {
        return this._dbNew;
    }

    public boolean isStartupFinished() {
        return this._startupFinished;
    }

    public boolean isUpgraded() {
        return this._upgraded;
    }

    public boolean isUpgrading() {
        return this._upgrading;
    }

    public boolean isVerified() {
        return this._verified;
    }

    public void printPatchLevel() {
        if (_log.isInfoEnabled() && !PatcherUtil.hasInconsistentPatchLevels()) {
            String installedPatches = StringUtil.merge((Object[])PatcherUtil.getInstalledPatches(), (String)", ");
            if (Validator.isNull((String)installedPatches)) {
                _log.info((Object)"There are no patches installed");
            } else {
                _log.info((Object)("The following patches are installed: " + installedPatches));
            }
        }
    }

    public void setDbNew(boolean dbNew) {
        this._dbNew = dbNew;
    }

    public void setDropIndexes(boolean dropIndexes) {
        this._dropIndexes = dropIndexes;
    }

    public void setStartupFinished(boolean startupFinished) {
        this._startupFinished = startupFinished;
    }

    public void updateIndexes() {
        this.updateIndexes(this._dropIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexes(boolean dropIndexes) {
        DB db = DBManagerUtil.getDB();
        Connection connection = null;
        try {
            connection = DataAccess.getConnection();
            this.updateIndexes(db, connection, dropIndexes);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
    }

    public void updateIndexes(DB db, Connection connection, boolean dropIndexes) {
        block2: {
            try {
                ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
                String tablesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
                String indexesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.sql");
                db.updateIndexes(connection, tablesSQL, indexesSQL, dropIndexes);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public void upgradeProcess(int buildNumber) throws UpgradeException {
        this._upgrading = true;
        try {
            List upgradeProcesses = UpgradeProcessUtil.initUpgradeProcesses((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String[])_UPGRADE_PROCESS_CLASS_NAMES);
            this._upgraded = UpgradeProcessUtil.upgradeProcess((int)buildNumber, (List)upgradeProcesses);
        }
        finally {
            this._upgrading = false;
        }
    }

    public void verifyProcess(boolean newBuildNumber, boolean verified) throws VerifyException {
        this._verified = VerifyProcessUtil.verifyProcess(this._upgraded, newBuildNumber, verified);
    }

    protected String[] getUpgradeProcessClassNames(String key) {
        return StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get(key)));
    }
}

