/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.client;

import com.liferay.portal.fabric.client.FabricClient;
import com.liferay.portal.fabric.local.agent.LocalFabricAgent;
import com.liferay.portal.fabric.netty.agent.NettyFabricAgentConfig;
import com.liferay.portal.fabric.netty.client.NettyFabricClientConfig;
import com.liferay.portal.fabric.netty.client.NettyFabricClientShutdownCallback;
import com.liferay.portal.fabric.netty.codec.serialization.AnnotatedObjectDecoder;
import com.liferay.portal.fabric.netty.codec.serialization.AnnotatedObjectEncoder;
import com.liferay.portal.fabric.netty.fileserver.handlers.FileRequestChannelHandler;
import com.liferay.portal.fabric.netty.fileserver.handlers.FileResponseChannelHandler;
import com.liferay.portal.fabric.netty.handlers.NettyChannelAttributes;
import com.liferay.portal.fabric.netty.handlers.NettyFabricWorkerExecutionChannelHandler;
import com.liferay.portal.fabric.netty.repository.NettyRepository;
import com.liferay.portal.fabric.netty.rpc.handlers.NettyRPCChannelHandler;
import com.liferay.portal.fabric.netty.util.NettyUtil;
import com.liferay.portal.fabric.repository.Repository;
import com.liferay.portal.fabric.worker.FabricWorker;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.process.TerminationProcessException;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.StringBundler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyFabricClient
implements FabricClient {
    private static final int _FABRIC_AGENT_SHUTDOWN_CODE = 211;
    private static final Log _log = LogFactoryUtil.getLog(NettyFabricClient.class);
    private static final ProcessCallable<Serializable> _runtimeExitProcessCallable = new ProcessCallable<Serializable>(){
        private static final long serialVersionUID = 1L;

        public Serializable call() {
            Runtime runtime = Runtime.getRuntime();
            runtime.exit(211);
            return null;
        }
    };
    private static final ProcessCallable<Serializable> _runtimeHaltProcessCallable = new ProcessCallable<Serializable>(){
        private static final long serialVersionUID = 1L;

        public Serializable call() {
            Runtime runtime = Runtime.getRuntime();
            runtime.halt(211);
            return null;
        }
    };
    private volatile Bootstrap _bootstrap;
    private volatile Channel _channel;
    private final NettyFabricClientConfig _nettyFabricClientConfig;
    private final NettyFabricClientShutdownCallback _nettyFabricClientShutdownCallback;
    private final ProcessExecutor _processExecutor;
    private final AtomicInteger _reconnectCounter = new AtomicInteger();
    private final Thread _shutdownThread = new Thread(){

        @Override
        public void run() {
            Channel channel = NettyFabricClient.this._channel;
            if (channel != null) {
                NettyFabricClient.this._reconnectCounter.set(0);
                ChannelFuture channelFuture = channel.close();
                channelFuture.syncUninterruptibly();
            }
        }
    };

    public NettyFabricClient(ProcessExecutor processExecutor, NettyFabricClientConfig nettyFabricClientConfig, NettyFabricClientShutdownCallback nettyFabricClientShutdownCallback) {
        this._processExecutor = processExecutor;
        this._nettyFabricClientConfig = nettyFabricClientConfig;
        this._nettyFabricClientShutdownCallback = nettyFabricClientShutdownCallback;
    }

    @Override
    public synchronized void connect() {
        if (this._channel != null) {
            throw new IllegalStateException("Netty fabric client was already started");
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Starting Netty fabric client using " + this._nettyFabricClientConfig));
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(this._shutdownThread);
        this._bootstrap = new Bootstrap();
        this._bootstrap.channel(NioSocketChannel.class);
        this._bootstrap.group((EventLoopGroup)new NioEventLoopGroup(this._nettyFabricClientConfig.getEventLoopGroupThreadCount(), (ThreadFactory)new NamedThreadFactory("Netty Fabric Client/NIO Event Loop Group", 5, null)));
        this._bootstrap.handler((ChannelHandler)new NettyFabricClientChannelInitializer());
        int reconnectCount = this._nettyFabricClientConfig.getReconnectCount();
        if (reconnectCount < 0) {
            reconnectCount = Integer.MAX_VALUE;
        }
        this._reconnectCounter.set(reconnectCount);
        this.doConnect();
    }

    @Override
    public synchronized java.util.concurrent.Future<?> disconnect() {
        if (this._channel == null) {
            throw new IllegalStateException("Netty fabric client is not started");
        }
        this._reconnectCounter.set(0);
        this._channel.close();
        EventLoopGroup eventExecutorGroup = this._bootstrap.group();
        Future future = eventExecutorGroup.terminationFuture();
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        future.addListener((GenericFutureListener)new FutureListener<Object>(){

            public void operationComplete(Future<Object> future) {
                defaultNoticeableFuture.run();
            }
        });
        return defaultNoticeableFuture;
    }

    protected EventExecutorGroup createEventExecutorGroup(int threadCount, String threadPoolName) {
        DefaultEventExecutorGroup eventExecutorGroup = new DefaultEventExecutorGroup(threadCount, (ThreadFactory)new NamedThreadFactory(threadPoolName, 5, null));
        NettyUtil.bindShutdown((EventExecutorGroup)this._bootstrap.group(), (EventExecutorGroup)eventExecutorGroup, this._nettyFabricClientConfig.getShutdownQuietPeriod(), this._nettyFabricClientConfig.getShutdownTimeout());
        return eventExecutorGroup;
    }

    protected void doConnect() {
        ChannelFuture channelFuture = this._bootstrap.connect(this._nettyFabricClientConfig.getNettyFabricServerHost(), this._nettyFabricClientConfig.getNettyFabricServerPort());
        this._channel = channelFuture.channel();
        channelFuture.addListener((GenericFutureListener)new PostConnectChannelFutureListener());
    }

    protected void terminateFabricWorkers(Channel channel) {
        Map<Long, FabricWorker<?>> fabricWorkers = NettyChannelAttributes.getFabricWorkers(channel);
        if (fabricWorkers == null) {
            return;
        }
        for (Map.Entry<Long, FabricWorker<?>> entry : fabricWorkers.entrySet()) {
            FabricWorker<?> fabricWorker = entry.getValue();
            fabricWorker.write(_runtimeExitProcessCallable);
            NoticeableFuture noticeableFuture = fabricWorker.getProcessNoticeableFuture();
            try {
                try {
                    noticeableFuture.get((long)this._nettyFabricClientConfig.getExecutionTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    fabricWorker.write(_runtimeHaltProcessCallable);
                    noticeableFuture.get((long)this._nettyFabricClientConfig.getExecutionTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable t) {
                Throwable cause;
                if (t instanceof ExecutionException && (cause = t.getCause()) instanceof TerminationProcessException) {
                    if (!_log.isWarnEnabled()) continue;
                    TerminationProcessException tpe = (TerminationProcessException)cause;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Forcibly terminate fabric worker ", String.valueOf(entry.getKey()), " with exit code ", String.valueOf(tpe.getExitCode())}));
                    continue;
                }
                _log.error((Object)("Unable to terminate fabric worker " + entry.getKey()), t);
            }
        }
    }

    protected class PostShutdownChannelFutureListener
    implements FutureListener<Object> {
        protected PostShutdownChannelFutureListener() {
        }

        public void operationComplete(Future<Object> future) {
            NettyFabricClient.this._channel = null;
            NettyFabricClient.this._bootstrap = null;
            NettyFabricClient.this._nettyFabricClientShutdownCallback.shutdown();
            if (NettyFabricClient.this._shutdownThread.getState() == Thread.State.NEW) {
                Runtime runtime = Runtime.getRuntime();
                runtime.removeShutdownHook(NettyFabricClient.this._shutdownThread);
            }
        }
    }

    protected class PostRegisterChannelFutureListener
    implements ChannelFutureListener {
        protected PostRegisterChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                int reconnectCount = NettyFabricClient.this._nettyFabricClientConfig.getReconnectCount();
                if (reconnectCount < 0) {
                    reconnectCount = Integer.MAX_VALUE;
                }
                NettyFabricClient.this._reconnectCounter.set(reconnectCount);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Registered Netty fabric agent on " + NettyFabricClient.this._channel));
                }
                return;
            }
            _log.error((Object)("Unable to register Netty fabric agent on " + NettyFabricClient.this._channel));
            NettyFabricClient.this._channel.close();
        }
    }

    protected class PostDisconnectChannelFutureListener
    implements ChannelFutureListener {
        protected final Repository<Channel> repository;

        public void operationComplete(ChannelFuture channelFuture) {
            NettyFabricClient.this.terminateFabricWorkers(NettyFabricClient.this._channel);
            this.repository.dispose(true);
            EventLoopGroup eventLoopGroup = NettyFabricClient.this._bootstrap.group();
            if (NettyFabricClient.this._reconnectCounter.getAndDecrement() > 0) {
                eventLoopGroup.schedule(new Runnable(){

                    @Override
                    public void run() {
                        NettyFabricClient.this.doConnect();
                    }
                }, NettyFabricClient.this._nettyFabricClientConfig.getReconnectInterval(), TimeUnit.MILLISECONDS);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Try to reconnect " + NettyFabricClient.this._nettyFabricClientConfig.getReconnectInterval() + " ms later"));
                }
            } else {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Shutting down Netty fabric client on " + NettyFabricClient.this._channel));
                }
                Future future = eventLoopGroup.shutdownGracefully(NettyFabricClient.this._nettyFabricClientConfig.getShutdownQuietPeriod(), NettyFabricClient.this._nettyFabricClientConfig.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                future.addListener((GenericFutureListener)new PostShutdownChannelFutureListener());
            }
        }

        protected PostDisconnectChannelFutureListener(Repository<Channel> repository) {
            this.repository = repository;
        }
    }

    protected class PostConnectChannelFutureListener
    implements ChannelFutureListener {
        protected PostConnectChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                Channel channel = channelFuture.channel();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Connected to " + channel.remoteAddress()));
                }
                Path repositoryPath = NettyFabricClient.this._nettyFabricClientConfig.getRepositoryPath();
                ChannelFuture registerChannelFuture = NettyFabricClient.this._channel.writeAndFlush((Object)new NettyFabricAgentConfig(repositoryPath.toFile()));
                registerChannelFuture.addListener((GenericFutureListener)new PostRegisterChannelFutureListener());
                return;
            }
            String serverAddress = NettyFabricClient.this._nettyFabricClientConfig.getNettyFabricServerHost() + ":" + NettyFabricClient.this._nettyFabricClientConfig.getNettyFabricServerPort();
            if (channelFuture.isCancelled()) {
                _log.error((Object)("Cancelled connecting to " + serverAddress));
            } else {
                _log.error((Object)("Unable to connect to " + serverAddress), channelFuture.cause());
            }
        }
    }

    protected class NettyFabricClientChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        protected NettyFabricClientChannelInitializer() {
        }

        protected void initChannel(SocketChannel socketChannel) throws IOException {
            Path repositoryPath = NettyFabricClient.this._nettyFabricClientConfig.getRepositoryPath();
            Files.createDirectories(repositoryPath, new FileAttribute[0]);
            NettyRepository repository = new NettyRepository(repositoryPath, NettyFabricClient.this._nettyFabricClientConfig.getRepositoryGetFileTimeout());
            ChannelFuture channelFuture = socketChannel.closeFuture();
            channelFuture.addListener((GenericFutureListener)new PostDisconnectChannelFutureListener(repository));
            ChannelPipeline channelPipeline = socketChannel.pipeline();
            channelPipeline.addLast(AnnotatedObjectEncoder.NAME, (ChannelHandler)AnnotatedObjectEncoder.INSTANCE);
            channelPipeline.addLast(AnnotatedObjectDecoder.NAME, (ChannelHandler)new AnnotatedObjectDecoder());
            EventExecutorGroup fileServerEventExecutorGroup = NettyFabricClient.this.createEventExecutorGroup(NettyFabricClient.this._nettyFabricClientConfig.getFileServerGroupThreadCount(), "Netty Fabric Client/File Server Event Executor Group");
            channelPipeline.addLast(fileServerEventExecutorGroup, FileRequestChannelHandler.NAME, (ChannelHandler)new FileRequestChannelHandler(NettyFabricClient.this._nettyFabricClientConfig.getFileServerFolderCompressionLevel()));
            channelPipeline.addLast(new ChannelHandler[]{new FileResponseChannelHandler(repository.getAsyncBroker(), fileServerEventExecutorGroup)});
            channelPipeline.addLast(NettyFabricClient.this.createEventExecutorGroup(NettyFabricClient.this._nettyFabricClientConfig.getRPCGroupThreadCount(), "Netty Fabric Client/RPC Event Executor Group"), NettyRPCChannelHandler.NAME, (ChannelHandler)NettyRPCChannelHandler.INSTANCE);
            channelPipeline.addLast(NettyFabricClient.this.createEventExecutorGroup(NettyFabricClient.this._nettyFabricClientConfig.getExecutionGroupThreadCount(), "Netty Fabric Client/Execution Event Executor Group"), new ChannelHandler[]{new NettyFabricWorkerExecutionChannelHandler(repository, new LocalFabricAgent(NettyFabricClient.this._processExecutor), NettyFabricClient.this._nettyFabricClientConfig.getExecutionTimeout())});
        }
    }
}

