/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.image.SpriteProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.TranslateDescriptor;
import javax.servlet.ServletContext;

public class SpriteProcessorImpl
implements SpriteProcessor {
    private static final int _NUM_OF_BANDS = 4;
    private static final Log _log = LogFactoryUtil.getLog(SpriteProcessorImpl.class);
    private static final Comparator<URL> _urlPathComparator = new Comparator<URL>(){

        @Override
        public int compare(URL url1, URL url2) {
            String path1 = url1.getPath();
            String path2 = url2.getPath();
            return path1.compareToIgnoreCase(path2);
        }
    };

    public Properties generate(ServletContext servletContext, List<URL> imageURLs, String spriteRootDirName, String spriteFileName, String spritePropertiesFileName, String rootPath, int maxHeight, int maxWidth, int maxSize) throws IOException {
        if (imageURLs.isEmpty()) {
            return null;
        }
        Collections.sort(imageURLs, _urlPathComparator);
        File spriteRootDir = null;
        if (Validator.isNull((String)spriteRootDirName)) {
            String servletContextName = servletContext.getServletContextName();
            if (servletContextName != null) {
                spriteRootDir = new File(StringBundler.concat((String[])new String[]{PropsUtil.get((String)"liferay.home"), "/work", "/sprite", "/", servletContextName}));
            } else {
                File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                spriteRootDir = new File(tempDir, "/sprite");
            }
        } else {
            spriteRootDir = new File(spriteRootDirName);
        }
        FileUtil.mkdirs((File)spriteRootDir);
        File spritePropertiesFile = new File(spriteRootDir, spritePropertiesFileName);
        File spritePropertiesParentFile = spritePropertiesFile.getParentFile();
        FileUtil.mkdirs((File)spritePropertiesParentFile);
        boolean build = false;
        long lastModified = 0L;
        if (spritePropertiesFile.exists()) {
            lastModified = spritePropertiesFile.lastModified();
            for (URL imageURL : imageURLs) {
                if (URLUtil.getLastModifiedTime((URL)imageURL) <= lastModified) continue;
                build = true;
                break;
            }
        } else {
            build = true;
        }
        if (!build) {
            String spritePropertiesString = FileUtil.read((File)spritePropertiesFile);
            if (Validator.isNull((String)spritePropertiesString)) {
                return null;
            }
            return PropertiesUtil.load((String)spritePropertiesString);
        }
        ArrayList<RenderedImage> renderedImages = new ArrayList<RenderedImage>();
        SortedProperties spriteProperties = new SortedProperties();
        float x = 0.0f;
        float y = 0.0f;
        URLConnection urlConnection = null;
        for (URL imageURL : imageURLs) {
            urlConnection = imageURL.openConnection();
            if (urlConnection != null && urlConnection.getContentLength() > maxSize) continue;
            try {
                ImageBag imageBag = ImageToolUtil.read((InputStream)urlConnection.getInputStream());
                RenderedImage renderedImage = imageBag.getRenderedImage();
                int height = renderedImage.getHeight();
                int width = renderedImage.getWidth();
                if (height > maxHeight || width > maxWidth) continue;
                renderedImage = this.convert(renderedImage);
                renderedImage = TranslateDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(x), (Float)Float.valueOf(y), null, null);
                y += (float)renderedImage.getHeight();
                renderedImages.add(renderedImage);
                String key = ServletContextUtil.getResourcePath((URL)imageURL);
                int pos = key.indexOf(rootPath);
                if (pos == 0) {
                    key = key.substring(rootPath.length());
                }
                String contextPath = servletContext.getContextPath();
                key = contextPath.concat(key);
                String value = StringBundler.concat((String[])new String[]{String.valueOf((int)y), ",", String.valueOf(height), ",", String.valueOf(width)});
                spriteProperties.setProperty(key, value);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to process " + imageURL), (Throwable)e);
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        if (renderedImages.size() <= 1) {
            renderedImages.clear();
            spriteProperties.clear();
        } else {
            RenderedOp renderedImage = MosaicDescriptor.create((RenderedImage[])renderedImages.toArray(new RenderedImage[renderedImages.size()]), (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null);
            File spriteFile = new File(spriteRootDir, spriteFileName);
            File spriteDir = spriteFile.getParentFile();
            FileUtil.mkdirs((File)spriteDir);
            try {
                ImageIO.write((RenderedImage)renderedImage, "png", spriteFile);
            }
            catch (Exception e) {
                if (e instanceof IIOException || e instanceof NullPointerException) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("Unable to generate ");
                        sb.append(spriteFileName);
                        sb.append(" for ");
                        sb.append(servletContext.getServletContextName());
                        _log.warn((Object)sb.toString());
                    }
                    return null;
                }
                throw e;
            }
            if (lastModified > 0L) {
                spriteFile.setLastModified(lastModified);
            }
        }
        FileUtil.write((File)spritePropertiesFile, (String)PropertiesUtil.toString((Properties)spriteProperties));
        if (lastModified > 0L) {
            spritePropertiesFile.setLastModified(lastModified);
        }
        return spriteProperties;
    }

    protected RenderedImage convert(RenderedImage renderedImage) throws Exception {
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = renderedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int mapSize = indexColorModel.getMapSize();
            byte[][] data = new byte[4][mapSize];
            indexColorModel.getReds(data[0]);
            indexColorModel.getGreens(data[1]);
            indexColorModel.getBlues(data[2]);
            indexColorModel.getAlphas(data[3]);
            LookupTableJAI lookupTableJAI = new LookupTableJAI(data);
            renderedImage = LookupDescriptor.create((RenderedImage)renderedImage, (LookupTableJAI)lookupTableJAI, null);
        } else if (sampleModel.getNumBands() == 1) {
            ArrayList<Byte> bytesList = new ArrayList<Byte>(height * width * 4);
            for (int i = 0; i < dataBuffer.getSize(); ++i) {
                byte elem = (byte)dataBuffer.getElem(i);
                if (elem == -1) {
                    bytesList.add((byte)0);
                } else {
                    bytesList.add((byte)-1);
                }
                bytesList.add(elem);
                bytesList.add(elem);
                bytesList.add(elem);
            }
            byte[] data = ArrayUtil.toArray((Byte[])bytesList.toArray(new Byte[bytesList.size()]));
            DataBufferByte newDataBuffer = new DataBufferByte(data, data.length);
            renderedImage = this.createRenderedImage(renderedImage, height, width, newDataBuffer);
        } else if (sampleModel.getNumBands() == 2) {
            ArrayList bytesList = new ArrayList(height * width * 4);
            ArrayList<Byte> tempBytesList = new ArrayList<Byte>(4);
            for (int i = 0; i < dataBuffer.getSize(); ++i) {
                int mod = (i + 1) % 2;
                int elemPos = i;
                if (mod == 0) {
                    tempBytesList.add((byte)dataBuffer.getElem(elemPos - 1));
                    tempBytesList.add((byte)dataBuffer.getElem(elemPos - 1));
                }
                tempBytesList.add((byte)dataBuffer.getElem(elemPos));
                if (mod != 0) continue;
                Collections.reverse(tempBytesList);
                bytesList.addAll(tempBytesList);
                tempBytesList.clear();
            }
            byte[] data = ArrayUtil.toArray((Byte[])bytesList.toArray(new Byte[bytesList.size()]));
            DataBufferByte newDataBuffer = new DataBufferByte(data, data.length);
            renderedImage = this.createRenderedImage(renderedImage, height, width, newDataBuffer);
        } else if (colorModel.getTransparency() != 3) {
            ArrayList bytesList = new ArrayList(height * width * 4);
            ArrayList<Byte> tempBytesList = new ArrayList<Byte>(4);
            for (int i = 0; i < dataBuffer.getSize(); ++i) {
                int mod = (i + 1) % 3;
                int elemPos = i;
                tempBytesList.add((byte)dataBuffer.getElem(elemPos));
                if (mod != 0) continue;
                tempBytesList.add((byte)-1);
                Collections.reverse(tempBytesList);
                bytesList.addAll(tempBytesList);
                tempBytesList.clear();
            }
            byte[] data = ArrayUtil.toArray((Byte[])bytesList.toArray(new Byte[bytesList.size()]));
            DataBufferByte newDataBuffer = new DataBufferByte(data, data.length);
            renderedImage = this.createRenderedImage(renderedImage, height, width, newDataBuffer);
        }
        return renderedImage;
    }

    protected RenderedImage createRenderedImage(RenderedImage renderedImage, int height, int width, DataBuffer dataBuffer) {
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)width, (int)height, (int)4);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        TiledImage tiledImage = new TiledImage(0, 0, width, height, 0, 0, sampleModel, colorModel);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        tiledImage.setData((Raster)raster);
        return tiledImage;
    }

    protected void printImage(RenderedImage renderedImage) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        int numOfBands = sampleModel.getNumBands();
        int[] pixels = new int[height * width * numOfBands];
        Raster raster = renderedImage.getData();
        raster.getPixels(0, 0, width, height, pixels);
        int offset = 0;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                offset = h * width * numOfBands + w * numOfBands;
                System.out.print(StringBundler.concat((String[])new String[]{"[", String.valueOf(w), ", ", String.valueOf(h), "] = "}));
                for (int b = 0; b < numOfBands; ++b) {
                    System.out.print(pixels[offset + b] + " ");
                }
            }
            System.out.println();
        }
    }
}

