/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.security.SecureRandom;
import com.liferay.portal.kernel.security.pwd.BasicToolkit;
import com.liferay.portal.kernel.service.PasswordTrackerLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.words.WordsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class PasswordPolicyToolkit
extends BasicToolkit {
    private final char[] _generatorAlphanumericCharsetArray;
    private final String _generatorCompleteCharset;
    private final char[] _generatorLowerCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_LOWERCASE);
    private final char[] _generatorNumbersCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_NUMBERS);
    private final char[] _generatorSymbolsCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_SYMBOLS);
    private final char[] _generatorUpperCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_UPPERCASE);
    private final char[] _validatorAlphanumericCharsetArray;
    private final char[] _validatorLowerCaseCharsetArray;
    private final char[] _validatorNumbersCharsetArray;
    private final char[] _validatorSymbolsCharsetArray;
    private final char[] _validatorUpperCaseCharsetArray;

    public PasswordPolicyToolkit() {
        this._generatorAlphanumericCharsetArray = ArrayUtil.append((char[][])new char[][]{this._generatorLowerCaseCharsetArray, this._generatorUpperCaseCharsetArray, this._generatorNumbersCharsetArray});
        Arrays.sort(this._generatorAlphanumericCharsetArray);
        StringBundler sb = new StringBundler(4);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_LOWERCASE);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_NUMBERS);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_SYMBOLS);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR_CHARSET_UPPERCASE);
        this._generatorCompleteCharset = sb.toString();
        this._validatorLowerCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_VALIDATOR_CHARSET_LOWERCASE);
        this._validatorNumbersCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_VALIDATOR_CHARSET_NUMBERS);
        this._validatorSymbolsCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_VALIDATOR_CHARSET_SYMBOLS);
        this._validatorUpperCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_VALIDATOR_CHARSET_UPPERCASE);
        this._validatorAlphanumericCharsetArray = ArrayUtil.append((char[][])new char[][]{this._validatorLowerCaseCharsetArray, this._validatorUpperCaseCharsetArray, this._validatorNumbersCharsetArray});
        Arrays.sort(this._validatorAlphanumericCharsetArray);
    }

    public String generate(PasswordPolicy passwordPolicy) {
        if (PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR.equals("static")) {
            return this.generateStatic(passwordPolicy);
        }
        return this.generateDynamic(passwordPolicy);
    }

    public void validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        long minAge;
        Date now;
        long passwordModificationElapsedTime;
        if (passwordPolicy.isCheckSyntax()) {
            if (!passwordPolicy.isAllowDictionaryWords() && WordsUtil.isDictionaryWord((String)password1)) {
                throw new UserPasswordException.MustNotContainDictionaryWords(userId, WordsUtil.getDictionaryList());
            }
            if (password1.length() < passwordPolicy.getMinLength()) {
                throw new UserPasswordException.MustBeLonger(userId, passwordPolicy.getMinLength());
            }
            if (this.getUsageCount(password1, this._validatorAlphanumericCharsetArray) < passwordPolicy.getMinAlphanumeric()) {
                throw new UserPasswordException.MustHaveMoreAlphanumeric((long)passwordPolicy.getMinAlphanumeric());
            }
            if (this.getUsageCount(password1, this._validatorLowerCaseCharsetArray) < passwordPolicy.getMinLowerCase()) {
                throw new UserPasswordException.MustHaveMoreLowercase((long)passwordPolicy.getMinLowerCase());
            }
            if (this.getUsageCount(password1, this._validatorNumbersCharsetArray) < passwordPolicy.getMinNumbers()) {
                throw new UserPasswordException.MustHaveMoreNumbers((long)passwordPolicy.getMinNumbers());
            }
            if (this.getUsageCount(password1, this._validatorSymbolsCharsetArray) < passwordPolicy.getMinSymbols()) {
                throw new UserPasswordException.MustHaveMoreSymbols((long)passwordPolicy.getMinSymbols());
            }
            if (this.getUsageCount(password1, this._validatorUpperCaseCharsetArray) < passwordPolicy.getMinUpperCase()) {
                throw new UserPasswordException.MustHaveMoreUppercase((long)passwordPolicy.getMinUpperCase());
            }
            String regex = passwordPolicy.getRegex();
            if (Validator.isNotNull((String)regex) && !password1.matches(regex)) {
                throw new UserPasswordException.MustComplyWithRegex(userId, regex);
            }
        }
        if (!passwordPolicy.isChangeable() && userId != 0L) {
            throw new UserPasswordException.MustNotBeChanged(userId);
        }
        if (userId == 0L) {
            return;
        }
        User user = UserLocalServiceUtil.getUserById((long)userId);
        Date passwordModfiedDate = user.getPasswordModifiedDate();
        if (passwordModfiedDate != null && (passwordModificationElapsedTime = (now = new Date()).getTime() - passwordModfiedDate.getTime()) < (minAge = passwordPolicy.getMinAge() * 1000L) && !user.isPasswordReset()) {
            throw new UserPasswordException.MustNotBeChangedYet(userId, new Date(passwordModfiedDate.getTime() + minAge));
        }
        if (PasswordTrackerLocalServiceUtil.isSameAsCurrentPassword((long)userId, (String)password1)) {
            throw new UserPasswordException.MustNotBeEqualToCurrent(userId);
        }
        if (!PasswordTrackerLocalServiceUtil.isValidPassword((long)userId, (String)password1)) {
            throw new UserPasswordException.MustNotBeRecentlyUsed(userId);
        }
    }

    protected String generateDynamic(PasswordPolicy passwordPolicy) {
        int count;
        int alphanumericActualMinLength = passwordPolicy.getMinLowerCase() + passwordPolicy.getMinNumbers() + passwordPolicy.getMinUpperCase();
        int alphanumericMinLength = Math.max(passwordPolicy.getMinAlphanumeric(), alphanumericActualMinLength);
        int passwordMinLength = Math.max(passwordPolicy.getMinLength(), alphanumericMinLength + passwordPolicy.getMinSymbols());
        StringBundler sb = new StringBundler(6);
        if (passwordPolicy.getMinLowerCase() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinLowerCase(), this._generatorLowerCaseCharsetArray));
        }
        if (passwordPolicy.getMinNumbers() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinNumbers(), this._generatorNumbersCharsetArray));
        }
        if (passwordPolicy.getMinSymbols() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinSymbols(), this._generatorSymbolsCharsetArray));
        }
        if (passwordPolicy.getMinUpperCase() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinUpperCase(), this._generatorUpperCaseCharsetArray));
        }
        if (alphanumericMinLength > alphanumericActualMinLength) {
            count = alphanumericMinLength - alphanumericActualMinLength;
            sb.append(this.getRandomString(count, this._generatorAlphanumericCharsetArray));
        }
        if (passwordMinLength > alphanumericMinLength + passwordPolicy.getMinSymbols()) {
            count = passwordMinLength - (alphanumericMinLength + passwordPolicy.getMinSymbols());
            sb.append(PwdGenerator.getPassword((String)this._generatorCompleteCharset, (int)count));
        }
        if (sb.index() == 0) {
            sb.append(PwdGenerator.getPassword((String)this._generatorCompleteCharset, (int)PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_LENGTH));
        }
        return RandomUtil.shuffle((Random)new SecureRandom(), (String)sb.toString());
    }

    protected String generateStatic(PasswordPolicy passwordPolicy) {
        return PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_STATIC;
    }

    protected String getRandomString(int count, char[] chars) {
        SecureRandom random = new SecureRandom();
        StringBundler sb = new StringBundler(count);
        for (int i = 0; i < count; ++i) {
            int index = random.nextInt(chars.length);
            sb.append(chars[index]);
        }
        return sb.toString();
    }

    protected char[] getSortedCharArray(String s) {
        char[] chars = s.toCharArray();
        Arrays.sort(chars);
        return chars;
    }

    protected int getUsageCount(String s, char[] chars) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (Arrays.binarySearch(chars, s.charAt(i)) < 0) continue;
            ++count;
        }
        return count;
    }
}

