/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.spring.aop.AdvisedSupport;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class LayoutSetLocalServiceStagingAdvice
implements BeanFactoryAware {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceStagingAdvice.class);
    private BeanFactory _beanFactory;

    public void afterPropertiesSet() throws Exception {
        AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(this._beanFactory.getBean(LayoutSetLocalService.class.getName()));
        advisedSupport.setTarget(ProxyUtil.newProxyInstance((ClassLoader)LayoutSetLocalServiceStagingAdvice.class.getClassLoader(), (Class[])new Class[]{LayoutSetLocalService.class}, (InvocationHandler)new LayoutSetLocalServiceStagingInvocationHandler(advisedSupport.getTarget())));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this._beanFactory = beanFactory;
    }

    protected LayoutSet wrapLayoutSet(LayoutSet layoutSet) {
        try {
            if (!LayoutStagingUtil.isBranchingLayoutSet((Group)layoutSet.getGroup(), (boolean)layoutSet.isPrivateLayout())) {
                return layoutSet;
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return layoutSet;
        }
        return (LayoutSet)ProxyUtil.newProxyInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (Class[])new Class[]{LayoutSet.class, ModelWrapper.class}, (InvocationHandler)new LayoutSetStagingHandler(layoutSet));
    }

    protected List<LayoutSet> wrapLayoutSets(List<LayoutSet> layoutSets) {
        if (layoutSets.isEmpty()) {
            return layoutSets;
        }
        ArrayList<LayoutSet> wrappedLayoutSets = new ArrayList<LayoutSet>(layoutSets.size());
        for (LayoutSet layoutSet : layoutSets) {
            wrappedLayoutSets.add(this.wrapLayoutSet(layoutSet));
        }
        return wrappedLayoutSets;
    }

    private class LayoutSetLocalServiceStagingInvocationHandler
    implements InvocationHandler {
        private final Object _targetObject;

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            try {
                List list;
                List<LayoutSet> returnValue = method.invoke(this._targetObject, arguments);
                if (!StagingAdvicesThreadLocal.isEnabled()) {
                    return returnValue;
                }
                if (returnValue instanceof LayoutSet) {
                    return LayoutSetLocalServiceStagingAdvice.this.wrapLayoutSet((LayoutSet)returnValue);
                }
                if (returnValue instanceof List && !(list = (List)returnValue).isEmpty() && list.get(0) instanceof LayoutSet) {
                    returnValue = LayoutSetLocalServiceStagingAdvice.this.wrapLayoutSets(returnValue);
                }
                return returnValue;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        private LayoutSetLocalServiceStagingInvocationHandler(Object targetObject) {
            this._targetObject = targetObject;
        }
    }
}

