/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchWorkflowInstanceLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.base.WorkflowInstanceLinkLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowInstanceLinkLocalServiceImpl
extends WorkflowInstanceLinkLocalServiceBaseImpl {
    public WorkflowInstanceLink addWorkflowInstanceLink(long userId, long companyId, long groupId, String className, long classPK, long workflowInstanceId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        long workflowInstanceLinkId = this.counterLocalService.increment();
        WorkflowInstanceLink workflowInstanceLink = this.workflowInstanceLinkPersistence.create(workflowInstanceLinkId);
        workflowInstanceLink.setGroupId(groupId);
        workflowInstanceLink.setCompanyId(companyId);
        workflowInstanceLink.setUserId(userId);
        workflowInstanceLink.setUserName(user.getFullName());
        workflowInstanceLink.setClassNameId(classNameId);
        workflowInstanceLink.setClassPK(classPK);
        workflowInstanceLink.setWorkflowInstanceId(workflowInstanceId);
        this.workflowInstanceLinkPersistence.update((BaseModel)workflowInstanceLink);
        return workflowInstanceLink;
    }

    @Override
    public WorkflowInstanceLink deleteWorkflowInstanceLink(long workflowInstanceLinkId) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = this.fetchWorkflowInstanceLink(workflowInstanceLinkId);
        return this.deleteWorkflowInstanceLink(workflowInstanceLink);
    }

    public WorkflowInstanceLink deleteWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = this.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        return this.deleteWorkflowInstanceLink(workflowInstanceLink);
    }

    @Override
    public WorkflowInstanceLink deleteWorkflowInstanceLink(WorkflowInstanceLink workflowInstanceLink) throws PortalException {
        if (workflowInstanceLink == null) {
            return null;
        }
        super.deleteWorkflowInstanceLink(workflowInstanceLink);
        WorkflowInstanceManagerUtil.deleteWorkflowInstance((long)workflowInstanceLink.getCompanyId(), (long)workflowInstanceLink.getWorkflowInstanceId());
        return workflowInstanceLink;
    }

    public void deleteWorkflowInstanceLinks(long companyId, long groupId, String className, long classPK) throws PortalException {
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, classPK);
        for (WorkflowInstanceLink workflowInstanceLink : workflowInstanceLinks) {
            this.deleteWorkflowInstanceLink(workflowInstanceLink);
        }
    }

    public WorkflowInstanceLink fetchWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) {
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, classPK);
        if (!workflowInstanceLinks.isEmpty()) {
            return workflowInstanceLinks.get(0);
        }
        return null;
    }

    public String getState(long companyId, long groupId, String className, long classPK) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = this.getWorkflowInstanceLink(companyId, groupId, className, classPK);
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
        return workflowInstance.getState();
    }

    public WorkflowInstanceLink getWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) throws PortalException {
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, classPK);
        if (workflowInstanceLinks.isEmpty()) {
            StringBundler sb = new StringBundler(9);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append(", className=");
            sb.append(className);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            throw new NoSuchWorkflowInstanceLinkException(sb.toString());
        }
        return workflowInstanceLinks.get(0);
    }

    public List<WorkflowInstanceLink> getWorkflowInstanceLinks(long companyId, long groupId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.workflowInstanceLinkPersistence.findByG_C_C_C(groupId, companyId, classNameId, classPK);
    }

    public boolean hasWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) {
        WorkflowInstanceLink workflowInstanceLink = this.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        return workflowInstanceLink != null;
    }

    public boolean isEnded(long companyId, long groupId, String className, long classPK) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = this.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        if (workflowInstanceLink == null) {
            return false;
        }
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
        return workflowInstance.getEndDate() != null;
    }

    public void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, Map<String, Serializable> workflowContext) throws PortalException {
        if (!WorkflowThreadLocal.isEnabled()) {
            return;
        }
        if (userId == 0L) {
            userId = this.userLocalService.getDefaultUserId(companyId);
        }
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
        WorkflowDefinitionLink workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(companyId, groupId, classPK);
        String workflowDefinitionName = workflowDefinitionLink.getWorkflowDefinitionName();
        int workflowDefinitionVersion = workflowDefinitionLink.getWorkflowDefinitionVersion();
        workflowContext = workflowContext != null ? new HashMap<String, Serializable>(workflowContext) : new HashMap<String, Serializable>();
        workflowContext.put("companyId", (Serializable)((Object)String.valueOf(companyId)));
        workflowContext.put("groupId", (Serializable)((Object)String.valueOf(groupId)));
        workflowContext.put("entryClassName", (Serializable)((Object)className));
        workflowContext.put("entryClassPK", (Serializable)((Object)String.valueOf(classPK)));
        workflowContext.put("entryType", (Serializable)((Object)workflowHandler.getType(LocaleUtil.getDefault())));
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.startWorkflowInstance((long)companyId, (long)groupId, (long)userId, (String)workflowDefinitionName, (Integer)workflowDefinitionVersion, null, workflowContext);
        this.addWorkflowInstanceLink(userId, companyId, groupId, className, classPK, workflowInstance.getWorkflowInstanceId());
    }

    public void updateClassPK(long companyId, long groupId, String className, long oldClassPK, long newClassPK) throws PortalException {
        if (!WorkflowThreadLocal.isEnabled()) {
            return;
        }
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, oldClassPK);
        for (WorkflowInstanceLink workflowInstanceLink : workflowInstanceLinks) {
            WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)workflowInstanceLink.getCompanyId(), (long)workflowInstanceLink.getWorkflowInstanceId());
            workflowInstanceLink.setClassPK(newClassPK);
            this.workflowInstanceLinkPersistence.update((BaseModel)workflowInstanceLink);
            HashMap<String, String> workflowContext = new HashMap<String, String>(workflowInstance.getWorkflowContext());
            workflowContext.put("entryClassPK", String.valueOf(newClassPK));
            WorkflowInstanceManagerUtil.updateWorkflowContext((long)workflowInstanceLink.getCompanyId(), (long)workflowInstanceLink.getWorkflowInstanceId(), workflowContext);
        }
    }
}

