/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.persistence.TeamFinder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.TeamImpl;
import com.liferay.portal.service.persistence.impl.TeamFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TeamFinderImpl
extends TeamFinderBaseImpl
implements TeamFinder {
    public static final String COUNT_BY_G_N_D = TeamFinder.class.getName() + ".countByG_N_D";
    public static final String FIND_BY_G_U = TeamFinder.class.getName() + ".findByG_U";
    public static final String FIND_BY_G_N_D = TeamFinder.class.getName() + ".findByG_N_D";
    public static final String JOIN_BY_USERS_USER_GROUPS = TeamFinder.class.getName() + ".joinByUsersUserGroups";
    public static final String JOIN_BY_USERS_TEAMS = TeamFinder.class.getName() + ".joinByUsersTeams";

    public int countByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.doCountByG_N_D(groupId, name, description, params, false);
    }

    public int filterCountByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.doCountByG_N_D(groupId, name, description, params, true);
    }

    public List<Team> filterFindByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        return this.doFindByG_N_D(groupId, name, description, params, start, end, obc, true);
    }

    public List<Team> findByG_U(long groupId, long userId, int start, int end, OrderByComparator<Team> obc) {
        return this.doFindByG_U(groupId, userId, start, end, obc);
    }

    public List<Team> findByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        return this.doFindByG_N_D(groupId, name, description, params, start, end, obc, false);
    }

    protected int doCountByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params, boolean inlineSQLHelper) {
        name = CustomSQLUtil.keywords((String)name)[0];
        description = CustomSQLUtil.keywords((String)description)[0];
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_D);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)Team.class.getName(), (String)"Team.teamId", (long)groupId);
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Team> doFindByG_U(long groupId, long userId, int start, int end, OrderByComparator<Team> obc) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_U);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Team", TeamImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            qPos.add(userId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Team> doFindByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc, boolean inlineSQLHelper) {
        name = CustomSQLUtil.keywords((String)name)[0];
        description = CustomSQLUtil.keywords((String)description)[0];
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_D);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)Team.class.getName(), (String)"Team.teamId", (long)groupId);
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Team", TeamImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("usersTeams")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_TEAMS);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        String join = "";
        if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("usersTeams")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_TEAMS);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5).concat(" AND ") : "";
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Long valueLong;
            Object value = entry.getValue();
            if (!(value instanceof Long) || !Validator.isNotNull((Long)(valueLong = (Long)value))) continue;
            qPos.add(valueLong);
        }
    }
}

