/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalInstances;
import javax.servlet.http.HttpServletRequest;

public class UserResolver {
    private final long _companyId;
    private final User _user;

    public UserResolver(HttpServletRequest request) throws PortalException {
        long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
        User user = null;
        String remoteUser = request.getRemoteUser();
        long userId = GetterUtil.getLong((String)remoteUser);
        if (userId == 0L) {
            remoteUser = null;
        }
        if (remoteUser != null) {
            PrincipalThreadLocal.setName((String)remoteUser);
            user = UserLocalServiceUtil.getUserById((long)userId);
            if (companyId == 0L) {
                companyId = user.getCompanyId();
            }
        } else {
            if (companyId == 0L) {
                companyId = PortalInstances.getCompanyId(request);
            }
            if (companyId != 0L) {
                user = UserLocalServiceUtil.getDefaultUser((long)companyId);
            }
        }
        this._companyId = companyId;
        this._user = user;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public User getUser() {
        return this._user;
    }
}

