/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class BaseAuthFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(BaseAuthFilter.class);
    private boolean _basicAuthEnabled;
    private boolean _digestAuthEnabled;
    private Set<String> _hostsAllowed;
    private boolean _httpsRequired;
    private boolean _usePermissionChecker;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._basicAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("basic_auth"));
        this._digestAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("digest_auth"));
        String propertyPrefix = filterConfig.getInitParameter("portal_property_prefix");
        String[] hostsAllowed = null;
        if (Validator.isNull((String)propertyPrefix)) {
            hostsAllowed = StringUtil.split((String)filterConfig.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)filterConfig.getInitParameter("https.required"));
        } else {
            hostsAllowed = PropsUtil.getArray(propertyPrefix + "hosts.allowed");
            this._httpsRequired = GetterUtil.getBoolean((String)PropsUtil.get(propertyPrefix + "https.required"));
        }
        this._hostsAllowed = hostsAllowed.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(hostsAllowed));
        this._usePermissionChecker = GetterUtil.getBoolean((String)filterConfig.getInitParameter("use_permission_checker"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HttpServletRequest basicAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        User user = (User)session.getAttribute("USER");
        if (user == null) {
            long userId = 0L;
            try {
                userId = HttpAuthManagerUtil.getBasicUserId((HttpServletRequest)request);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (userId > 0L) {
                return this.setCredentials(request, session, UserLocalServiceUtil.getUser((long)userId), "BASIC");
            }
            HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
            HttpAuthManagerUtil.generateChallenge((HttpServletRequest)request, (HttpServletResponse)response, (HttpAuthorizationHeader)httpAuthorizationHeader);
            return null;
        }
        request = new ProtectedServletRequest(request, String.valueOf(user.getUserId()), "BASIC");
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HttpServletRequest digestAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        User user = (User)session.getAttribute("USER");
        if (user == null) {
            long userId = 0L;
            try {
                userId = HttpAuthManagerUtil.getDigestUserId((HttpServletRequest)request);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (userId > 0L) {
                return this.setCredentials(request, session, UserLocalServiceUtil.getUser((long)userId), "DIGEST");
            }
            HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
            HttpAuthManagerUtil.generateChallenge((HttpServletRequest)request, (HttpServletResponse)response, (HttpAuthorizationHeader)httpAuthorizationHeader);
            return null;
        }
        request = new ProtectedServletRequest(request, String.valueOf(user.getUserId()), "DIGEST");
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
        return request;
    }

    @Deprecated
    protected void initThreadLocals(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        User user = (User)session.getAttribute("USER");
        this.initThreadLocals(user);
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
    }

    protected void initThreadLocals(User user) throws Exception {
        CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
        long userId = user.getUserId();
        PrincipalThreadLocal.setName((long)userId);
        if (!this._usePermissionChecker) {
            return;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && permissionChecker.getUserId() == userId) {
            return;
        }
        permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (AccessControlUtil.isAccessAllowed((HttpServletRequest)request, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + request.getRemoteAddr()));
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Access denied for " + request.getRemoteAddr()));
            }
            response.sendError(403, "Access denied for " + request.getRemoteAddr());
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug((Object)"https is required");
            } else {
                _log.debug((Object)"https is not required");
            }
        }
        if (this._httpsRequired && !request.isSecure()) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Securing " + completeURL));
            }
            StringBundler sb = new StringBundler(5);
            sb.append("https://");
            sb.append(request.getServerName());
            sb.append(request.getServletPath());
            String queryString = request.getQueryString();
            if (Validator.isNotNull((String)queryString)) {
                sb.append("?");
                sb.append(request.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect to " + sb.toString()));
            }
            response.sendRedirect(sb.toString());
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not securing " + HttpUtil.getCompleteURL((HttpServletRequest)request)));
            }
            User user = null;
            try {
                user = PortalUtil.initUser((HttpServletRequest)request);
            }
            catch (NoSuchUserException nsue) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsue, (Throwable)nsue);
                }
                response.sendRedirect(HttpUtil.getCompleteURL((HttpServletRequest)request));
                return;
            }
            this.initThreadLocals(user);
            if (!user.isDefaultUser()) {
                String authType = ParamUtil.getString((HttpServletRequest)request, (String)"authType");
                if (authType == null) {
                    Company company = PortalUtil.getCompany((HttpServletRequest)request);
                    authType = company.getAuthType();
                }
                request = this.setCredentials(request, request.getSession(), user, authType);
            } else if (this._digestAuthEnabled) {
                request = this.digestAuth(request, response);
            } else if (this._basicAuthEnabled) {
                request = this.basicAuth(request, response);
            }
            if (request != null) {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                this.processFilter(clazz.getName(), request, response, filterChain);
            }
        }
    }

    @Deprecated
    protected HttpServletRequest setCredentials(HttpServletRequest request, HttpSession session, long userId, String authType) throws Exception {
        return this.setCredentials(request, session, UserLocalServiceUtil.getUser((long)userId), authType);
    }

    protected HttpServletRequest setCredentials(HttpServletRequest request, HttpSession session, User user, String authType) throws Exception {
        request = new ProtectedServletRequest(request, String.valueOf(user.getUserId()), authType);
        session.setAttribute("USER", (Object)user);
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
        return request;
    }

    protected void setUsePermissionChecker(boolean usePermissionChecker) {
        this._usePermissionChecker = usePermissionChecker;
    }
}

