/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.uploadservletrequest;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServletRequestFilter
extends BasePortalFilter {
    public static final String COPY_MULTIPART_STREAM_TO_FILE = UploadServletRequestFilter.class.getName() + "#COPY_MULTIPART_STREAM_TO_FILE";

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        String contentType = request.getHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long companyId;
        Portlet portlet;
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        int fileSizeThreshold = 0;
        String location = null;
        long maxRequestSize = 0L;
        long maxFileSize = 0L;
        if (Validator.isNotNull((String)portletId) && (portlet = PortletLocalServiceUtil.getPortletById((long)(companyId = PortalUtil.getCompanyId((HttpServletRequest)request)), (String)portletId)) != null) {
            ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
            InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
            LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)invokerPortlet.getPortletConfig();
            if (liferayPortletConfig.isCopyRequestParameters() || !liferayPortletConfig.isWARFile()) {
                request.setAttribute(COPY_MULTIPART_STREAM_TO_FILE, (Object)Boolean.FALSE);
            }
            fileSizeThreshold = portlet.getMultipartFileSizeThreshold();
            location = portlet.getMultipartLocation();
            maxRequestSize = portlet.getMultipartMaxRequestSize();
            maxFileSize = portlet.getMultipartMaxFileSize();
        }
        UploadServletRequest uploadServletRequest = PortalUtil.getUploadServletRequest((HttpServletRequest)request, (int)fileSizeThreshold, location, (long)maxRequestSize, (long)maxFileSize);
        try {
            this.processFilter(UploadServletRequestFilter.class.getName(), (HttpServletRequest)uploadServletRequest, response, filterChain);
        }
        finally {
            uploadServletRequest.cleanUp();
        }
    }
}

