/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.dao.orm.hibernate.FieldInterceptionHelperUtil;
import com.liferay.portal.deploy.hot.CustomJspBagRegistryUtil;
import com.liferay.portal.deploy.hot.ServiceWrapperRegistry;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactory;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.PortletSessionListenerManager;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.servlet.PortalSessionListener;
import com.liferay.portal.spring.aop.DynamicProxyCreator;
import com.liferay.portal.spring.context.ArrayApplicationContext;
import com.liferay.portal.spring.context.PortalApplicationContext;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.sql.DataSource;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private static final Field _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD;
    private static final Log _log;
    private static String _portalServletContextName;
    private static String _portalServletContextPath;
    private ArrayApplicationContext _arrayApplicationContext;
    private ServiceWrapperRegistry _serviceWrapperRegistry;

    public static String getPortalServletContextName() {
        return _portalServletContextName;
    }

    public static String getPortalServletContextPath() {
        return _portalServletContextPath;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ThreadLocalCacheManager.destroy();
        if (this._serviceWrapperRegistry != null) {
            this._serviceWrapperRegistry.close();
        }
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            DirectServletRegistryUtil.clearServlets();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            HotDeployUtil.reset();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            PortalLifecycleUtil.reset();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this.closeDataSource("counterDataSourceImpl");
        this.closeDataSource("liferayDataSourceImpl");
        super.contextDestroyed(servletContextEvent);
        try {
            ModuleFrameworkUtilAdapter.stopRuntime();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            ModuleFrameworkUtilAdapter.stopFramework(PropsValues.MODULE_FRAMEWORK_STOP_WAIT_TIMEOUT);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        ModuleFrameworkUtilAdapter.unregisterContext((Object)this._arrayApplicationContext);
        this._arrayApplicationContext.close();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Class.forName(SystemProperties.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        DBManagerUtil.reset();
        DeployManagerUtil.reset();
        InstancePool.reset();
        MethodKey.resetCache();
        PortalBeanLocatorUtil.reset();
        PortletBagPool.reset();
        ReferenceRegistry.releaseReferences();
        FieldInterceptionHelperUtil.initialize();
        ServletContext servletContext = servletContextEvent.getServletContext();
        String portalLibDir = servletContext.getRealPath("/WEB-INF/lib");
        portalLibDir = StringUtil.replace((String)portalLibDir, (char)'\\', (char)'/');
        if (Validator.isNotNull((String)portalLibDir)) {
            SystemProperties.set((String)"liferay.lib.portal.dir", (String)portalLibDir);
        }
        ClassPathUtil.initializeClassPaths((ServletContext)servletContext);
        PortalClassPathUtil.initializeClassPaths(servletContext);
        InitUtil.init();
        _portalServletContextName = servletContext.getServletContextName();
        if (_portalServletContextName == null) {
            _portalServletContextName = "";
        }
        if (ServerDetector.isJetty() && _portalServletContextName.equals("/")) {
            _portalServletContextName = "";
        }
        _portalServletContextPath = servletContext.getContextPath();
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = tempDir.getAbsolutePath();
        try {
            ModuleFrameworkUtilAdapter.initFramework();
            this._arrayApplicationContext = new ArrayApplicationContext(PropsValues.SPRING_INFRASTRUCTURE_CONFIGS);
            servletContext.setAttribute(PortalApplicationContext.PARENT_APPLICATION_CONTEXT, (Object)this._arrayApplicationContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
        ClassLoaderPool.register((String)_portalServletContextName, (ClassLoader)portalClassLoader);
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                PortalContextLoaderListener.this._serviceWrapperRegistry = new ServiceWrapperRegistry();
            }

            public void destroy() {
            }
        });
        serviceDependencyManager.registerDependencies(new Class[]{MessageBus.class, PortalExecutorManager.class, SchedulerEngineHelper.class, SingleDestinationMessageSenderFactory.class});
        FutureTask<Void> springInitTask = new FutureTask<Void>(() -> {
            super.contextInitialized(servletContextEvent);
            return null;
        });
        Thread springInitThread = new Thread(springInitTask, "Portal Spring Init Thread");
        springInitThread.setDaemon(true);
        springInitThread.start();
        try {
            ModuleFrameworkUtilAdapter.registerContext((Object)this._arrayApplicationContext);
            ModuleFrameworkUtilAdapter.startFramework();
            ModuleFrameworkUtilAdapter.startRuntime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            springInitTask.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InitUtil.registerSpringInitialized();
        if (PropsValues.CACHE_CLEAR_ON_CONTEXT_INITIALIZATION) {
            CacheRegistryUtil.clear();
            PortletContextBagPool.clear();
            WebAppPool.clear();
            TemplateResourceLoaderUtil.clearCache();
            ServletContextPool.clear();
            PortalCacheHelperUtil.clearPortalCaches((String)"MULTI_VM_PORTAL_CACHE_MANAGER");
            PortalCacheHelperUtil.clearPortalCaches((String)"SINGLE_VM_PORTAL_CACHE_MANAGER");
        }
        ServletContextPool.put((String)_portalServletContextName, (ServletContext)servletContext);
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocatorImpl);
        for (ClassLoader classLoader = portalClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.clearFilteredPropertyDescriptorsCache(autowireCapableBeanFactory);
        DynamicProxyCreator dynamicProxyCreator = DynamicProxyCreator.getDynamicProxyCreator();
        dynamicProxyCreator.clear();
        try {
            ModuleFrameworkUtilAdapter.registerContext(applicationContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CustomJspBagRegistryUtil.getCustomJspBags();
        this.initListeners(servletContext);
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void closeDataSource(String name) {
        DataSource dataSource = (DataSource)PortalBeanLocatorUtil.locate((String)name);
        if (dataSource instanceof Closeable) {
            try {
                Closeable closeable = (Closeable)((Object)dataSource);
                closeable.close();
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
    }

    protected void initListeners(ServletContext servletContext) {
        if (PropsValues.SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            servletContext.addListener(SerializableSessionAttributeListener.class);
        }
        servletContext.addListener(PortalSessionListener.class);
        servletContext.addListener(PortletSessionListenerManager.class);
    }

    static {
        _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
        _portalServletContextName = "";
        _portalServletContextPath = "/";
        try {
            _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, (String)"filteredPropertyDescriptorsCache");
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError((Throwable)e);
        }
    }
}

