/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PluginsGitSvnSyncer {
    private static final String[] _PLUGIN_DIR_NAMES = new String[]{"", "/docroot", "/docroot/WEB-INF", "/docroot/WEB-INF/lib", "/docroot/WEB-INF/tld"};
    private static final String[] _PLUGIN_TYPES = new String[]{"clients", "ext", "hooks", "layouttpl", "portlets", "themes", "webs"};
    private static final String _SVN_DEL_IGNORES = "svn propdel svn:ignore ";
    private static final String _SVN_GET_IGNORES = "svn propget svn:ignore ";
    private static final String _SVN_SET_IGNORES = "svn propset svn:ignore ";
    private static final FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        String gitPluginsDirName = System.getProperty("git.plugins.dir");
        String svnPluginsDirName = System.getProperty("svn.plugins.dir");
        String syncTo = System.getProperty("sync.to");
        new PluginsGitSvnSyncer(gitPluginsDirName, svnPluginsDirName, syncTo);
    }

    public PluginsGitSvnSyncer(String gitPluginsDirName, String svnPluginsDirName, String syncTo) {
        try {
            if (!gitPluginsDirName.endsWith("/")) {
                gitPluginsDirName = gitPluginsDirName + "/";
            }
            if (!svnPluginsDirName.endsWith("/")) {
                svnPluginsDirName = svnPluginsDirName + "/";
            }
            if (syncTo.equals("git")) {
                this._updateGitIgnores(svnPluginsDirName, gitPluginsDirName);
            } else if (syncTo.equals("svn")) {
                this._updateSvnIgnores(gitPluginsDirName, svnPluginsDirName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] _exec(String cmd) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd);
        String[] stderr = this._getExecOutput(process.getErrorStream());
        if (stderr.length > 0) {
            StringBundler sb = new StringBundler(stderr.length * 3 + 3);
            sb.append("Received errors in executing '");
            sb.append(cmd);
            sb.append("'\n");
            for (String err : stderr) {
                sb.append("\t");
                sb.append(err);
                sb.append("\n");
            }
            throw new Exception(sb.toString());
        }
        return this._getExecOutput(process.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _getExecOutput(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = null;
        try {
            unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(is));
            String line = unsyncBufferedReader.readLine();
            while (line != null) {
                if (Validator.isNotNull((String)(line = line.trim()))) {
                    list.add(line);
                }
                line = unsyncBufferedReader.readLine();
            }
        }
        finally {
            if (unsyncBufferedReader != null) {
                try {
                    unsyncBufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void _updateGitIgnores(String srcDirName, String destDirName) throws Exception {
        for (String pluginType : _PLUGIN_TYPES) {
            String[] dirNames;
            for (String dirName : dirNames = _fileUtil.listDirs(srcDirName + pluginType)) {
                if (dirName.equals(".svn")) continue;
                for (String pluginDirName : _PLUGIN_DIR_NAMES) {
                    this._updateGitIgnores(srcDirName + pluginType + "/", destDirName + pluginType + "/", dirName + pluginDirName + "/");
                }
            }
        }
    }

    private void _updateGitIgnores(String srcDirName, String destDirName, String dirName) throws Exception {
        File gitIgnoreFile = new File(destDirName + dirName + ".gitignore");
        if (!_fileUtil.exists(srcDirName + dirName + ".svn")) {
            _fileUtil.delete(gitIgnoreFile);
            return;
        }
        List ignores = null;
        ignores = !dirName.contains("/docroot/") ? Collections.emptyList() : ListUtil.fromArray((Object[])this._exec(_SVN_GET_IGNORES + srcDirName + dirName));
        Collections.sort(ignores);
        Iterator itr = ignores.iterator();
        while (itr.hasNext()) {
            String ignore = (String)itr.next();
            if (!ignore.equals("classes")) continue;
            itr.remove();
        }
        if (!ignores.isEmpty()) {
            Object[] ignoresArray = ignores.toArray(new String[ignores.size()]);
            for (int i = 0; i < ignoresArray.length; ++i) {
                String ignore = ignoresArray[i];
                if (!Validator.isNotNull((String)ignore) || ignore.startsWith("/")) continue;
                ignoresArray[i] = "/" + ignore;
            }
            _fileUtil.write(destDirName + dirName + ".gitignore", StringUtil.merge((Object[])ignoresArray, (String)"\n"));
        } else {
            _fileUtil.delete(gitIgnoreFile);
        }
    }

    private void _updateSvnIgnores(String srcDirName, String destDirName) throws Exception {
        for (String pluginType : _PLUGIN_TYPES) {
            String[] dirNames;
            for (String dirName : dirNames = _fileUtil.listDirs(srcDirName + pluginType)) {
                for (String pluginDirName : _PLUGIN_DIR_NAMES) {
                    this._updateSvnIgnores(srcDirName + pluginType + "/", destDirName + pluginType + "/", dirName + pluginDirName + "/");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateSvnIgnores(String srcDirName, String destDirName, String dirName) throws Exception {
        if (!_fileUtil.exists(destDirName + dirName)) {
            return;
        }
        File gitIgnoreFile = new File(srcDirName + dirName + ".gitignore");
        File svnDir = new File(destDirName + dirName + ".svn");
        if (gitIgnoreFile.exists() && !svnDir.exists()) {
            System.out.println("Invalid SVN directory " + destDirName + dirName);
            return;
        }
        ArrayList<String> ignores = null;
        if (!dirName.contains("/docroot")) {
            ignores = new ArrayList<String>();
            ignores.add("bin");
            ignores.add("classes");
            ignores.add("tmp");
        } else {
            ignores = ListUtil.fromFile((File)gitIgnoreFile);
            for (int i = 0; i < ignores.size(); ++i) {
                String ignore = (String)ignores.get(i);
                if (ignore.startsWith("/")) {
                    ignore = ignore.substring(1);
                }
                ignores.set(i, ignore);
            }
            if (dirName.endsWith("/docroot/WEB-INF/") && !ignores.contains("classes")) {
                ignores.add("classes");
            }
        }
        Collections.sort(ignores);
        if (ignores.isEmpty() && !svnDir.exists()) {
            return;
        }
        if (ignores.isEmpty()) {
            block14: {
                try {
                    this._exec(_SVN_DEL_IGNORES + destDirName + dirName);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message.contains("svn: Attempting to delete nonexistent property 'svn:ignore'")) break block14;
                    throw e;
                }
            }
            return;
        }
        File tempFile = _fileUtil.createTempFile("svn-ignores-", "tmp");
        try {
            Object[] ignoresArray = ignores.toArray(new String[ignores.size()]);
            _fileUtil.write(tempFile, StringUtil.merge((Object[])ignoresArray, (String)"\n"));
            this._exec(StringBundler.concat((String[])new String[]{_SVN_SET_IGNORES, "-F \"", tempFile.getCanonicalPath(), "\" \"", destDirName, dirName, "\""}));
        }
        finally {
            _fileUtil.delete(tempFile);
        }
    }
}

