/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.v6_2_0.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.v6_2_0.util.BlogsEntryTable;
import com.liferay.portal.upgrade.v6_2_0.util.RSSUtil;
import javax.portlet.PortletPreferences;

public class UpgradeBlogs
extends BaseUpgradePortletPreferences {
    protected void doUpgrade() throws Exception {
        super.doUpgrade();
        this.updateEntries();
        this.updateStatus();
    }

    protected String[] getPortletIds() {
        return new String[]{"33"};
    }

    protected void updateEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.alter(BlogsEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "description", "STRING null")});
        }
    }

    protected void updateStatus() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update BlogsEntry set status = 0 where status is null");
        }
    }

    protected void upgradeDisplayStyle(PortletPreferences portletPreferences) throws Exception {
        String pageDisplayStyle = GetterUtil.getString((String)portletPreferences.getValue("pageDisplayStyle", null));
        if (Validator.isNotNull((String)pageDisplayStyle)) {
            portletPreferences.setValue("displayStyle", pageDisplayStyle);
        }
        portletPreferences.reset("pageDisplayStyle");
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        this.upgradeDisplayStyle(portletPreferences);
        this.upgradeRss(portletPreferences);
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected void upgradeRss(PortletPreferences portletPreferences) throws Exception {
        String rssFormat = GetterUtil.getString((String)portletPreferences.getValue("rssFormat", null));
        if (Validator.isNotNull((String)rssFormat)) {
            String rssFormatType = RSSUtil.getFormatType(rssFormat);
            double rssFormatVersion = RSSUtil.getFormatVersion(rssFormat);
            String rssFeedType = RSSUtil.getFeedType(rssFormatType, rssFormatVersion);
            portletPreferences.setValue("rssFeedType", rssFeedType);
        }
        portletPreferences.reset("rssFormat");
    }
}

