/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Objects;

public class UpgradePortalPreferences
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortalPreferences.class);

    protected String convertStagingPreferencesToJSON(String preferences) throws Exception {
        Document newDocument = SAXReaderUtil.createDocument();
        Element newRootElement = SAXReaderUtil.createElement((String)"portlet-preferences");
        newDocument.add(newRootElement);
        Document document = SAXReaderUtil.read((String)preferences);
        Element rootElement = document.getRootElement();
        Iterator iterator = rootElement.elementIterator();
        while (iterator.hasNext()) {
            Element preferenceElement = (Element)iterator.next();
            String preferenceName = preferenceElement.elementText("name");
            if (preferenceName.contains("com.liferay.portal.kernel.staging.Staging")) continue;
            newRootElement.add(preferenceElement.createCopy());
        }
        return XMLUtil.formatXML((Document)newDocument);
    }

    protected void doUpgrade() throws Exception {
        this.upgradeStagingPortalPreferences();
    }

    protected void upgradeStagingPortalPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select portalPreferencesId, preferences from PortalPreferences");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortalPreferences set preferences = ? where portalPreferencesId = ?");){
            while (rs.next()) {
                long portalPreferencesId = rs.getLong("portalPreferencesId");
                String oldPreferences = rs.getString("preferences");
                String newPreferences = null;
                try {
                    newPreferences = this.convertStagingPreferencesToJSON(oldPreferences);
                }
                catch (DocumentException de) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Portal preferences ", portalPreferencesId, " contains invalid XML, resetting to default"}));
                    }
                    newPreferences = "<portlet-preferences />";
                }
                if (Objects.equals(oldPreferences, newPreferences)) continue;
                ps2.setString(1, newPreferences);
                ps2.setLong(2, portalPreferencesId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

