/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.persistence.DLFileVersionPersistence;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLFileVersionPolicy;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Deprecated
public class DLFileVersionPolicyImpl
implements DLFileVersionPolicy {
    @BeanReference(type=DLFileEntryMetadataLocalService.class)
    protected DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService;
    @BeanReference(type=DLFileVersionPersistence.class)
    protected DLFileVersionPersistence dlFileVersionPersistence;
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionPolicyImpl.class);
    private final ServiceTrackerList<DLFileVersionPolicy> _serviceTrackerList = ServiceTrackerCollections.openList(DLFileVersionPolicy.class);

    public void destroy() {
        this._serviceTrackerList.close();
    }

    public boolean isKeepFileVersionLabel(DLFileVersion lastDLFileVersion, DLFileVersion latestDLFileVersion, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        for (DLFileVersionPolicy dlFileVersionPolicy : this._serviceTrackerList) {
            if (dlFileVersionPolicy == this || dlFileVersionPolicy.isKeepFileVersionLabel(lastDLFileVersion, latestDLFileVersion, majorVersion, serviceContext)) continue;
            return false;
        }
        return this.isKeepFileVersionLabel(lastDLFileVersion.getFileEntry(), lastDLFileVersion, latestDLFileVersion, majorVersion, serviceContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isKeepFileVersionLabel(DLFileEntry dlFileEntry, DLFileVersion lastDLFileVersion, DLFileVersion latestDLFileVersion, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        Map latestAttributes;
        if (PropsValues.DL_FILE_ENTRY_VERSION_POLICY != 1) {
            return false;
        }
        if (majorVersion) {
            return false;
        }
        if (Objects.equals(serviceContext.getCommand(), "revert")) {
            return false;
        }
        if (!Objects.equals(lastDLFileVersion.getTitle(), latestDLFileVersion.getTitle())) {
            return false;
        }
        if (!Objects.equals(lastDLFileVersion.getDescription(), latestDLFileVersion.getDescription())) {
            return false;
        }
        if (lastDLFileVersion.getFileEntryTypeId() != latestDLFileVersion.getFileEntryTypeId()) {
            return false;
        }
        if (serviceContext.getWorkflowAction() == 2) {
            return false;
        }
        DLFileEntryType dlFileEntryType = lastDLFileVersion.getDLFileEntryType();
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            DDMFormValues latestDDMFormValues;
            DLFileEntryMetadata lastFileEntryMetadata = this.dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), lastDLFileVersion.getFileVersionId());
            if (lastFileEntryMetadata == null) {
                return false;
            }
            DLFileEntryMetadata latestFileEntryMetadata = this.dlFileEntryMetadataLocalService.getFileEntryMetadata(ddmStructure.getStructureId(), latestDLFileVersion.getFileVersionId());
            DDMFormValues lastDDMFormValues = StorageEngineManagerUtil.getDDMFormValues((long)lastFileEntryMetadata.getDDMStorageId());
            if (lastDDMFormValues.equals((Object)(latestDDMFormValues = StorageEngineManagerUtil.getDDMFormValues((long)latestFileEntryMetadata.getDDMStorageId())))) continue;
            return false;
        }
        ExpandoBridge lastExpandoBridge = lastDLFileVersion.getExpandoBridge();
        ExpandoBridge latestExpandoBridge = latestDLFileVersion.getExpandoBridge();
        Map lastAttributes = lastExpandoBridge.getAttributes();
        if (!lastAttributes.equals(latestAttributes = latestExpandoBridge.getAttributes())) {
            return false;
        }
        long lastSize = lastDLFileVersion.getSize();
        long latestSize = latestDLFileVersion.getSize();
        if (lastSize == 0L && latestSize >= 0L) {
            return true;
        }
        if (lastSize != latestSize) {
            return false;
        }
        try {
            Throwable throwable;
            String lastChecksum = lastDLFileVersion.getChecksum();
            if (Validator.isNull((String)lastChecksum)) {
                throwable = null;
                try (InputStream lastInputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)lastDLFileVersion.getVersion());){
                    lastChecksum = DigesterUtil.digestBase64((InputStream)lastInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                lastDLFileVersion.setChecksum(lastChecksum);
                this.dlFileVersionPersistence.update((BaseModel)lastDLFileVersion);
            }
            throwable = null;
            try (InputStream latestInputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)latestDLFileVersion.getVersion());){
                String latestChecksum = DigesterUtil.digestBase64((InputStream)latestInputStream);
                if (lastChecksum.equals(latestChecksum)) {
                    boolean bl = true;
                    return bl;
                }
                latestDLFileVersion.setChecksum(latestChecksum);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            this.dlFileVersionPersistence.update((BaseModel)latestDLFileVersion);
            return false;
        }
        catch (Exception e) {
            if (!_log.isWarnEnabled()) return false;
            _log.warn((Object)e, (Throwable)e);
        }
        return false;
    }
}

