/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.ccpp.PortalProfileFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.servlet.SharedSessionServletRequest;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.UserInfoFactory;
import com.liferay.portlet.internal.PortalContextImpl;
import com.liferay.portlet.internal.PortletSessionImpl;
import com.liferay.portlet.internal.RenderParametersImpl;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterConfiguration;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ccpp.Profile;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class PortletRequestImpl
implements LiferayPortletRequest {
    private static final Log _log = LogFactoryUtil.getLog(PortletRequestImpl.class);
    private boolean _invalidSession;
    private Locale _locale;
    private HttpServletRequest _originalRequest;
    private long _plid;
    private PortalContext _portalContext;
    private Portlet _portlet;
    private PortletContext _portletContext;
    private PortletMode _portletMode;
    private String _portletName;
    private HttpServletRequest _portletRequestDispatcherRequest;
    private int _portletSpecMajorVersion;
    private PortletPreferences _preferences;
    private Profile _profile;
    private String _remoteUser;
    private long _remoteUserId;
    private RenderParameters _renderParameters;
    private HttpServletRequest _request;
    private PortletSessionImpl _session;
    private boolean _triggeredByActionURL;
    private Principal _userPrincipal;
    private WindowState _windowState;

    public void cleanUp() {
        this._request.removeAttribute("javax.portlet.config");
        this._request.removeAttribute("javax.portlet.request");
        this._request.removeAttribute("javax.portlet.response");
        this._request.removeAttribute("javax.portlet.lifecycle_phase");
        this._request.removeAttribute("PORTLET_ID");
        this._request.removeAttribute("PORTLET_CONTENT");
    }

    public Map<String, String[]> clearRenderParameters() {
        return RenderParametersPool.clear(this._request, this._plid, this._portletName);
    }

    public void defineObjects(PortletConfig portletConfig, PortletResponse portletResponse) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this.setAttribute("PORTLET_ID", liferayPortletConfig.getPortletId());
        this.setAttribute("javax.portlet.config", portletConfig);
        this.setAttribute("javax.portlet.request", this);
        this.setAttribute("javax.portlet.response", portletResponse);
        this.setAttribute("javax.portlet.lifecycle_phase", this.getLifecycle());
    }

    public Object getAttribute(String name) {
        LinkedHashMap<String, String> value;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.equals("javax.portlet.ccpp")) {
            return this.getCCPPProfile();
        }
        if (name.equals("javax.portlet.userinfo") && (value = this.getUserInfo()) != null) {
            return value;
        }
        return this._request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        Enumeration enu = this._request.getAttributeNames();
        this._copyAttributeNames(names, enu);
        if (this._portletRequestDispatcherRequest != null) {
            enu = this._portletRequestDispatcherRequest.getAttributeNames();
            this._copyAttributeNames(names, enu);
        }
        return Collections.enumeration(names);
    }

    public String getAuthType() {
        return this._request.getAuthType();
    }

    public Profile getCCPPProfile() {
        if (this._profile == null) {
            this._profile = PortalProfileFactory.getCCPPProfile(this._request);
        }
        return this._profile;
    }

    public String getContextPath() {
        return this._portlet.getContextPath();
    }

    public Cookie[] getCookies() {
        return this._request.getCookies();
    }

    public String getETag() {
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public abstract String getLifecycle();

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale == null) {
            locale = this._request.getLocale();
        }
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }

    public Enumeration<Locale> getLocales() {
        return this._request.getLocales();
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public HttpServletRequest getOriginalHttpServletRequest() {
        return this._originalRequest;
    }

    @Deprecated
    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._portletRequestDispatcherRequest != null) {
            return this._portletRequestDispatcherRequest.getParameter(name);
        }
        return this._request.getParameter(name);
    }

    @Deprecated
    public Map<String, String[]> getParameterMap() {
        if (this._portletRequestDispatcherRequest != null) {
            return Collections.unmodifiableMap(this._portletRequestDispatcherRequest.getParameterMap());
        }
        return Collections.unmodifiableMap(this._request.getParameterMap());
    }

    @Deprecated
    public Enumeration<String> getParameterNames() {
        if (this._portletRequestDispatcherRequest != null) {
            return this._portletRequestDispatcherRequest.getParameterNames();
        }
        return this._request.getParameterNames();
    }

    @Deprecated
    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._portletRequestDispatcherRequest != null) {
            return this._portletRequestDispatcherRequest.getParameterValues(name);
        }
        return this._request.getParameterValues(name);
    }

    public long getPlid() {
        return this._plid;
    }

    public PortalContext getPortalContext() {
        return this._portalContext;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public HttpServletRequest getPortletRequestDispatcherRequest() {
        return this._portletRequestDispatcherRequest;
    }

    public PortletSession getPortletSession() {
        return this._session;
    }

    public PortletSession getPortletSession(boolean create) {
        if (!create && !this.isRequestedSessionIdValid()) {
            return null;
        }
        return this._session;
    }

    public PortletPreferences getPreferences() {
        String lifecycle = this.getLifecycle();
        if ((lifecycle.equals("HEADER_PHASE") || lifecycle.equals("RENDER_PHASE")) && PropsValues.PORTLET_PREFERENCES_STRICT_STORE) {
            return new PortletPreferencesWrapper(this.getPreferencesImpl());
        }
        return this.getPreferencesImpl();
    }

    public PortletPreferencesImpl getPreferencesImpl() {
        return (PortletPreferencesImpl)this._preferences;
    }

    @Deprecated
    public Map<String, String[]> getPrivateParameterMap() {
        Map parameterMap = null;
        parameterMap = this._portletRequestDispatcherRequest != null ? this._portletRequestDispatcherRequest.getParameterMap() : this._request.getParameterMap();
        HashMap privateParameterMap = null;
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            if (this._portlet.getPublicRenderParameter(name) != null) continue;
            if (privateParameterMap == null) {
                privateParameterMap = new HashMap(parameterMap.size(), 1.0f);
            }
            privateParameterMap.put(name, entry.getValue());
        }
        if (privateParameterMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(privateParameterMap);
    }

    public Enumeration<String> getProperties(String name) {
        String value;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> values = new ArrayList<String>();
        Enumeration enumeration = this._request.getHeaders(name);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String header = (String)enumeration.nextElement();
                if (header == null) continue;
                values.add(header);
            }
        }
        if ((value = this._portalContext.getProperty(name)) != null) {
            values.add(value);
        }
        return Collections.enumeration(values);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String value = this._request.getHeader(name);
        if (value == null) {
            value = this._portalContext.getProperty(name);
        }
        return value;
    }

    public Enumeration<String> getPropertyNames() {
        ArrayList names = new ArrayList();
        Enumeration headerNamesEnumeration = this._request.getHeaderNames();
        if (headerNamesEnumeration != null) {
            while (headerNamesEnumeration.hasMoreElements()) {
                names.add(headerNamesEnumeration.nextElement());
            }
        }
        Enumeration propertyNamesEnumeration = this._portalContext.getPropertyNames();
        while (propertyNamesEnumeration.hasMoreElements()) {
            names.add(propertyNamesEnumeration.nextElement());
        }
        return Collections.enumeration(names);
    }

    @Deprecated
    public Map<String, String[]> getPublicParameterMap() {
        Map parameterMap = null;
        parameterMap = this._portletRequestDispatcherRequest != null ? this._portletRequestDispatcherRequest.getParameterMap() : this._request.getParameterMap();
        HashMap publicParameterMap = null;
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            if (this._portlet.getPublicRenderParameter(name) == null) continue;
            if (publicParameterMap == null) {
                publicParameterMap = new HashMap(parameterMap.size(), 1.0f);
            }
            publicParameterMap.put(name, entry.getValue());
        }
        if (publicParameterMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(publicParameterMap);
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public RenderParameters getRenderParameters() {
        if (this._portletSpecMajorVersion < 3) {
            throw new UnsupportedOperationException("Requires 3.0 opt-in");
        }
        return this._renderParameters;
    }

    public String getRequestedSessionId() {
        if (this._session != null) {
            return this._session.getId();
        }
        HttpSession session = this._request.getSession(false);
        if (session == null) {
            return "";
        }
        return session.getId();
    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Enumeration<String> getResponseContentTypes() {
        ArrayList<String> responseContentTypes = new ArrayList<String>();
        responseContentTypes.add(this.getResponseContentType());
        return Collections.enumeration(responseContentTypes);
    }

    public String getScheme() {
        return this._request.getScheme();
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public String getUserAgent() {
        return this._request.getHeader("User-Agent");
    }

    public LinkedHashMap<String, String> getUserInfo() {
        return UserInfoFactory.getUserInfo(this._remoteUserId, this._portlet);
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public String getWindowID() {
        return this._portletName.concat("_LAYOUT_").concat(String.valueOf(this._plid));
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public void init(HttpServletRequest request, Portlet portlet, InvokerPortlet invokerPortlet, PortletContext portletContext, WindowState windowState, PortletMode portletMode, PortletPreferences preferences, long plid) {
        Map<String, String[]> privateRenderParameters;
        String dynamicQueryString;
        String portletResource;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._portlet = portlet;
        this._portletName = portlet.getPortletId();
        PortletApp portletApp = portlet.getPortletApp();
        this._portletSpecMajorVersion = portletApp.getSpecMajorVersion();
        Map<String, String[]> publicRenderParametersMap = PublicRenderParametersPool.get(request, plid);
        String portletNamespace = PortalUtil.getPortletNamespace((String)this._portletName);
        boolean warFile = portletApp.isWARFile();
        if (!warFile && Validator.isNotNull((String)(portletResource = ParamUtil.getString((HttpServletRequest)request, (String)portletNamespace.concat("portletResource"))))) {
            PortletApp resourcePortletApp;
            Portlet resourcePortlet = null;
            try {
                resourcePortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resourcePortlet != null && (resourcePortletApp = resourcePortlet.getPortletApp()).isWARFile()) {
                warFile = true;
            }
        }
        if (warFile) {
            request = new SharedSessionServletRequest((HttpServletRequest)request, !portlet.isPrivateSessionAttributes());
        }
        if ((dynamicQueryString = (String)request.getAttribute("DYNAMIC_QUERY_STRING")) != null) {
            request.removeAttribute("DYNAMIC_QUERY_STRING");
            request = DynamicServletRequest.addQueryString((HttpServletRequest)request, (String)dynamicQueryString, (boolean)true);
        }
        DynamicServletRequest dynamicRequest = null;
        dynamicRequest = portlet.isPrivateRequestAttributes() ? new NamespaceServletRequest((HttpServletRequest)request, portletNamespace, portletNamespace, false) : new DynamicServletRequest(request, false);
        boolean portletFocus = false;
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        boolean windowStateRestoreCurrentView = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_state_rcv");
        if (!(!this._portletName.equals(ppid) || windowStateRestoreCurrentView && portlet.isRestoreCurrentView())) {
            if (themeDisplay.isLifecycleRender() || themeDisplay.isLifecycleResource()) {
                portletFocus = true;
            } else if (themeDisplay.isLifecycleAction()) {
                this._triggeredByActionURL = true;
                if (Objects.equals(this.getLifecycle(), "ACTION_PHASE")) {
                    portletFocus = true;
                }
            }
        }
        boolean facesPortlet = false;
        if (invokerPortlet != null && invokerPortlet.isFacesPortlet()) {
            facesPortlet = true;
        }
        LinkedHashSet<String> privateRenderParameterNames = new LinkedHashSet<String>();
        if (portletFocus) {
            privateRenderParameters = null;
            Map parameters = request.getParameterMap();
            for (Map.Entry entry : parameters.entrySet()) {
                RequestParameter requestParameter = new RequestParameter((String)entry.getKey(), (String[])entry.getValue(), portletNamespace, this._portletSpecMajorVersion);
                if (requestParameter.isNameInvalid()) continue;
                if (Objects.equals(this.getLifecycle(), "HEADER_PHASE") || Objects.equals(this.getLifecycle(), "RENDER_PHASE")) {
                    if (privateRenderParameters == null) {
                        privateRenderParameters = new HashMap<String, String[]>();
                    }
                    privateRenderParameters.put(requestParameter.getName(facesPortlet), requestParameter.getValues());
                    privateRenderParameterNames.add(requestParameter.getName());
                } else if (requestParameter.isPrivateRenderNamespaced()) {
                    privateRenderParameterNames.add(requestParameter.getName());
                }
                if (requestParameter.getValues() == null || !requestParameter.isPortletNamespaced() && portlet.isRequiresNamespacedParameters()) continue;
                dynamicRequest.setParameterValues(requestParameter.getName(facesPortlet), requestParameter.getValues());
            }
            if ((this.getLifecycle().equals("HEADER_PHASE") || this.getLifecycle().equals("RENDER_PHASE")) && !LiferayWindowState.isExclusive((HttpServletRequest)request) && !LiferayWindowState.isPopUp((HttpServletRequest)request)) {
                if (privateRenderParameters == null || privateRenderParameters.isEmpty()) {
                    RenderParametersPool.clear(request, plid, this._portletName);
                } else {
                    RenderParametersPool.put(request, plid, this._portletName, privateRenderParameters);
                }
            }
        } else {
            privateRenderParameters = RenderParametersPool.get(request, plid, this._portletName);
            if (privateRenderParameters != null) {
                for (Map.Entry entry : privateRenderParameters.entrySet()) {
                    Parameter privateRenderParameter = new Parameter((String)entry.getKey(), (String[])entry.getValue(), portletNamespace);
                    String publicRenderParameterName = "p_r_p_".concat(privateRenderParameter.getName());
                    if (publicRenderParametersMap.containsKey(publicRenderParameterName)) {
                        if (this._portletSpecMajorVersion >= 3) {
                            publicRenderParametersMap.put(publicRenderParameterName, privateRenderParameter.getValues());
                        }
                    } else {
                        dynamicRequest.setParameterValues(privateRenderParameter.getName(facesPortlet), privateRenderParameter.getValues());
                    }
                    privateRenderParameterNames.add(privateRenderParameter.getName());
                }
            }
        }
        this._mergePublicRenderParameters(dynamicRequest, publicRenderParametersMap, preferences, this.getLifecycle());
        this._processCheckbox(dynamicRequest);
        this._request = dynamicRequest;
        this._originalRequest = request;
        this._portlet = portlet;
        this._portalContext = new PortalContextImpl();
        this._portletContext = portletContext;
        this._windowState = windowState;
        this._portletMode = portletMode;
        this._preferences = preferences;
        this._session = new PortletSessionImpl(this._request.getSession(), this._portletContext, this._portletName, plid);
        String remoteUser = request.getRemoteUser();
        String userPrincipalStrategy = portlet.getUserPrincipalStrategy();
        if (userPrincipalStrategy.equals("screenName")) {
            try {
                User user = PortalUtil.getUser((HttpServletRequest)request);
                if (user != null) {
                    this._remoteUser = user.getScreenName();
                    this._remoteUserId = user.getUserId();
                    this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to get user", (Throwable)exception);
            }
        } else {
            long l = PortalUtil.getUserId((HttpServletRequest)request);
            if (l > 0L && remoteUser == null) {
                this._remoteUser = String.valueOf(l);
                this._remoteUserId = l;
                this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
            } else {
                this._remoteUser = remoteUser;
                this._remoteUserId = GetterUtil.getLong((String)remoteUser);
                this._userPrincipal = request.getUserPrincipal();
            }
        }
        this._locale = themeDisplay.getLocale();
        this._plid = plid;
        if (this._portletSpecMajorVersion < 3) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set publicRenderParameters = portlet.getPublicRenderParameters();
        for (Object publicRenderParameter : publicRenderParameters) {
            hashSet.add(publicRenderParameter.getIdentifier());
        }
        LinkedHashMap<String, String[]> allRenderParameters = new LinkedHashMap<String, String[]>();
        if (Objects.equals(this.getLifecycle(), "RESOURCE_PHASE")) {
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                String[] stringArray = publicRenderParametersMap.get(PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName()));
                if (stringArray == null) continue;
                allRenderParameters.put(publicRenderParameter.getIdentifier(), stringArray);
            }
            Map<String, String[]> privateRenderParameters2 = RenderParametersPool.get(request, plid, this._portletName);
            if (privateRenderParameters2 != null) {
                for (Map.Entry entry : privateRenderParameters2.entrySet()) {
                    String privateRenderParameterName = (String)entry.getKey();
                    if (allRenderParameters.containsKey(privateRenderParameterName)) continue;
                    Object[] values = (String[])entry.getValue();
                    if (themeDisplay.isHubAction() || themeDisplay.isHubPartialAction() || themeDisplay.isHubResource()) {
                        values = dynamicRequest.getParameterValues(privateRenderParameterName);
                    } else {
                        Object[] requestValues = dynamicRequest.getParameterValues(privateRenderParameterName);
                        if (requestValues != null && !Arrays.equals(requestValues, values)) {
                            dynamicRequest.setParameterValues(privateRenderParameterName, (String[])ArrayUtil.append((Object[])requestValues, (Object[])values));
                        }
                    }
                    allRenderParameters.put(privateRenderParameterName, (String[])values);
                }
            }
            for (String string : privateRenderParameterNames) {
                if (allRenderParameters.containsKey(string)) continue;
                allRenderParameters.put(string, dynamicRequest.getParameterValues(string));
            }
        } else {
            Map parameterMap = dynamicRequest.getParameterMap();
            for (Map.Entry entry : parameterMap.entrySet()) {
                RequestParameter requestParameter = new RequestParameter((String)entry.getKey(), (String[])entry.getValue(), portletNamespace, this._portletSpecMajorVersion);
                if (hashSet.contains(requestParameter.getName())) {
                    if (this._portletSpecMajorVersion >= 3) {
                        String publicRenderParameterName = "p_r_p_";
                        String[] previousValues = publicRenderParametersMap.get(publicRenderParameterName = publicRenderParameterName.concat(requestParameter.getName()));
                        if (previousValues != null) {
                            requestParameter.setValues(previousValues);
                        }
                    }
                } else if (!privateRenderParameterNames.contains(requestParameter.getName())) {
                    requestParameter.setValues(null);
                }
                if (requestParameter.getValues() == null) continue;
                allRenderParameters.put(requestParameter.getName(), requestParameter.getValues());
            }
        }
        this._renderParameters = new RenderParametersImpl(allRenderParameters, hashSet, portletNamespace);
    }

    public void invalidateSession() {
        this._invalidSession = true;
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            return true;
        }
        return this._portlet.hasPortletMode(this.getResponseContentType(), portletMode);
    }

    public boolean isRequestedSessionIdValid() {
        if (this._session.isInvalidated() || this._invalidSession) {
            return false;
        }
        return this._request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public boolean isTriggeredByActionURL() {
        return this._triggeredByActionURL;
    }

    public boolean isUserInRole(String role) {
        if (this._remoteUserId <= 0L) {
            return false;
        }
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)this._request);
            Map roleMappersMap = this._portlet.getRoleMappers();
            String roleLink = (String)roleMappersMap.get(role);
            if (Validator.isNotNull((String)roleLink)) {
                return RoleLocalServiceUtil.hasUserRole((long)this._remoteUserId, (long)companyId, (String)roleLink, (boolean)true);
            }
            return RoleLocalServiceUtil.hasUserRole((long)this._remoteUserId, (long)companyId, (String)role, (boolean)true);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to check if a user is in role " + role), (Throwable)e);
            return this._request.isUserInRole(role);
        }
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return PortalContextImpl.isSupportedWindowState(windowState);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._request.removeAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (obj == null) {
            this._request.removeAttribute(name);
        } else {
            this._request.setAttribute(name, obj);
        }
    }

    public void setPortletMode(PortletMode portletMode) {
        this._portletMode = portletMode;
    }

    public void setPortletRequestDispatcherRequest(HttpServletRequest request) {
        this._portletRequestDispatcherRequest = request;
    }

    public void setWindowState(WindowState windowState) {
        this._windowState = windowState;
    }

    protected int getPortletSpecMajorVersion() {
        return this._portletSpecMajorVersion;
    }

    private void _copyAttributeNames(Set<String> names, Enumeration<String> enumeration) {
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            if (name.equals("javax.servlet.include.path_info")) continue;
            names.add(name);
        }
    }

    private void _mergePublicRenderParameters(DynamicServletRequest dynamicRequest, Map<String, String[]> publicRenderParametersMap, PortletPreferences preferences, String lifecycle) {
        Set publicRenderParameters = this._portlet.getPublicRenderParameters();
        if (publicRenderParameters.isEmpty()) {
            return;
        }
        Enumeration enumeration = preferences.getNames();
        if (!enumeration.hasMoreElements()) {
            if (publicRenderParametersMap.isEmpty()) {
                return;
            }
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                Object[] values = publicRenderParametersMap.get(PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName()));
                if (ArrayUtil.isEmpty((Object[])values) || Validator.isNull((String)values[0])) continue;
                String name = publicRenderParameter.getIdentifier();
                Object[] requestValues = dynamicRequest.getParameterValues(name);
                if (requestValues != null && (lifecycle.equals("ACTION_PHASE") || lifecycle.equals("RESOURCE_PHASE"))) {
                    dynamicRequest.setParameterValues(name, (String[])ArrayUtil.append((Object[])requestValues, (Object[])values));
                    continue;
                }
                dynamicRequest.setParameterValues(name, (String[])values);
            }
            return;
        }
        for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
            String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName());
            String ignoreKey = PublicRenderParameterConfiguration.getIgnoreKey(publicRenderParameterName);
            boolean ignoreValue = GetterUtil.getBoolean((String)preferences.getValue(ignoreKey, null));
            if (ignoreValue) continue;
            String mappingKey = PublicRenderParameterConfiguration.getMappingKey(publicRenderParameterName);
            String mappingValue = GetterUtil.getString((String)preferences.getValue(mappingKey, null));
            HttpServletRequest request = (HttpServletRequest)dynamicRequest.getRequest();
            Object[] newValues = request.getParameterValues(mappingValue);
            if (newValues != null && newValues.length != 0) {
                newValues = ArrayUtil.remove((String[])newValues, (String)"null");
            }
            String name = publicRenderParameter.getIdentifier();
            if (ArrayUtil.isEmpty((Object[])newValues)) {
                Object[] values = publicRenderParametersMap.get(publicRenderParameterName);
                if (ArrayUtil.isEmpty((Object[])values) || Validator.isNull((String)values[0]) || dynamicRequest.getParameter(name) != null) continue;
                dynamicRequest.setParameterValues(name, (String[])values);
                continue;
            }
            dynamicRequest.setParameterValues(name, (String[])newValues);
        }
    }

    private void _processCheckbox(DynamicServletRequest dynamicServletRequest) {
        String checkboxNames = dynamicServletRequest.getParameter("checkboxNames");
        if (Validator.isNull((String)checkboxNames)) {
            return;
        }
        for (String checkboxName : StringUtil.split((String)checkboxNames)) {
            String value = dynamicServletRequest.getParameter(checkboxName);
            if (value == null) {
                dynamicServletRequest.setParameter(checkboxName, Boolean.FALSE.toString());
                continue;
            }
            if (!Objects.equals(value, "on")) continue;
            dynamicServletRequest.setParameter(checkboxName, Boolean.TRUE.toString());
        }
    }

    private static class RequestParameter
    extends Parameter {
        private final boolean _privateRenderNamespaced;
        private String[] _values;

        @Override
        public String[] getValues() {
            return this._values;
        }

        public boolean isNameInvalid() {
            String name = this.getName();
            return Validator.isNull((String)name) || name.startsWith("p_r_p_") || name.startsWith("r_p_r_p_") || PortalUtil.isReservedParameter((String)name);
        }

        public boolean isPrivateRenderNamespaced() {
            return this._privateRenderNamespaced;
        }

        public void setValues(String[] values) {
            this._values = values;
        }

        private static String _getName(String name) {
            if (name != null) {
                int pos = name.indexOf("priv_r_p_");
                int privateRenderParameterNamespaceLength = "priv_r_p_".length();
                if (pos >= 0) {
                    String privateRenderParameterName = name.substring(0, pos);
                    name = privateRenderParameterName = privateRenderParameterName.concat(name.substring(pos + privateRenderParameterNamespaceLength));
                }
            }
            return name;
        }

        private RequestParameter(String name, String[] values, String portletNamespace, int portletSpecMajorVersion) {
            super(RequestParameter._getName(name), values, portletNamespace);
            this._privateRenderNamespaced = name != null && name.contains("priv_r_p_");
            if (values != null && portletSpecMajorVersion >= 3) {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || !values[i].isEmpty()) continue;
                    values[i] = null;
                }
            }
            this._values = values;
        }
    }

    private static class Parameter {
        private final String _name;
        private final String _portletNamespacedName;
        private final String[] _values;

        public String getName() {
            return this._name;
        }

        public String getName(boolean includePortletNamespace) {
            if (includePortletNamespace && this.isPortletNamespaced()) {
                return this._portletNamespacedName;
            }
            return this._name;
        }

        public String[] getValues() {
            return this._values;
        }

        public boolean isPortletNamespaced() {
            return this._portletNamespacedName != null;
        }

        private Parameter(String name, String[] values, String portletNamespace) {
            String portletNamespacedName = null;
            if (name != null && name.startsWith(portletNamespace)) {
                portletNamespacedName = name;
                name = name.substring(portletNamespace.length());
            }
            this._name = name;
            this._portletNamespacedName = portletNamespacedName;
            this._values = values;
        }
    }
}

