/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.dao.orm.hibernate.ExceptionTranslator;
import com.liferay.portal.dao.orm.hibernate.LockModeTranslator;
import com.liferay.portal.dao.orm.hibernate.QueryImpl;
import com.liferay.portal.dao.orm.hibernate.SQLQueryImpl;
import com.liferay.portal.dao.orm.hibernate.SQLQueryTableNamesUtil;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.EventSource;

public class SessionImpl
implements Session {
    private final org.hibernate.Session _session;
    private final ClassLoader _sessionFactoryClassLoader;

    public SessionImpl(org.hibernate.Session session, ClassLoader sessionFactoryClassLoader) {
        this._session = session;
        this._sessionFactoryClassLoader = sessionFactoryClassLoader;
    }

    public void apply(UnsafeConsumer<Connection, SQLException> unsafeConsumer) throws ORMException {
        try {
            this._session.doWork(arg_0 -> unsafeConsumer.accept(arg_0));
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public void clear() throws ORMException {
        try {
            this._session.clear();
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Connection close() throws ORMException {
        try {
            return this._session.close();
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public boolean contains(Object object) throws ORMException {
        try {
            return this._session.contains(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Query createQuery(String queryString) throws ORMException {
        return this.createQuery(queryString, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String queryString, boolean strictName) throws ORMException {
        if (this._sessionFactoryClassLoader == null) {
            return this._createQuery(queryString, strictName);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._sessionFactoryClassLoader);
        try {
            Query query = this._createQuery(queryString, strictName);
            return query;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public SQLQuery createSQLQuery(String queryString) throws ORMException {
        return this.createSQLQuery(queryString, true);
    }

    public SQLQuery createSQLQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJPQLToHQL(queryString);
            return new SQLQueryImpl(this._session.createSQLQuery(queryString), strictName);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public SQLQuery createSynchronizedSQLQuery(DSLQuery dslQuery) throws ORMException {
        DefaultASTNodeListener defaultASTNodeListener = new DefaultASTNodeListener();
        SQLQuery sqlQuery = this.createSynchronizedSQLQuery(dslQuery.toSQL((ASTNodeListener)defaultASTNodeListener), true, defaultASTNodeListener.getTableNames());
        List scalarValues = defaultASTNodeListener.getScalarValues();
        if (!scalarValues.isEmpty()) {
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            for (Object value : scalarValues) {
                queryPos.add(value);
            }
        }
        return sqlQuery;
    }

    public SQLQuery createSynchronizedSQLQuery(String queryString) throws ORMException {
        return this.createSynchronizedSQLQuery(queryString, true);
    }

    public SQLQuery createSynchronizedSQLQuery(String queryString, boolean strictName) throws ORMException {
        return this.createSynchronizedSQLQuery(queryString, strictName, SQLQueryTableNamesUtil.getTableNames(queryString));
    }

    public SQLQuery createSynchronizedSQLQuery(String queryString, boolean strictName, String[] tableNames) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJPQLToHQL(queryString);
            SQLQueryImpl sqlQuery = new SQLQueryImpl(this._session.createSQLQuery(queryString), strictName);
            sqlQuery.addSynchronizedQuerySpaces(tableNames);
            return sqlQuery;
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public void delete(Object object) throws ORMException {
        try {
            this._session.delete(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public void evict(Class<?> clazz, Serializable id) throws ORMException {
        try {
            EventSource eventSource = (EventSource)this._session;
            PersistenceContext persistenceContext = eventSource.getPersistenceContext();
            SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
            Object object = persistenceContext.getEntity(new EntityKey(id, sessionFactoryImplementor.getEntityPersister(clazz.getName()), eventSource.getEntityMode()));
            if (object == null) {
                return;
            }
            eventSource.evict(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public void evict(Object object) throws ORMException {
        try {
            this._session.evict(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public void flush() throws ORMException {
        try {
            this._session.flush();
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Object get(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._session.get(clazz, id);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Object get(Class<?> clazz, Serializable id, LockMode lockMode) throws ORMException {
        LockOptions lockOptions = new LockOptions(LockModeTranslator.translate(lockMode));
        try {
            return this._session.get(clazz, id, lockOptions);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Object getWrappedSession() {
        return this._session;
    }

    public boolean isDirty() throws ORMException {
        try {
            return this._session.isDirty();
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Object load(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._session.load(clazz, id);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public Object merge(Object object) throws ORMException {
        try {
            return this._session.merge(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception, this._session, object);
        }
    }

    public Serializable save(Object object) throws ORMException {
        try {
            return this._session.save(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }

    public void saveOrUpdate(Object object) throws ORMException {
        try {
            this._session.saveOrUpdate(object);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception, this._session, object);
        }
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{_session=", this._session, "}"});
    }

    private Query _createQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJPQLToHQL(queryString);
            return new QueryImpl(this._session.createQuery(queryString), strictName);
        }
        catch (Exception exception) {
            throw ExceptionTranslator.translate(exception);
        }
    }
}

