/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.ResourceActionsException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.PatcherUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.util.List;

public class StartupHelperUtil {
    private static final String[] _UPGRADE_PROCESS_CLASS_NAMES = new String[]{"com.liferay.portal.upgrade.UpgradeProcess_7_0_0", "com.liferay.portal.upgrade.UpgradeProcess_7_0_1", "com.liferay.portal.upgrade.UpgradeProcess_7_0_3", "com.liferay.portal.upgrade.UpgradeProcess_7_0_5", "com.liferay.portal.upgrade.UpgradeProcess_7_0_6", "com.liferay.portal.upgrade.PortalUpgradeProcess"};
    private static final Log _log = LogFactoryUtil.getLog(StartupHelperUtil.class);
    private static boolean _dbNew;
    private static boolean _dropIndexes;
    private static boolean _startupFinished;
    private static boolean _upgraded;
    private static boolean _upgrading;

    public static void initResourceActions() {
        ResourceActionLocalServiceUtil.checkResourceActions();
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ResourceActionsUtil.populateModelResources((ClassLoader)StartupHelperUtil.class.getClassLoader(), (String[])PropsValues.RESOURCE_ACTIONS_CONFIGS);
        }
        catch (ResourceActionsException resourceActionsException) {
            ReflectionUtil.throwException((Throwable)resourceActionsException);
        }
    }

    public static boolean isDBNew() {
        return _dbNew;
    }

    public static boolean isStartupFinished() {
        return _startupFinished;
    }

    public static boolean isUpgrading() {
        return _upgrading;
    }

    public static void printPatchLevel() {
        if (_log.isInfoEnabled()) {
            String installedPatches = StringUtil.merge((Object[])PatcherUtil.getInstalledPatches(), (String)", ");
            if (Validator.isNull((String)installedPatches)) {
                _log.info((Object)"There are no patches installed");
            } else {
                _log.info((Object)("The following patches are installed: " + installedPatches));
            }
        }
    }

    public static void setDbNew(boolean dbNew) {
        _dbNew = dbNew;
    }

    public static void setDropIndexes(boolean dropIndexes) {
        _dropIndexes = dropIndexes;
    }

    public static void setStartupFinished(boolean startupFinished) {
        _startupFinished = startupFinished;
    }

    public static void setUpgrading(boolean upgrading) {
        _upgrading = upgrading;
    }

    public static void updateIndexes() {
        StartupHelperUtil.updateIndexes(_dropIndexes);
    }

    public static void updateIndexes(boolean dropIndexes) {
        block14: {
            DB db = DBManagerUtil.getDB();
            try (Connection connection = DataAccess.getConnection();){
                StartupHelperUtil.updateIndexes(db, connection, dropIndexes);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Throwable)exception);
            }
        }
    }

    public static void updateIndexes(DB db, Connection connection, boolean dropIndexes) {
        block2: {
            try {
                Thread currentThread = Thread.currentThread();
                ClassLoader classLoader = currentThread.getContextClassLoader();
                String tablesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
                String indexesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.sql");
                db.updateIndexes(connection, tablesSQL, indexesSQL, dropIndexes);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
    }

    public static void upgradeProcess(int buildNumber) throws UpgradeException {
        List upgradeProcesses = UpgradeProcessUtil.initUpgradeProcesses((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (String[])_UPGRADE_PROCESS_CLASS_NAMES);
        _upgraded = UpgradeProcessUtil.upgradeProcess((int)buildNumber, (List)upgradeProcesses);
    }

    public static void verifyRequiredSchemaVersion() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check the portal's required schema version");
        }
        if (!PortalUpgradeProcess.isInRequiredSchemaVersion(DataAccess.getConnection())) {
            Version requiredSchemaVersion;
            Version currentSchemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion(DataAccess.getConnection());
            String msg = currentSchemaVersion.compareTo(requiredSchemaVersion = PortalUpgradeProcess.getRequiredSchemaVersion()) < 0 ? "You must first upgrade the portal to the required schema version " + requiredSchemaVersion : "Current portal schema version " + currentSchemaVersion + " requires a newer version of Liferay";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
    }
}

