/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.jsonwebservice.SpringJSONWebServiceScannerStrategy;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMappingResolver;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceRegistrator;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceScannerStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class DefaultJSONWebServiceRegistrator
implements JSONWebServiceRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(DefaultJSONWebServiceRegistrator.class);
    private final JSONWebServiceMappingResolver _jsonWebServiceMappingResolver;
    private final JSONWebServiceNaming _jsonWebServiceNaming;
    private final JSONWebServiceScannerStrategy _jsonWebServiceScannerStrategy;
    private Map<Class<?>, Class<?>> _utilClasses;
    private boolean _wireViaUtil;

    public DefaultJSONWebServiceRegistrator() {
        this._jsonWebServiceNaming = JSONWebServiceActionsManagerUtil.getJSONWebServiceNaming();
        this._jsonWebServiceMappingResolver = new JSONWebServiceMappingResolver(this._jsonWebServiceNaming);
        this._jsonWebServiceScannerStrategy = new SpringJSONWebServiceScannerStrategy();
    }

    public DefaultJSONWebServiceRegistrator(JSONWebServiceNaming jsonWebServiceNaming, JSONWebServiceScannerStrategy jsonWebServiceScannerStrategy) {
        this._jsonWebServiceNaming = jsonWebServiceNaming;
        this._jsonWebServiceScannerStrategy = jsonWebServiceScannerStrategy;
        this._jsonWebServiceMappingResolver = new JSONWebServiceMappingResolver(this._jsonWebServiceNaming);
    }

    public DefaultJSONWebServiceRegistrator(JSONWebServiceScannerStrategy jsonWebServiceScannerStrategy) {
        this(JSONWebServiceActionsManagerUtil.getJSONWebServiceNaming(), jsonWebServiceScannerStrategy);
    }

    public void processAllBeans(String contextName, String contextPath, BeanLocator beanLocator) {
        String[] beanNames;
        if (beanLocator == null) {
            return;
        }
        for (String beanName : beanNames = beanLocator.getNames()) {
            this.processBean(contextName, contextPath, beanLocator, beanName);
        }
    }

    public void processBean(String contextName, String contextPath, BeanLocator beanLocator, String beanName) {
        if (!PropsValues.JSON_WEB_SERVICE_ENABLED) {
            return;
        }
        Object bean = null;
        try {
            bean = beanLocator.locate(beanName);
        }
        catch (BeanLocatorException beanLocatorException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)beanLocatorException);
            }
            return;
        }
        if (bean == null) {
            return;
        }
        JSONWebService jsonWebService = (JSONWebService)AnnotationLocator.locate(this.getTargetClass(bean), JSONWebService.class);
        if (jsonWebService != null) {
            try {
                this.onJSONWebServiceBean(contextName, contextPath, bean, jsonWebService);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    public void processBean(String contextName, String contextPath, Object bean) {
        if (!PropsValues.JSON_WEB_SERVICE_ENABLED) {
            return;
        }
        JSONWebService jsonWebService = (JSONWebService)AnnotationLocator.locate(bean.getClass(), JSONWebService.class);
        if (jsonWebService == null) {
            return;
        }
        try {
            this.onJSONWebServiceBean(contextName, contextPath, bean, jsonWebService);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void setWireViaUtil(boolean wireViaUtil) {
        this._wireViaUtil = wireViaUtil;
    }

    protected Class<?> getTargetClass(Object service) {
        while (ProxyUtil.isProxyClass(service.getClass())) {
            InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)service);
            if (invocationHandler instanceof AopInvocationHandler) {
                AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)invocationHandler;
                service = aopInvocationHandler.getTarget();
                continue;
            }
            if (invocationHandler instanceof ClassLoaderBeanHandler) {
                ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                Object bean = classLoaderBeanHandler.getBean();
                if (bean instanceof ServiceWrapper) {
                    ServiceWrapper serviceWrapper = (ServiceWrapper)bean;
                    service = serviceWrapper.getWrappedService();
                    continue;
                }
                service = bean;
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to handle proxy of type " + invocationHandler));
            }
            return null;
        }
        return service.getClass();
    }

    protected Class<?> loadUtilClass(Class<?> implementationClass) throws ClassNotFoundException {
        Class<?> utilClass;
        if (this._utilClasses == null) {
            this._utilClasses = new HashMap();
        }
        if ((utilClass = this._utilClasses.get(implementationClass)) != null) {
            return utilClass;
        }
        String utilClassName = this._jsonWebServiceNaming.convertServiceImplClassToUtilClassName(implementationClass);
        ClassLoader classLoader = implementationClass.getClassLoader();
        utilClass = classLoader.loadClass(utilClassName);
        this._utilClasses.put(implementationClass, utilClass);
        return utilClass;
    }

    protected void onJSONWebServiceBean(String contextName, String contextPath, Object serviceBean, JSONWebService jsonWebService) throws Exception {
        JSONWebServiceScannerStrategy.MethodDescriptor[] methodDescriptors;
        JSONWebServiceMode jsonWebServiceMode = JSONWebServiceMode.MANUAL;
        if (jsonWebService != null) {
            jsonWebServiceMode = jsonWebService.mode();
        }
        for (JSONWebServiceScannerStrategy.MethodDescriptor methodDescriptor : methodDescriptors = this._jsonWebServiceScannerStrategy.scan(serviceBean)) {
            String path;
            String httpMethod;
            JSONWebServiceMode methodJSONWebServiceMode;
            Method method = methodDescriptor.getMethod();
            JSONWebService methodJSONWebService = method.getAnnotation(JSONWebService.class);
            if ((methodJSONWebService != null ? (methodJSONWebServiceMode = methodJSONWebService.mode()).equals((Object)JSONWebServiceMode.IGNORE) : !jsonWebServiceMode.equals((Object)JSONWebServiceMode.AUTO)) || !this._jsonWebServiceNaming.isValidHttpMethod(httpMethod = this._jsonWebServiceMappingResolver.resolveHttpMethod(method))) continue;
            Class serviceBeanClass = methodDescriptor.getDeclaringClass();
            if (this._wireViaUtil) {
                Class<?> utilClass = this.loadUtilClass(serviceBeanClass);
                try {
                    method = utilClass.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)noSuchMethodException);
                    continue;
                }
            }
            if (!this._jsonWebServiceNaming.isIncludedPath(contextPath, path = this._jsonWebServiceMappingResolver.resolvePath(serviceBeanClass, method)) || !this._jsonWebServiceNaming.isIncludedMethod(method)) continue;
            if (this._wireViaUtil) {
                JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)contextName, (String)contextPath, method.getDeclaringClass(), (Method)method, (String)path, (String)httpMethod);
                continue;
            }
            JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)contextName, (String)contextPath, (Object)serviceBean, (Class)serviceBeanClass, (Method)method, (String)path, (String)httpMethod);
        }
    }
}

