/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.impl.WebDAVPropsBaseImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WebDAVPropsImpl
extends WebDAVPropsBaseImpl {
    private static final String _PROPS = "<properties />";
    private Document _document;

    public void addProp(String name, String prefix, String uri) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
        QName qName = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        Element root = this._removeExisting(qName);
        root.addElement(qName);
    }

    public void addProp(String name, String prefix, String uri, String text) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
        QName qName = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        Element root = this._removeExisting(qName);
        Element element = root.addElement(qName);
        element.addText(text);
    }

    @Override
    public String getProps() {
        String props = super.getProps();
        if (Validator.isNull((String)props)) {
            return _PROPS;
        }
        return props;
    }

    public Set<QName> getPropsSet() throws Exception {
        HashSet<QName> propsSet = new HashSet<QName>();
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        for (Element el : root.elements()) {
            String prefix = el.getNamespacePrefix();
            String uri = el.getNamespaceURI();
            Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
            propsSet.add(SAXReaderUtil.createQName((String)el.getName(), (Namespace)namespace));
        }
        return propsSet;
    }

    public String getText(String name, String prefix, String uri) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
        QName qName = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        Element prop = root.element(qName);
        return prop.getText();
    }

    public void removeProp(String name, String prefix, String uri) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
        QName qName = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        this._removeExisting(qName);
    }

    public void store() throws Exception {
        if (this._document != null) {
            String xml = this._document.formattedString("    ");
            this.setProps(xml);
            this._document = null;
        }
    }

    private Document _getPropsDocument() throws Exception {
        if (this._document == null) {
            this._document = SAXReaderUtil.read((String)this.getProps());
        }
        return this._document;
    }

    private Element _removeExisting(QName qName) throws Exception {
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        List elementsList = root.elements(qName);
        for (Element el : elementsList) {
            root.remove(el);
        }
        return root;
    }
}

