/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.util.DBInfo;
import com.liferay.portal.dao.jdbc.util.DBInfoUtil;
import com.liferay.portal.dao.orm.hibernate.DB2Dialect;
import com.liferay.portal.dao.orm.hibernate.HSQLDialect;
import com.liferay.portal.dao.orm.hibernate.MariaDBDialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2005Dialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2008Dialect;
import com.liferay.portal.dao.orm.hibernate.SybaseASE157Dialect;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.resolver.DialectFactory;

public class DialectDetector {
    private static final Log _log = LogFactoryUtil.getLog(DialectDetector.class);
    private static final Map<String, Dialect> _dialects = new ConcurrentHashMap<String, Dialect>();

    public static Dialect getDialect(DataSource dataSource) {
        String dialectKey;
        Object dialect;
        String dbName;
        int dbMinorVersion;
        int dbMajorVersion;
        block30: {
            DBInfo dbInfo = DBInfoUtil.getDBInfo(dataSource);
            dbMajorVersion = dbInfo.getMajorVersion();
            dbMinorVersion = dbInfo.getMinorVersion();
            dbName = dbInfo.getName();
            dialect = null;
            dialectKey = null;
            try {
                dialectKey = StringBundler.concat((Object[])new Object[]{dbName, ":", dbMajorVersion, ":", dbMinorVersion});
                dialect = _dialects.get(dialectKey);
                if (dialect != null) {
                    return dialect;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Determine dialect for ", dbName, " ", dbMajorVersion, ".", dbMinorVersion}));
                }
                if (dbName.startsWith("HSQL")) {
                    dialect = new HSQLDialect();
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Liferay is configured to use Hypersonic as its ", "database. Do NOT use Hypersonic in production. ", "Hypersonic is an embedded database useful for ", "development and demonstration purposes. The ", "database settings can be changed in ", "portal-ext.properties."}));
                    }
                    break block30;
                }
                if (dbName.equals("Adaptive Server Enterprise") && dbMajorVersion >= 15) {
                    dialect = new SybaseASE157Dialect();
                    break block30;
                }
                if (dbName.equals("ASE")) {
                    throw new RuntimeException("jTDS is no longer suppported. Please use the Sybase JDBC driver to connect to Sybase.");
                }
                if (dbName.startsWith("DB2") && dbMajorVersion >= 9) {
                    dialect = new DB2Dialect();
                    break block30;
                }
                if (dbName.startsWith("MariaDB")) {
                    dialect = new MariaDBDialect();
                    break block30;
                }
                if (dbName.startsWith("Microsoft") && dbMajorVersion == 9) {
                    dialect = new SQLServer2005Dialect();
                    break block30;
                }
                if (dbName.startsWith("Microsoft") && dbMajorVersion >= 10) {
                    dialect = new SQLServer2008Dialect();
                    break block30;
                }
                if (dbName.startsWith("Oracle") && dbMajorVersion >= 10) {
                    dialect = new Oracle10gDialect();
                    break block30;
                }
                try (Connection connection = dataSource.getConnection();){
                    dialect = DialectFactory.buildDialect((Properties)new Properties(), (Connection)connection);
                }
            }
            catch (Exception exception) {
                String msg = GetterUtil.getString((String)exception.getMessage());
                if (msg.contains("explicitly set for database: DB2")) {
                    dialect = new DB2400Dialect();
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"DB2400Dialect was dynamically chosen as the Hibernate dialect for DB2. This can be overriden in portal.properties");
                    }
                }
                _log.error((Throwable)exception);
            }
        }
        if (dialect == null) {
            throw new RuntimeException("No dialect found");
        }
        if (dialectKey != null) {
            if (_log.isInfoEnabled()) {
                Class<?> clazz = dialect.getClass();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Using dialect ", clazz.getName(), " for ", dbName, " ", dbMajorVersion, ".", dbMinorVersion}));
            }
            _dialects.put(dialectKey, (Dialect)dialect);
        }
        return dialect;
    }
}

