/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.service.WebDAVPropsLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.webdav.InvalidRequestException;
import com.liferay.portal.webdav.LockException;
import com.liferay.portal.webdav.methods.BasePropMethodImpl;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ProppatchMethodImpl
extends BasePropMethodImpl {
    private static final Log _log = LogFactoryUtil.getLog(ProppatchMethodImpl.class);

    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            Set<QName> props = this.processInstructions(webDAVRequest);
            return this.writeResponseXML(webDAVRequest, props);
        }
        catch (InvalidRequestException invalidRequestException) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)invalidRequestException.getMessage(), (Throwable)((Object)invalidRequestException));
            }
            return 400;
        }
        catch (LockException lockException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)((Object)lockException));
            }
            return 423;
        }
        catch (Exception exception) {
            throw new WebDAVException((Throwable)exception);
        }
    }

    protected WebDAVProps getStoredProperties(WebDAVRequest webDAVRequest) throws PortalException {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        Resource resource = storage.getResource(webDAVRequest);
        if (resource.getPrimaryKey() <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"There is no primary key set for resource");
            }
            throw new InvalidRequestException();
        }
        if (resource.isLocked()) {
            Lock lock = resource.getLock();
            if (lock == null) {
                throw new LockException();
            }
            String uuid = lock.getUuid();
            if (!uuid.equals(webDAVRequest.getLockUuid())) {
                throw new LockException();
            }
        }
        return WebDAVPropsLocalServiceUtil.getWebDAVProps((long)webDAVRequest.getCompanyId(), (String)resource.getClassName(), (long)resource.getPrimaryKey());
    }

    protected Set<QName> processInstructions(WebDAVRequest webDAVRequest) throws InvalidRequestException, LockException {
        try {
            HashSet<QName> newProps = new HashSet<QName>();
            HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
            String xml = new String(FileUtil.getBytes((InputStream)httpServletRequest.getInputStream()));
            if (Validator.isNull((String)xml)) {
                return newProps;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Request XML: \n" + Dom4jUtil.toString((String)xml, (String)"    ")));
            }
            WebDAVProps webDAVProps = this.getStoredProperties(webDAVRequest);
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            List instructionElements = rootElement.elements();
            for (Element instructionElement : instructionElements) {
                List propElements = instructionElement.elements();
                if (propElements.size() != 1) {
                    throw new InvalidRequestException("There should only be one <prop /> per set or remove instruction");
                }
                Element propElement = (Element)propElements.get(0);
                String propElementName = propElement.getName();
                String propElementNamespaceURI = propElement.getNamespaceURI();
                if (!propElementName.equals("prop") || !propElementNamespaceURI.equals(WebDAVUtil.DAV_URI.getURI())) {
                    throw new InvalidRequestException("Invalid <prop /> element " + propElement);
                }
                List customPropElements = propElement.elements();
                for (Element customPropElement : customPropElements) {
                    String prefix = customPropElement.getNamespacePrefix();
                    String uri = customPropElement.getNamespaceURI();
                    Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
                    String name = customPropElement.getName();
                    String instructionElementName = instructionElement.getName();
                    if (instructionElementName.equals("set")) {
                        String text = customPropElement.getText();
                        if (Validator.isNull((String)text)) {
                            webDAVProps.addProp(name, prefix, uri);
                        } else {
                            webDAVProps.addProp(name, prefix, uri, text);
                        }
                        newProps.add(SAXReaderUtil.createQName((String)customPropElement.getName(), (Namespace)namespace));
                        continue;
                    }
                    if (instructionElementName.equals("remove")) {
                        webDAVProps.removeProp(name, prefix, uri);
                        continue;
                    }
                    throw new InvalidRequestException("Instead of set/remove instruction, received " + instructionElement);
                }
            }
            WebDAVPropsLocalServiceUtil.storeWebDAVProps((WebDAVProps)webDAVProps);
            return newProps;
        }
        catch (LockException lockException) {
            throw lockException;
        }
        catch (Exception exception) {
            throw new InvalidRequestException(exception);
        }
    }
}

