/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import com.liferay.asset.kernel.exception.NoSuchCategoryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.persistence.AssetCategoryFinder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.impl.AssetCategoryImpl;
import com.liferay.portlet.asset.service.persistence.impl.AssetCategoryFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

public class AssetCategoryFinderImpl
extends AssetCategoryFinderBaseImpl
implements AssetCategoryFinder {
    public static final String COUNT_BY_CC = AssetCategoryFinder.class.getName() + ".countByC_C";
    public static final String COUNT_BY_G_C_N = AssetCategoryFinder.class.getName() + ".countByG_C_N";
    public static final String COUNT_BY_G_N_P = AssetCategoryFinder.class.getName() + ".countByG_N_P";
    public static final String FIND_BY_G_N = AssetCategoryFinder.class.getName() + ".findByG_N";
    public static final String FIND_BY_C_C = AssetCategoryFinder.class.getName() + ".findByC_C";
    public static final String FIND_BY_G_N_P = AssetCategoryFinder.class.getName() + ".findByG_N_P";

    public int countByG_C_N(long groupId, long classNameId, String name) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_C_N);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(classNameId);
            queryPos.add(name);
            queryPos.add(name);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_N_P(long groupId, String name, String[] categoryProperties) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_P);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            this.setJoin(queryPos, categoryProperties);
            queryPos.add(groupId);
            queryPos.add(name);
            queryPos.add(name);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByC_C(long classNameId, long classPK) {
        return this.doCountByC_C(classNameId, classPK, true);
    }

    public List<AssetCategory> filterFindByC_C(long classNameId, long classPK, int start, int end) {
        return this.doFindByC_C(classNameId, classPK, start, end, true);
    }

    public AssetCategory findByG_N(long groupId, String name) throws NoSuchCategoryException {
        name = StringUtil.toLowerCase((String)name.trim());
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(name);
            List categories = sqlQuery.list();
            if (!categories.isEmpty()) {
                AssetCategory assetCategory = (AssetCategory)categories.get(0);
                return assetCategory;
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
        throw new NoSuchCategoryException(StringBundler.concat((Object[])new Object[]{"No AssetCategory exists with the key {groupId=", groupId, ", name=", name, "}"}));
    }

    public List<AssetCategory> findByC_C(long classNameId, long classPK) {
        return this.doFindByC_C(classNameId, classPK, -1, -1, false);
    }

    public List<AssetCategory> findByG_N_P(long groupId, String name, String[] categoryProperties) {
        return this.findByG_N_P(groupId, name, categoryProperties, -1, -1);
    }

    public List<AssetCategory> findByG_N_P(long groupId, String name, String[] categoryProperties, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_P);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(categoryProperties));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            this.setJoin(queryPos, categoryProperties);
            queryPos.add(groupId);
            queryPos.add(name);
            queryPos.add(name);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByC_C(long classNameId, long classPK, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_CC);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetCategory.class.getName(), (String)"AssetCategory.categoryId");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(classNameId);
            queryPos.add(classPK);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<AssetCategory> doFindByC_C(long classNameId, long classPK, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_C);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetCategory.class.getName(), (String)"AssetCategory.categoryId");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(classNameId);
            queryPos.add(classPK);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(String[] categoryProperties) {
        if (categoryProperties.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(categoryProperties.length * 3 + 2);
        sb.append(" INNER JOIN AssetCategoryProperty ON ");
        sb.append("(AssetCategoryProperty.categoryId = ");
        sb.append("AssetCategory.categoryId) AND ");
        for (int i = 0; i < categoryProperties.length; ++i) {
            sb.append("(AssetCategoryProperty.key_ = ? AND ");
            sb.append("AssetCategoryProperty.value = ?) ");
            if (i + 1 >= categoryProperties.length) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    protected void setJoin(QueryPos queryPos, String[] categoryProperties) {
        for (String categoryProperty : categoryProperties) {
            String[] categoryPropertyArray = StringUtil.split((String)categoryProperty, (String)"_KEY_VALUE_");
            if (categoryPropertyArray.length <= 1) {
                categoryPropertyArray = StringUtil.split((String)categoryProperty, (char)':');
            }
            String key = "";
            if (categoryPropertyArray.length > 0) {
                key = GetterUtil.getString((String)categoryPropertyArray[0]);
            }
            String value = "";
            if (categoryPropertyArray.length > 1) {
                value = GetterUtil.getString((String)categoryPropertyArray[1]);
            }
            queryPos.add(key);
            queryPos.add(value);
        }
    }
}

