/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.service.impl;

import com.liferay.mail.kernel.model.Filter;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.util.Hook;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class MailServiceImpl
implements IdentifiableOSGiService,
MailService {
    private static final Log _log = LogFactoryUtil.getLog(MailServiceImpl.class);
    private static final MethodKey _addForwardMethodKey = new MethodKey(Hook.class, "addForward", new Class[]{Long.TYPE, Long.TYPE, List.class, List.class, Boolean.TYPE});
    private static final MethodKey _addUserMethodKey = new MethodKey(Hook.class, "addUser", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class});
    private static final MethodKey _addVacationMessageMethodKey = new MethodKey(Hook.class, "addVacationMessage", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class});
    private static final MethodKey _deleteEmailAddressMethodKey = new MethodKey(Hook.class, "deleteEmailAddress", new Class[]{Long.TYPE, Long.TYPE});
    private static final MethodKey _deleteUserMethodKey = new MethodKey(Hook.class, "deleteUser", new Class[]{Long.TYPE, Long.TYPE});
    private static final MethodKey _updateBlockedMethodKey = new MethodKey(Hook.class, "updateBlocked", new Class[]{Long.TYPE, Long.TYPE, List.class});
    private static final MethodKey _updateEmailAddressMethodKey = new MethodKey(Hook.class, "updateEmailAddress", new Class[]{Long.TYPE, Long.TYPE, String.class});
    private static final MethodKey _updatePasswordMethodKey = new MethodKey(Hook.class, "updatePassword", new Class[]{Long.TYPE, Long.TYPE, String.class});
    private Session _session;

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"addForward");
        }
        MethodHandler methodHandler = new MethodHandler(_addForwardMethodKey, new Object[]{companyId, userId, filters, emailAddresses, leaveCopy});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"addUser");
        }
        MethodHandler methodHandler = new MethodHandler(_addUserMethodKey, new Object[]{companyId, userId, password, firstName, middleName, lastName, emailAddress});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"addVacationMessage");
        }
        MethodHandler methodHandler = new MethodHandler(_addVacationMessageMethodKey, new Object[]{companyId, userId, emailAddress, vacationMessage});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    @Clusterable
    public void clearSession() {
        this._session = null;
    }

    @Clusterable
    public void clearSession(long companyId) {
        this._session = null;
    }

    public void deleteEmailAddress(long companyId, long userId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"deleteEmailAddress");
        }
        MethodHandler methodHandler = new MethodHandler(_deleteEmailAddressMethodKey, new Object[]{companyId, userId});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    public void deleteUser(long companyId, long userId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"deleteUser");
        }
        MethodHandler methodHandler = new MethodHandler(_deleteUserMethodKey, new Object[]{companyId, userId});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    public String getOSGiServiceIdentifier() {
        return MailService.class.getName();
    }

    public Session getSession() {
        boolean smtpAuth;
        Properties properties;
        String smtpUser;
        String smtpPassword;
        block9: {
            if (this._session != null) {
                return this._session;
            }
            Session session = InfrastructureUtil.getMailSession();
            if (!PrefsPropsUtil.getBoolean("mail.session.mail", PropsValues.MAIL_SESSION_MAIL)) {
                this._session = session;
                return this._session;
            }
            String advancedPropertiesString = PrefsPropsUtil.getString("mail.session.mail.advanced.properties", PropsValues.MAIL_SESSION_MAIL_ADVANCED_PROPERTIES);
            String pop3Host = PrefsPropsUtil.getString("mail.session.mail.pop3.host", PropsValues.MAIL_SESSION_MAIL_POP3_HOST);
            String pop3Password = PrefsPropsUtil.getString("mail.session.mail.pop3.password", PropsValues.MAIL_SESSION_MAIL_POP3_PASSWORD);
            int pop3Port = PrefsPropsUtil.getInteger("mail.session.mail.pop3.port", PropsValues.MAIL_SESSION_MAIL_POP3_PORT);
            String pop3User = PrefsPropsUtil.getString("mail.session.mail.pop3.user", PropsValues.MAIL_SESSION_MAIL_POP3_USER);
            String smtpHost = PrefsPropsUtil.getString("mail.session.mail.smtp.host", PropsValues.MAIL_SESSION_MAIL_SMTP_HOST);
            smtpPassword = PrefsPropsUtil.getString("mail.session.mail.smtp.password", PropsValues.MAIL_SESSION_MAIL_SMTP_PASSWORD);
            int smtpPort = PrefsPropsUtil.getInteger("mail.session.mail.smtp.port", PropsValues.MAIL_SESSION_MAIL_SMTP_PORT);
            boolean smtpStartTLSEnable = PrefsPropsUtil.getBoolean("mail.session.mail.smtp.starttls.enable", PropsValues.MAIL_SESSION_MAIL_SMTP_STARTTLS_ENABLE);
            smtpUser = PrefsPropsUtil.getString("mail.session.mail.smtp.user", PropsValues.MAIL_SESSION_MAIL_SMTP_USER);
            String storeProtocol = PrefsPropsUtil.getString("mail.session.mail.store.protocol", PropsValues.MAIL_SESSION_MAIL_STORE_PROTOCOL);
            String transportProtocol = PrefsPropsUtil.getString("mail.session.mail.transport.protocol", PropsValues.MAIL_SESSION_MAIL_TRANSPORT_PROTOCOL);
            properties = session.getProperties();
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            properties.setProperty("mail.store.protocol", storeProtocol);
            String storePrefix = "mail." + storeProtocol + ".";
            properties.setProperty(storePrefix + "host", pop3Host);
            properties.setProperty(storePrefix + "password", pop3Password);
            properties.setProperty(storePrefix + "port", String.valueOf(pop3Port));
            properties.setProperty(storePrefix + "user", pop3User);
            if (!transportProtocol.equals("smtps")) {
                transportProtocol = "smtp";
            }
            properties.setProperty("mail.transport.protocol", transportProtocol);
            String transportPrefix = "mail." + transportProtocol + ".";
            smtpAuth = false;
            if (Validator.isNotNull((String)smtpPassword) || Validator.isNotNull((String)smtpUser)) {
                smtpAuth = true;
            }
            properties.setProperty(transportPrefix + "auth", String.valueOf(smtpAuth));
            properties.setProperty(transportPrefix + "host", smtpHost);
            properties.setProperty(transportPrefix + "password", smtpPassword);
            properties.setProperty(transportPrefix + "port", String.valueOf(smtpPort));
            properties.setProperty(transportPrefix + "starttls.enable", String.valueOf(smtpStartTLSEnable));
            properties.setProperty(transportPrefix + "user", smtpUser);
            try {
                if (Validator.isNotNull((String)advancedPropertiesString)) {
                    Properties advancedProperties = PropertiesUtil.load((String)advancedPropertiesString);
                    for (Map.Entry<Object, Object> entry : advancedProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        properties.setProperty(key, value);
                    }
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Throwable)ioException);
            }
        }
        this._session = smtpAuth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpUser, smtpPassword);
            }
        }) : Session.getInstance((Properties)properties);
        return this._session;
    }

    public void sendEmail(MailMessage mailMessage) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"sendEmail");
        }
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)mailMessage);
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"updateBlocked");
        }
        MethodHandler methodHandler = new MethodHandler(_updateBlockedMethodKey, new Object[]{companyId, userId, blocked});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"updateEmailAddress");
        }
        MethodHandler methodHandler = new MethodHandler(_updateEmailAddressMethodKey, new Object[]{companyId, userId, emailAddress});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }

    public void updatePassword(long companyId, long userId, String password) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"updatePassword");
        }
        MethodHandler methodHandler = new MethodHandler(_updatePasswordMethodKey, new Object[]{companyId, userId, password});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
    }
}

