/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.deploy.hot.ServiceBag;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceWrapperRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ServiceWrapperRegistry.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final ServiceTracker<ServiceWrapper<?>, ServiceBag<?>> _serviceTracker = new ServiceTracker(this._bundleContext, ServiceWrapper.class.getName(), (ServiceTrackerCustomizer)new ServiceWrapperServiceTrackerCustomizer());

    public ServiceWrapperRegistry() {
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    private class ServiceWrapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServiceWrapper<?>, ServiceBag<?>> {
        private ServiceWrapperServiceTrackerCustomizer() {
        }

        public ServiceBag<?> addingService(ServiceReference<ServiceWrapper<?>> serviceReference) {
            ServiceWrapper serviceWrapper = (ServiceWrapper)ServiceWrapperRegistry.this._bundleContext.getService(serviceReference);
            try {
                return this._getServiceBag(serviceWrapper);
            }
            catch (Throwable throwable) {
                _log.error((Object)("Unable to get service bag for " + serviceWrapper.getClass()), throwable);
                return null;
            }
        }

        public void modifiedService(ServiceReference<ServiceWrapper<?>> serviceReference, ServiceBag<?> serviceHolder) {
        }

        public void removedService(ServiceReference<ServiceWrapper<?>> serviceReference, ServiceBag<?> serviceBag) {
            ServiceWrapperRegistry.this._bundleContext.ungetService(serviceReference);
            try {
                serviceBag.replace();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> ServiceBag<?> _getServiceBag(ServiceWrapper<T> serviceWrapper) throws NoSuchMethodException {
            Class<?> clazz = serviceWrapper.getClass();
            Method method = clazz.getMethod("getWrappedService", new Class[0]);
            Class<?> serviceTypeClass = method.getReturnType();
            Object service = null;
            ServiceReference serviceReference = null;
            try {
                service = PortalBeanLocatorUtil.locate((String)serviceTypeClass.getName());
            }
            catch (BeanLocatorException beanLocatorException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)beanLocatorException);
                }
                serviceReference = ServiceWrapperRegistry.this._bundleContext.getServiceReference(serviceTypeClass);
                service = ServiceWrapperRegistry.this._bundleContext.getService(serviceReference);
            }
            Object serviceProxy = service;
            if (!ProxyUtil.isProxyClass(serviceProxy.getClass())) {
                _log.error((Object)"Service hooks require Spring to be configured to use JdkDynamicProxy and will not work with CGLIB");
                if (serviceReference != null) {
                    ServiceWrapperRegistry.this._bundleContext.ungetService(serviceReference);
                }
                return null;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            try {
                AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)serviceProxy, AopInvocationHandler.class);
                serviceWrapper.setWrappedService(aopInvocationHandler.getTarget());
                ServiceBag<T> serviceBag = new ServiceBag<T>(classLoader, aopInvocationHandler, serviceTypeClass, serviceWrapper);
                return serviceBag;
            }
            finally {
                if (serviceReference != null) {
                    ServiceWrapperRegistry.this._bundleContext.ungetService(serviceReference);
                }
            }
        }
    }
}

