/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONWebServiceNamingUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;

public class JSONWebServiceMappingResolverUtil {
    public static String resolveHttpMethod(Method method) {
        JSONWebService annotationJSONWebService = method.getAnnotation(JSONWebService.class);
        String httpMethod = null;
        if (annotationJSONWebService != null) {
            httpMethod = StringUtil.trim((String)annotationJSONWebService.method());
        }
        if (httpMethod != null && httpMethod.length() != 0) {
            return httpMethod;
        }
        return JSONWebServiceNamingUtil.convertMethodToHttpMethod(method);
    }

    public static String resolvePath(Class<?> clazz, Method method) {
        JSONWebService annotationJSONWebService = method.getAnnotation(JSONWebService.class);
        String path = null;
        if (annotationJSONWebService != null) {
            path = StringUtil.trim((String)annotationJSONWebService.value());
        }
        if (path == null || path.length() == 0) {
            path = JSONWebServiceNamingUtil.convertMethodToPath(method);
        }
        if (path.startsWith("/")) {
            return path;
        }
        path = "/" + path;
        String pathFromClass = null;
        annotationJSONWebService = clazz.getAnnotation(JSONWebService.class);
        if (annotationJSONWebService != null) {
            pathFromClass = StringUtil.trim((String)annotationJSONWebService.value());
        }
        if (pathFromClass == null || pathFromClass.length() == 0) {
            pathFromClass = JSONWebServiceNamingUtil.convertServiceClassToPath(clazz);
        }
        if (!pathFromClass.startsWith("/")) {
            pathFromClass = "/" + pathFromClass;
        }
        return pathFromClass + path;
    }
}

