/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.RoleFinder;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;

public abstract class RoleLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
RoleLocalService {
    @BeanReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    @BeanReference(type=RolePersistence.class)
    protected RolePersistence rolePersistence;
    @BeanReference(type=RoleFinder.class)
    protected RoleFinder roleFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public Role addRole(Role role) {
        role.setNew(true);
        return (Role)this.rolePersistence.update((BaseModel)role);
    }

    @Transactional(enabled=false)
    public Role createRole(long roleId) {
        return this.rolePersistence.create(roleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Role deleteRole(long roleId) throws PortalException {
        return this.rolePersistence.remove(roleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Role deleteRole(Role role) throws PortalException {
        return (Role)this.rolePersistence.remove((BaseModel)role);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.rolePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Role.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.rolePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.rolePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.rolePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.rolePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.rolePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Role fetchRole(long roleId) {
        return this.rolePersistence.fetchByPrimaryKey(roleId);
    }

    public Role fetchRoleByUuidAndCompanyId(String uuid, long companyId) {
        return this.rolePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Role getRole(long roleId) throws PortalException {
        return this.rolePersistence.findByPrimaryKey(roleId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.roleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Role.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("roleId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.roleLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Role.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("roleId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.roleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Role.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("roleId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Role>(){

            public void performAction(Role role) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)role);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Role.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.rolePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.roleLocalService.deleteRole((Role)persistedModel);
    }

    public BasePersistence<Role> getBasePersistence() {
        return this.rolePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.rolePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Role getRoleByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.rolePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Role> getRoles(int start, int end) {
        return this.rolePersistence.findAll(start, end);
    }

    public int getRolesCount() {
        return this.rolePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Role updateRole(Role role) {
        return (Role)this.rolePersistence.update((BaseModel)role);
    }

    public void addGroupRole(long groupId, long roleId) {
        this.groupPersistence.addRole(groupId, roleId);
    }

    public void addGroupRole(long groupId, Role role) {
        this.groupPersistence.addRole(groupId, role);
    }

    public void addGroupRoles(long groupId, long[] roleIds) {
        this.groupPersistence.addRoles(groupId, roleIds);
    }

    public void addGroupRoles(long groupId, List<Role> roles) {
        this.groupPersistence.addRoles(groupId, roles);
    }

    public void clearGroupRoles(long groupId) {
        this.groupPersistence.clearRoles(groupId);
    }

    public void deleteGroupRole(long groupId, long roleId) {
        this.groupPersistence.removeRole(groupId, roleId);
    }

    public void deleteGroupRole(long groupId, Role role) {
        this.groupPersistence.removeRole(groupId, role);
    }

    public void deleteGroupRoles(long groupId, long[] roleIds) {
        this.groupPersistence.removeRoles(groupId, roleIds);
    }

    public void deleteGroupRoles(long groupId, List<Role> roles) {
        this.groupPersistence.removeRoles(groupId, roles);
    }

    public long[] getGroupPrimaryKeys(long roleId) {
        return this.rolePersistence.getGroupPrimaryKeys(roleId);
    }

    public List<Role> getGroupRoles(long groupId) {
        return this.groupPersistence.getRoles(groupId);
    }

    public List<Role> getGroupRoles(long groupId, int start, int end) {
        return this.groupPersistence.getRoles(groupId, start, end);
    }

    public List<Role> getGroupRoles(long groupId, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.groupPersistence.getRoles(groupId, start, end, orderByComparator);
    }

    public int getGroupRolesCount(long groupId) {
        return this.groupPersistence.getRolesSize(groupId);
    }

    public boolean hasGroupRole(long groupId, long roleId) {
        return this.groupPersistence.containsRole(groupId, roleId);
    }

    public boolean hasGroupRoles(long groupId) {
        return this.groupPersistence.containsRoles(groupId);
    }

    public void setGroupRoles(long groupId, long[] roleIds) {
        this.groupPersistence.setRoles(groupId, roleIds);
    }

    public void addUserRole(long userId, long roleId) throws PortalException {
        this.userPersistence.addRole(userId, roleId);
    }

    public void addUserRole(long userId, Role role) throws PortalException {
        this.userPersistence.addRole(userId, role);
    }

    public void addUserRoles(long userId, long[] roleIds) throws PortalException {
        this.userPersistence.addRoles(userId, roleIds);
    }

    public void addUserRoles(long userId, List<Role> roles) throws PortalException {
        this.userPersistence.addRoles(userId, roles);
    }

    public void clearUserRoles(long userId) throws PortalException {
        this.userPersistence.clearRoles(userId);
    }

    public void deleteUserRole(long userId, long roleId) throws PortalException {
        this.userPersistence.removeRole(userId, roleId);
    }

    public void deleteUserRole(long userId, Role role) throws PortalException {
        this.userPersistence.removeRole(userId, role);
    }

    public void deleteUserRoles(long userId, long[] roleIds) throws PortalException {
        this.userPersistence.removeRoles(userId, roleIds);
    }

    public void deleteUserRoles(long userId, List<Role> roles) throws PortalException {
        this.userPersistence.removeRoles(userId, roles);
    }

    public long[] getUserPrimaryKeys(long roleId) {
        return this.rolePersistence.getUserPrimaryKeys(roleId);
    }

    public List<Role> getUserRoles(long userId) {
        return this.userPersistence.getRoles(userId);
    }

    public List<Role> getUserRoles(long userId, int start, int end) {
        return this.userPersistence.getRoles(userId, start, end);
    }

    public List<Role> getUserRoles(long userId, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.userPersistence.getRoles(userId, start, end, orderByComparator);
    }

    public int getUserRolesCount(long userId) {
        return this.userPersistence.getRolesSize(userId);
    }

    public boolean hasUserRole(long userId, long roleId) {
        return this.userPersistence.containsRole(userId, roleId);
    }

    public boolean hasUserRoles(long userId) {
        return this.userPersistence.containsRoles(userId);
    }

    public void setUserRoles(long userId, long[] roleIds) throws PortalException {
        this.userPersistence.setRoles(userId, roleIds);
    }

    public RoleLocalService getRoleLocalService() {
        return this.roleLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public RolePersistence getRolePersistence() {
        return this.rolePersistence;
    }

    public void setRolePersistence(RolePersistence rolePersistence) {
        this.rolePersistence = rolePersistence;
    }

    public RoleFinder getRoleFinder() {
        return this.roleFinder;
    }

    public void setRoleFinder(RoleFinder roleFinder) {
        this.roleFinder = roleFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.kernel.model.Role", (PersistedModelLocalService)this.roleLocalService);
        this._setLocalServiceUtilService(this.roleLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.kernel.model.Role");
        this._setLocalServiceUtilService(null);
    }

    public String getOSGiServiceIdentifier() {
        return RoleLocalService.class.getName();
    }

    public CTPersistence<Role> getCTPersistence() {
        return this.rolePersistence;
    }

    public Class<Role> getModelClass() {
        return Role.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Role>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.rolePersistence);
    }

    protected String getModelClassName() {
        return Role.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.rolePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(RoleLocalService roleLocalService) {
        try {
            Field field = RoleLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, roleLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

