/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchUserNotificationDeliveryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.service.base.UserNotificationDeliveryLocalServiceBaseImpl;

public class UserNotificationDeliveryLocalServiceImpl
extends UserNotificationDeliveryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(UserNotificationDeliveryLocalServiceImpl.class);
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public UserNotificationDelivery addUserNotificationDelivery(long userId, String portletId, long classNameId, int notificationType, int deliveryType, boolean deliver) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long userNotificationDeliveryId = this.counterLocalService.increment();
        UserNotificationDelivery userNotificationDelivery = this.userNotificationDeliveryPersistence.create(userNotificationDeliveryId);
        userNotificationDelivery.setCompanyId(user.getCompanyId());
        userNotificationDelivery.setUserId(user.getUserId());
        userNotificationDelivery.setPortletId(portletId);
        userNotificationDelivery.setClassNameId(classNameId);
        userNotificationDelivery.setNotificationType(notificationType);
        userNotificationDelivery.setDeliveryType(deliveryType);
        userNotificationDelivery.setDeliver(deliver);
        return (UserNotificationDelivery)this.userNotificationDeliveryPersistence.update((BaseModel)userNotificationDelivery);
    }

    public void deleteUserNotificationDeliveries(long userId) {
        this.userNotificationDeliveryPersistence.removeByUserId(userId);
    }

    public void deleteUserNotificationDelivery(long userId, String portletId, long classNameId, int notificationType, int deliveryType) {
        block2: {
            try {
                this.userNotificationDeliveryPersistence.removeByU_P_C_N_D(userId, portletId, classNameId, notificationType, deliveryType);
            }
            catch (NoSuchUserNotificationDeliveryException noSuchUserNotificationDeliveryException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)noSuchUserNotificationDeliveryException);
            }
        }
    }

    public UserNotificationDelivery fetchUserNotificationDelivery(long userId, String portletId, long classNameId, int notificationType, int deliveryType) {
        return this.userNotificationDeliveryPersistence.fetchByU_P_C_N_D(userId, portletId, classNameId, notificationType, deliveryType);
    }

    public UserNotificationDelivery getUserNotificationDelivery(long userId, String portletId, long classNameId, int notificationType, int deliveryType, boolean deliver) throws PortalException {
        UserNotificationDelivery userNotificationDelivery = this.userNotificationDeliveryPersistence.fetchByU_P_C_N_D(userId, portletId, classNameId, notificationType, deliveryType);
        if (userNotificationDelivery != null) {
            return userNotificationDelivery;
        }
        return this.userNotificationDeliveryLocalService.addUserNotificationDelivery(userId, portletId, classNameId, notificationType, deliveryType, deliver);
    }

    public UserNotificationDelivery updateUserNotificationDelivery(long userNotificationDeliveryId, boolean deliver) {
        UserNotificationDelivery userNotificationDelivery = this.fetchUserNotificationDelivery(userNotificationDeliveryId);
        userNotificationDelivery.setDeliver(deliver);
        return (UserNotificationDelivery)this.userNotificationDeliveryPersistence.update((BaseModel)userNotificationDelivery);
    }
}

