/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.internal.PortletRequestImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletException;
import javax.portlet.RenderParameters;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public abstract class ClientDataRequestImpl
extends PortletRequestImpl
implements ClientDataRequest {
    private boolean _calledGetReader;

    public String getCharacterEncoding() {
        return this.getHttpServletRequest().getCharacterEncoding();
    }

    public int getContentLength() {
        return this.getHttpServletRequest().getContentLength();
    }

    public long getContentLengthLong() {
        return this.getHttpServletRequest().getContentLengthLong();
    }

    public String getContentType() {
        return this.getHttpServletRequest().getContentType();
    }

    @Override
    public String getMethod() {
        return this.getHttpServletRequest().getMethod();
    }

    public Part getPart(String name) throws IOException, PortletException {
        UploadRequest uploadRequest = this._getUploadRequest(this.getHttpServletRequest());
        if (uploadRequest == null) {
            return null;
        }
        Map multipartParameterMap = uploadRequest.getMultipartParameterMap();
        FileItem[] fileItems = (FileItem[])multipartParameterMap.get(name);
        if (fileItems == null || fileItems.length == 0) {
            return null;
        }
        Portlet portlet = this.getPortlet();
        return new PartImpl(fileItems[0], portlet.getMultipartLocation());
    }

    public Collection<Part> getParts() throws IOException, PortletException {
        UploadRequest uploadRequest = this._getUploadRequest(this.getHttpServletRequest());
        if (uploadRequest == null) {
            return Collections.emptySet();
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        Map multipartParameterMap = uploadRequest.getMultipartParameterMap();
        Portlet portlet = this.getPortlet();
        for (Map.Entry entry : multipartParameterMap.entrySet()) {
            FileItem[] fileItems;
            for (FileItem fileItem : fileItems = (FileItem[])entry.getValue()) {
                parts.add(new PartImpl(fileItem, portlet.getMultipartLocation()));
            }
        }
        return parts;
    }

    public InputStream getPortletInputStream() throws IOException {
        this._checkContentType();
        return this.getHttpServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws IOException, UnsupportedEncodingException {
        this._calledGetReader = true;
        this._checkContentType();
        return this.getHttpServletRequest().getReader();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this._calledGetReader) {
            throw new IllegalStateException();
        }
        this.getHttpServletRequest().setCharacterEncoding(enc);
    }

    protected Map<String, String[]> getPortletParameterMap(HttpServletRequest httpServletRequest, String portletNamespace) {
        LinkedHashMap<String, String[]> portletParameterMap = new LinkedHashMap<String, String[]>();
        Map<String, String[]> parameterMap = this.getParameterMap();
        Map servletRequestParameterMap = httpServletRequest.getParameterMap();
        RenderParameters renderParameters = this.getRenderParameters();
        Set renderParameterNames = renderParameters.getNames();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            if (renderParameterNames.contains(name)) {
                String[] values = (String[])servletRequestParameterMap.get(portletNamespace.concat(name));
                if (values == null) continue;
                portletParameterMap.put(name, values);
                continue;
            }
            portletParameterMap.put(name, entry.getValue());
        }
        return portletParameterMap;
    }

    private void _checkContentType() {
        if (StringUtil.equalsIgnoreCase((String)this.getMethod(), (String)"POST") && StringUtil.equalsIgnoreCase((String)this.getContentType(), (String)"application/x-www-form-urlencoded")) {
            throw new IllegalStateException();
        }
    }

    private UploadRequest _getUploadRequest(Object request) {
        while (true) {
            if (request instanceof UploadRequest) {
                return (UploadRequest)request;
            }
            if (!(request instanceof ServletRequestWrapper)) break;
            ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)request;
            request = servletRequestWrapper.getRequest();
        }
        return null;
    }

    private static final class PartImpl
    implements Part {
        private final FileItem _fileItem;
        private final String _multipartLocation;

        public void delete() throws IOException {
            this._fileItem.delete();
        }

        public String getContentType() {
            return this._fileItem.getContentType();
        }

        public String getHeader(String name) {
            return this._fileItem.getHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this._fileItem.getHeaderNames();
        }

        public Collection<String> getHeaders(String name) {
            return this._fileItem.getHeaders(name);
        }

        public InputStream getInputStream() throws IOException {
            return this._fileItem.getInputStream();
        }

        public String getName() {
            return this._fileItem.getFieldName();
        }

        public long getSize() {
            return this._fileItem.getSize();
        }

        public String getSubmittedFileName() {
            return this._fileItem.getFileName();
        }

        public void write(String fileName) throws IOException {
            if (Validator.isNull((String)fileName)) {
                throw new IOException("Invalid file name");
            }
            try {
                File multipartLocation;
                File file = new File(fileName);
                if (!file.isAbsolute() && Validator.isNotNull((String)this._multipartLocation) && (multipartLocation = new File(this._multipartLocation)).isDirectory()) {
                    file = new File(multipartLocation, fileName);
                }
                this._fileItem.write(file);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }

        private PartImpl(FileItem fileItem, String multipartLocation) {
            this._fileItem = fileItem;
            this._multipartLocation = multipartLocation;
        }
    }
}

