/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.servlet;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.events.StartupAction;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.upgrade.ReleaseManager;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.jaas.JAASHelper;
import com.liferay.portal.service.impl.LayoutTemplateLocalServiceImpl;
import com.liferay.portal.servlet.EncryptedServletRequest;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsResponse;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.setup.SetupWizardSampleDataUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.PortalRequestProcessor;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.struts.TilesUtil;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.struts.model.ModuleConfig;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.social.kernel.util.SocialConfigurationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class MainServlet
extends HttpServlet {
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)"off");
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)"partial");
    private static final String _LIFERAY_PORTAL_REQUEST_HEADER = "Liferay-Portal";
    private static final Log _log = LogFactoryUtil.getLog(MainServlet.class);
    private static volatile InactiveRequestHandler _inactiveRequestHandler = (InactiveRequestHandler)ServiceProxyFactory.newServiceTrackedInstance(InactiveRequestHandler.class, MainServlet.class, (String)"_inactiveRequestHandler", (boolean)false);
    private static volatile ReleaseManager _releaseManager = (ReleaseManager)ServiceProxyFactory.newServiceTrackedInstance(ReleaseManager.class, MainServlet.class, (String)"_releaseManager", (boolean)false);
    private ServiceRegistration<ModuleServiceLifecycle> _licenseInstallModuleServiceLifecycleServiceRegistration;
    private ServiceRegistration<ModuleServiceLifecycle> _portalInitializedModuleServiceLifecycleServiceRegistration;
    private ServiceRegistration<ModuleServiceLifecycle> _portalPortletsInitializedModuleServiceLifecycleServiceRegistration;
    private PortalRequestProcessor _portalRequestProcessor;
    private ServiceRegistration<ServletContext> _servletContextServiceRegistration;
    private ServiceRegistration<ModuleServiceLifecycle> _systemCheckModuleServiceLifecycleServiceRegistration;

    public void destroy() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy plugins");
        }
        DependencyManagerSyncUtil.sync();
        this._portalInitializedModuleServiceLifecycleServiceRegistration.unregister();
        this._portalPortletsInitializedModuleServiceLifecycleServiceRegistration.unregister();
        this._servletContextServiceRegistration.unregister();
        this._systemCheckModuleServiceLifecycleServiceRegistration.unregister();
        this._licenseInstallModuleServiceLifecycleServiceRegistration.unregister();
        PortalLifecycleUtil.flushDestroys();
        List portlets = PortletLocalServiceUtil.getPortlets();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy portlets");
        }
        try {
            this._destroyPortlets(portlets);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy companies");
        }
        try {
            this._destroyCompanies();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global shutdown events");
        }
        try {
            EventsProcessorUtil.process("global.shutdown.events", PropsValues.GLOBAL_SHUTDOWN_EVENTS);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this._portalRequestProcessor.process(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this._portalRequestProcessor.process(httpServletRequest, httpServletResponse);
    }

    public void init() throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize");
        }
        ServletContext servletContext = this.getServletContext();
        servletContext.setAttribute(MainServlet.class.getName(), (Object)Boolean.TRUE);
        this._portalRequestProcessor = new PortalRequestProcessor(servletContext, this._init());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verify JVM configuration");
        }
        if (_log.isWarnEnabled()) {
            TimeZone timeZone;
            String timeZoneID;
            if (!StringPool.DEFAULT_CHARSET_NAME.startsWith("UTF-")) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"The default JVM character set \"", StringPool.DEFAULT_CHARSET_NAME, "\" is not UTF. Please review the JVM property ", "\"file.encoding\"."}));
            }
            if (!Objects.equals("UTC", timeZoneID = (timeZone = TimeZone.getDefault()).getID()) && !Objects.equals("GMT", timeZoneID)) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"The default JVM time zone \"", timeZoneID, "\" is not UTC or GMT. Please review the JVM property ", "\"user.timezone\"."}));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process startup events");
        }
        try {
            StartupAction startupAction = new StartupAction();
            startupAction.run(null);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            System.out.println("Stopping the server due to unexpected startup errors");
            System.exit(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugin package");
        }
        PluginPackage pluginPackage = null;
        try {
            pluginPackage = PluginPackageUtil.readPluginPackageServletContext(servletContext);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize portlets");
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        try {
            portlets.addAll(this._initPortlets(pluginPackage));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        for (Portlet portlet : portlets) {
            try {
                ResourceActionsUtil.populatePortletResource((Portlet)portlet, (ClassLoader)MainServlet.class.getClassLoader(), (String[])PropsValues.RESOURCE_ACTIONS_CONFIGS);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        try {
            this._initLayoutTemplates(pluginPackage);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize social");
        }
        try {
            SocialConfigurationUtil.read((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (String[])new String[]{StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-social.xml")), StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-social-ext.xml"))});
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize web settings");
        }
        try {
            String xml = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/shielded-container-web.xml"));
            this._checkWebSettings(xml);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global startup events");
        }
        try {
            EventsProcessorUtil.process("global.startup.events", PropsValues.GLOBAL_STARTUP_EVENTS);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize resource actions");
        }
        try {
            this._initCompanies();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugins");
        }
        try {
            HotDeployUtil.setCapturePrematureEvents((boolean)false);
            PortalLifecycleUtil.flushInits();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        servletContext.setAttribute("STARTUP_FINISHED", (Object)Boolean.TRUE);
        StartupHelperUtil.setStartupFinished(true);
        this._registerPortalInitialized();
        if (_releaseManager != null && _log.isWarnEnabled()) {
            String message = _releaseManager.getStatusMessage(true);
            if (Validator.isNotNull((String)message)) {
                _log.warn((Object)message);
            } else if (_log.isInfoEnabled() && Validator.isNotNull((String)(message = _releaseManager.getStatusMessage(false)))) {
                _log.info((Object)message);
            }
        }
        if (StartupHelperUtil.isDBNew() && PropsValues.SETUP_WIZARD_ADD_SAMPLE_DATA) {
            try {
                SetupWizardSampleDataUtil.addSampleData(PortalInstances.getDefaultCompanyId());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        long companyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service request");
        }
        if (this._processShutdownRequest(httpServletRequest, httpServletResponse)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed shutdown request");
            }
            return;
        }
        if (this._processMaintenanceRequest(httpServletRequest, httpServletResponse)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed maintenance request");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, companyId = PortalInstances.getCompanyId(httpServletRequest))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed company inactive request");
            }
            return;
        }
        try {
            if (this._processGroupInactiveRequest(httpServletRequest, httpServletResponse)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Processed site inactive request");
                }
                return;
            }
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchLayoutException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
            }
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set portal port");
        }
        PortalUtil.setPortalInetSocketAddresses((HttpServletRequest)httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check variables");
        }
        httpServletRequest.setAttribute("CTX", (Object)this.getServletContext());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Encrypt request");
        }
        httpServletRequest = this._encryptRequest(httpServletRequest, companyId);
        long userId = PortalUtil.getUserId((HttpServletRequest)httpServletRequest);
        String remoteUser = this._getRemoteUser(httpServletRequest, userId);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Authenticate user id ", userId, " and remote user ", remoteUser}));
            }
            userId = this._loginUser(httpServletRequest, httpServletResponse, companyId, userId, remoteUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticated user id " + userId));
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set session thread local");
        }
        PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service pre events");
        }
        if (this._processServicePre(httpServletRequest, httpServletResponse, userId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing service pre events has errors");
            }
            return;
        }
        Object classNameAttribute = httpServletRequest.getAttribute(AbsoluteRedirectsResponse.class.getName());
        if (classNameAttribute != null) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest);
                _log.debug((Object)("Current URL " + currentURL + " has absolute redirect"));
            }
            return;
        }
        if (httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") == null) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest);
                _log.debug((Object)("Current URL " + currentURL + " does not have a theme display"));
            }
            return;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Call parent service");
            }
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process service post events");
            }
            try {
                EventsProcessorUtil.process("servlet.service.events.post", PropsValues.SERVLET_SERVICE_EVENTS_POST, httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private void _checkWebSettings(String xml) throws DocumentException {
        Document doc = UnsecureSAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        int timeout = PropsValues.SESSION_TIMEOUT;
        Element sessionConfig = root.element("session-config");
        if (sessionConfig != null) {
            String sessionTimeout = sessionConfig.elementText("session-timeout");
            timeout = GetterUtil.getInteger((String)sessionTimeout, (int)timeout);
        }
        PropsUtil.set("session.timeout", String.valueOf(timeout));
        PropsValues.SESSION_TIMEOUT = timeout;
        I18nServlet.setLanguageIds(root);
        I18nFilter.setLanguageIds(I18nServlet.getLanguageIds());
    }

    private void _destroyCompanies() throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> this._destroyCompany((long)companyId));
    }

    private void _destroyCompany(long companyId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process shutdown events");
        }
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _destroyPortlets(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            PortletInstanceFactoryUtil.destroy((Portlet)portlet);
            Map portletFilters = portlet.getPortletFilters();
            for (PortletFilter portletFilter : portletFilters.values()) {
                PortletFilterFactory.destroy(portletFilter);
            }
        }
    }

    private HttpServletRequest _encryptRequest(HttpServletRequest httpServletRequest, long companyId) {
        block3: {
            boolean encryptRequest = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"shuo");
            if (!encryptRequest) {
                return httpServletRequest;
            }
            try {
                Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
                httpServletRequest = new EncryptedServletRequest((HttpServletRequest)httpServletRequest, company.getKeyObj());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        return httpServletRequest;
    }

    private String _getRemoteUser(HttpServletRequest httpServletRequest, long userId) {
        HttpSession httpSession;
        String jRemoteUser;
        String remoteUser = httpServletRequest.getRemoteUser();
        if (!PropsValues.PORTAL_JAAS_ENABLE && (jRemoteUser = (String)(httpSession = httpServletRequest.getSession()).getAttribute("j_remoteuser")) != null) {
            remoteUser = jRemoteUser;
        }
        if (userId > 0L && remoteUser == null) {
            remoteUser = String.valueOf(userId);
        }
        return remoteUser;
    }

    private ModuleConfig _init() throws ServletException {
        try {
            TilesUtil.loadDefinitions(this.getServletContext());
            return this._initModuleConfig();
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initCompanies() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize companies");
        }
        if (StartupHelperUtil.isDBNew()) {
            CompanyLocalServiceUtil.addCompany(null, (String)PropsValues.COMPANY_DEFAULT_WEB_ID, (String)"localhost", (String)PropsValues.COMPANY_DEFAULT_WEB_ID, (boolean)false, (int)0, (boolean)true);
        }
        ServletContext servletContext = this.getServletContext();
        try {
            String[] webIds;
            for (String webId : webIds = PortalInstances.getWebIds()) {
                PortalInstances.initCompany(servletContext, webId);
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)PortalInstances.getDefaultCompanyId());
        }
    }

    private void _initLayoutTemplates(PluginPackage pluginPackage) {
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        for (String langType : LayoutTemplateLocalServiceImpl.supportedLangTypes) {
            StringBundler sb = new StringBundler(5);
            sb.append("(&(language.type=");
            sb.append(langType);
            sb.append(")(objectClass=");
            sb.append(TemplateManager.class.getName());
            sb.append("))");
            serviceLatch.waitFor(sb.toString());
        }
        serviceLatch.openOn(() -> {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Initialize layout templates");
                }
                ServletContext servletContext = this.getServletContext();
                List layoutTemplates = LayoutTemplateLocalServiceUtil.init((ServletContext)servletContext, (String[])new String[]{StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-layout-templates.xml")), StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-layout-templates-ext.xml"))}, (PluginPackage)pluginPackage);
                servletContext.setAttribute("PLUGIN_LAYOUT_TEMPLATES", (Object)layoutTemplates);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private ModuleConfig _initModuleConfig() throws Exception {
        ModuleConfig moduleConfig = new ModuleConfig();
        ServletContext servletContext = this.getServletContext();
        ClassLoader classLoader = MainServlet.class.getClassLoader();
        try (InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/struts-config.xml");){
            Document document = SAXReaderUtil.read((InputStream)inputStream, (boolean)false);
            Element rootElement = document.getRootElement();
            Element globalForwardsElement = rootElement.element("global-forwards");
            for (Element forwardElement : globalForwardsElement.elements("forward")) {
                moduleConfig.addActionForward(new ActionForward(forwardElement.attributeValue("name"), forwardElement.attributeValue("path")));
            }
            Element actionMappingsElement = rootElement.element("action-mappings");
            for (Element actionElement : actionMappingsElement.elements("action")) {
                Action action = null;
                String type = actionElement.attributeValue("type");
                if (type != null) {
                    Class<?> clazz = classLoader.loadClass(actionElement.attributeValue("type"));
                    action = (Action)clazz.newInstance();
                }
                ActionMapping actionMapping = new ActionMapping(moduleConfig, actionElement.attributeValue("forward"), actionElement.attributeValue("path"), action);
                for (Element forwardElement : actionElement.elements("forward")) {
                    actionMapping.addActionForward(new ActionForward(forwardElement.attributeValue("name"), forwardElement.attributeValue("path")));
                }
                moduleConfig.addActionMapping(actionMapping);
            }
        }
        return moduleConfig;
    }

    private void _initPortletApp(Portlet portlet, ServletContext servletContext) throws Exception {
        PortletApp portletApp = portlet.getPortletApp();
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        Set portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.create(portletFilter, portletContext);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    private List<Portlet> _initPortlets(PluginPackage pluginPackage) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[PropsValues.PORTLET_CONFIGS.length];
        for (int i = 0; i < PropsValues.PORTLET_CONFIGS.length; ++i) {
            xmls[i] = StreamUtil.toString((InputStream)servletContext.getResourceAsStream(PropsValues.PORTLET_CONFIGS[i]));
        }
        PortletLocalServiceUtil.initEAR((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(PortalClassLoaderUtil.getClassLoader());
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(false);
        List portlets = PortletLocalServiceUtil.getPortlets();
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = (Portlet)portlets.get(i);
            portletBagFactory.create(portlet);
            if (i != 0) continue;
            this._initPortletApp(portlet, servletContext);
        }
        servletContext.setAttribute("PLUGIN_PORTLETS", (Object)portlets);
        return portlets;
    }

    private long _loginUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long companyId, long userId, String remoteUser) throws PortalException {
        User user;
        if (userId > 0L || remoteUser == null) {
            return userId;
        }
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            try {
                userId = JAASHelper.getJaasUserId(companyId, remoteUser);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to sign in ", remoteUser, " in company ", companyId, " using JAAS: ", exception.getMessage()}), (Throwable)exception);
                }
            }
        } else {
            userId = GetterUtil.getLong((String)remoteUser);
        }
        if (!(user = UserLocalServiceUtil.getUserById((long)userId)).isDefaultUser()) {
            EventsProcessorUtil.process("login.events.pre", PropsValues.LOGIN_EVENTS_PRE, httpServletRequest, httpServletResponse);
            if (PropsValues.USERS_UPDATE_LAST_LOGIN || user.getLastLoginDate() == null) {
                user = UserLocalServiceUtil.updateLastLogin((long)userId, (String)httpServletRequest.getRemoteAddr());
            }
        }
        if (httpServletRequest.getAttribute("USER") != null) {
            httpServletRequest.setAttribute("USER", (Object)user);
            httpServletRequest.setAttribute("USER_ID", (Object)userId);
        }
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("LOCALE", (Object)user.getLocale());
        httpSession.setAttribute("USER", (Object)user);
        httpSession.setAttribute("USER_ID", (Object)userId);
        httpSession.removeAttribute("j_remoteuser");
        if (!user.isDefaultUser()) {
            EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, httpServletRequest, httpServletResponse);
        }
        return userId;
    }

    private boolean _processCompanyInactiveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long companyId) throws IOException {
        if (PortalInstances.isCompanyActive(companyId)) {
            return false;
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, "this-instance-is-inactive-please-contact-the-administrator");
        return true;
    }

    private boolean _processGroupInactiveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, PortalException {
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_l_id");
        if (plid <= 0L) {
            return false;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (GroupLocalServiceUtil.isLiveGroupActive((Group)layout.getGroup())) {
            return false;
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, "this-site-is-inactive-please-contact-the-administrator");
        return true;
    }

    private boolean _processMaintenanceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!MaintenanceUtil.isMaintaining()) {
            return false;
        }
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/html/portal/maintenance.jsp");
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        return true;
    }

    private boolean _processServicePre(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long userId) throws IOException, ServletException {
        try {
            EventsProcessorUtil.process("servlet.service.events.pre", PropsValues.SERVLET_SERVICE_EVENTS_PRE, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof NoSuchLayoutException) {
                PortalUtil.sendError((int)404, (Exception)((Exception)throwable), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
                return true;
            }
            if (throwable instanceof PrincipalException) {
                this._processServicePrePrincipalException(throwable, userId, httpServletRequest, httpServletResponse);
                return true;
            }
            _log.error((Throwable)exception);
            httpServletRequest.setAttribute(StrutsUtil.EXCEPTION, (Object)exception);
            StrutsUtil.forward(PropsValues.SERVLET_SERVICE_EVENTS_PRE_ERROR_PAGE, this.getServletContext(), httpServletRequest, httpServletResponse);
            if (exception == httpServletRequest.getAttribute(StrutsUtil.EXCEPTION)) {
                httpServletRequest.removeAttribute(StrutsUtil.EXCEPTION);
                httpServletRequest.removeAttribute("javax.servlet.error.exception");
                httpServletRequest.removeAttribute("javax.servlet.error.exception_type");
                httpServletRequest.removeAttribute("javax.servlet.error.message");
                httpServletRequest.removeAttribute("javax.servlet.error.request_uri");
                httpServletRequest.removeAttribute("javax.servlet.error.servlet_name");
                httpServletRequest.removeAttribute("javax.servlet.error.status_code");
            }
            return true;
        }
        if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
            if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                httpServletResponse.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getName());
            } else {
                httpServletResponse.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getReleaseInfo());
            }
        }
        return false;
    }

    private void _processServicePrePrincipalException(Throwable throwable, long userId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String redirect;
        block5: {
            if (userId > 0L || ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"p_p_lifecycle") == 2) {
                PortalUtil.sendError((int)401, (Exception)((Exception)throwable), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
                return;
            }
            String mainPath = PortalUtil.getPathMain();
            redirect = mainPath.concat("/portal/login");
            redirect = HttpComponentsUtil.addParameter((String)redirect, (String)"redirect", (String)PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest));
            long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_l_id");
            if (plid > 0L) {
                try {
                    redirect = HttpComponentsUtil.addParameter((String)redirect, (String)"refererPlid", (long)plid);
                    Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                    Group group = layout.getGroup();
                    plid = group.getDefaultPublicPlid();
                    if (plid == 0L || group.isStagingGroup()) {
                        Group guestGroup = GroupLocalServiceUtil.getGroup((long)layout.getCompanyId(), (String)"Guest");
                        plid = guestGroup.getDefaultPublicPlid();
                    }
                    redirect = HttpComponentsUtil.addParameter((String)redirect, (String)"p_l_id", (long)plid);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)exception);
                }
            }
        }
        httpServletResponse.sendRedirect(redirect);
    }

    private boolean _processShutdownRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!ShutdownUtil.isShutdown()) {
            return false;
        }
        String messageKey = ShutdownUtil.getMessage();
        if (Validator.isNull((String)messageKey)) {
            messageKey = "the-system-is-shutdown-please-try-again-later";
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, messageKey);
        return true;
    }

    private void _registerPortalInitialized() {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        this._portalInitializedModuleServiceLifecycleServiceRegistration = bundleContext.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"module.service.lifecycle", (Object)"portal.initialized").put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
        this._portalPortletsInitializedModuleServiceLifecycleServiceRegistration = bundleContext.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"module.service.lifecycle", (Object)"portlets.initialized").put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
        this._servletContextServiceRegistration = bundleContext.registerService(ServletContext.class, (Object)this.getServletContext(), (Dictionary)HashMapDictionaryBuilder.put((Object)"bean.id", (Object)ServletContext.class.getName()).put((Object)"original.bean", (Object)Boolean.TRUE).put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).build());
        this._systemCheckModuleServiceLifecycleServiceRegistration = bundleContext.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"module.service.lifecycle", (Object)"system.check").put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
        this._licenseInstallModuleServiceLifecycleServiceRegistration = bundleContext.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"module.service.lifecycle", (Object)"license.install").put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
    }
}

